/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc;

import com.sun.kvem.cdc.GraphicsDescriptor;
import org.apache.log4j.Logger;

class PNGProcessor {
    public static final Logger LOGGER = Logger.getLogger(GraphicsDescriptor.class);
    private static byte[] PNGsig = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static byte[] IDAT = new byte[]{73, 68, 65, 84};
    private static byte[] IEND = new byte[]{73, 69, 78, 68};
    private final int sizeLen = 4;
    private final int nameLen = 4;
    private final int crcLen = 4;
    private static final String ENABLE_TRANSPARENCY = "enablePNGtransparency";

    PNGProcessor() {
    }

    public boolean isPNGImage(byte[] byArray) {
        if (byArray.length < PNGsig.length) {
            return false;
        }
        return PNGProcessor.compare(byArray, 0, PNGsig, 0, PNGsig.length);
    }

    public boolean includesIEND(byte[] byArray, int n) {
        int n2 = PNGsig.length + n;
        try {
            while (true) {
                int n3 = PNGProcessor.getInt(byArray, n2) + 4 + 4 + 4;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)String.format("Found chunk %s, size %d", new String(byArray, n2 + 4, 4), n3));
                }
                if (PNGProcessor.compare(IEND, 0, byArray, n2 + 4, 4)) {
                    LOGGER.trace((Object)"IEND chunk found");
                    return true;
                }
                n2 += n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    private static int getInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    protected static boolean compare(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }
}

