/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.aut;

import com.sun.jme.toolkit.aut.UIDAccessor;
import com.sun.jme.toolkit.aut.Utils;
import com.sun.jme.toolkit.aut.proxy.JavaProxyDiscovery;
import com.sun.jme.toolkit.aut.proxy.ProxyDiscovery;
import com.sun.jme.toolkit.environment.WorkdirHelper;
import com.sun.jme.toolkit.tray.TrayIconManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class UpdateCenter
extends TimerTask {
    private static final Logger LOGGER = Logger.getLogger(UpdateCenter.class);
    private static final String VERSION_WINDOWS_PROPERTY = "version-win32";
    private static final String URL_WINDOWS_PROPERTY = "url-win32";
    private static final String VERSION_MACOSX_PROPERTY = "version-macosx";
    private static final String URL_MACOSX_PROPERTY = "url-macosx";
    private static final String VERSION_LINUX_PROPERTY = "version-linux";
    private static final String URL_LINUX_PROPERTY = "url-linux";
    private static final long TIMESTAMP_DOESNT_EXIST = -1L;
    private static final String DEFAULT_TIMESTAMP_FILE_NAME = ".stmp";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_UPDATE_TIMEOUT = 30000;
    private static final long DEFAULT_PERIOD = 864000000L;
    private static final String AGENT_TAG = "sjwtk/";
    boolean finished;
    private String uid;
    private long timestamp;
    private Properties properties;
    private String version;
    private String agent;
    private WorkdirHelper workdirHelper;
    private String url;
    private String timestampDir;
    private boolean enabled = true;
    private long period = 864000000L;
    private int updateTimeout = 30000;
    private int connectionTimeout = 10000;
    private String timestampFileName = ".stmp";
    private Set<Proxy> proxies = null;
    private List<ProxyDiscovery> proxyDiscoveries = new ArrayList<ProxyDiscovery>();
    private TrayIconManager trayManager;
    private UIDAccessor uidAccessor = new UIDAccessor(){

        @Override
        public String getSystemUID(String string) {
            return null;
        }

        @Override
        public boolean setSystemUID(String string, String string2) {
            return false;
        }
    };

    public void create() throws Exception {
        String string;
        this.finished = false;
        this.timestamp = -1L;
        this.uid = null;
        this.properties = null;
        try {
            string = URLEncoder.encode(System.getProperty("os.name"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = System.getProperty("os.name");
        }
        this.agent = AGENT_TAG + string;
        System.setProperty("http.agent", this.agent);
        this.timestampDir = System.getProperty("user.home") + File.separator + this.workdirHelper.getApplicationDataDirectory() + File.separator + this.workdirHelper.getToolkitsDirectory() + File.separator + this.workdirHelper.getReleaseDirectory() + File.separator + this.workdirHelper.getWorkDirectory();
        this.addProxyDiscovery(new JavaProxyDiscovery());
    }

    public void start() throws Exception {
        if (this.enabled) {
            new Timer().scheduleAtFixedRate((TimerTask)this, 0L, this.period);
        }
    }

    public void stop() throws Exception {
        this.cancel();
    }

    public void setTrayIconManager(TrayIconManager trayIconManager) {
        this.trayManager = trayIconManager;
    }

    public void setProxyDiscoveries(String[] stringArray) {
        for (String string : stringArray) {
            try {
                Class<?>[] classArray;
                Class<?> clazz = Class.forName(string);
                for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                    if (ProxyDiscovery.class != clazz2) continue;
                    this.proxyDiscoveries.add((ProxyDiscovery)clazz.newInstance());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.warn((Object)("When adding: " + string), (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                LOGGER.warn((Object)("Can't instantiate " + string), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.warn((Object)("When adding: " + string), (Throwable)illegalAccessException);
            }
        }
    }

    public void addProxyDiscovery(ProxyDiscovery proxyDiscovery) {
        this.proxyDiscoveries.add(proxyDiscovery);
    }

    public void setUIDAccessor(UIDAccessor uIDAccessor) {
        this.uidAccessor = uIDAccessor;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setPeriod(int n) {
        this.period = 86400000L * (long)n;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public void setUpdateTimeout(int n) {
        this.updateTimeout = n;
    }

    public void setWorkdirHelper(WorkdirHelper workdirHelper) {
        this.workdirHelper = workdirHelper;
    }

    public void setTimestampFileName(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.timestampFileName = string;
    }

    private long getTimestamp() {
        if (this.timestamp == -1L) {
            this.timestamp = this.readTimestamp();
        }
        return this.timestamp;
    }

    private boolean hasTimeElapsed() {
        long l = this.getTimestamp();
        long l2 = System.currentTimeMillis();
        return l == -1L || l2 - l > this.period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateTimestamp(String string) {
        if (string == null) {
            return -1L;
        }
        long l = -1L;
        String string2 = this.timestampDir + File.separator + this.timestampFileName;
        File file = new File(string2);
        LOGGER.trace((Object)("Update timestamp : " + file.getAbsolutePath()));
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(file);
            printWriter.print(string);
            printWriter.flush();
            l = file.lastModified();
        }
        catch (IOException iOException) {
            LOGGER.trace((Object)"Can't update timestamp:", (Throwable)iOException);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            LOGGER.trace((Object)("Timestamp written to: " + file));
        }
        return l;
    }

    private String getUID() {
        if (this.uid == null) {
            String string = this.readUID();
            if (string != null) {
                this.uid = string;
            } else {
                return null;
            }
        }
        return this.uid;
    }

    private void setUID(String string) {
        this.uid = string;
    }

    private long readTimestamp() {
        String string = this.timestampDir + File.separator + this.timestampFileName;
        File file = new File(string);
        if (file.exists()) {
            return file.lastModified();
        }
        LOGGER.trace((Object)"Timestamp file doesn't exist!");
        return -1L;
    }

    private void setData(Properties properties) {
        this.properties = properties;
    }

    private synchronized String getUpdateProperty(String string) {
        if (this.properties == null) {
            try {
                if (this.proxies == null) {
                    this.proxies = this.guessProxies();
                }
                boolean bl = this.checkForUpdates(this.proxies);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Check for updates failed !", (Throwable)exception);
            }
        }
        return this.properties == null ? null : this.properties.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readUID() {
        block6: {
            String string;
            String string2 = this.timestampDir + File.separator + this.timestampFileName;
            File file = new File(string2);
            if (!file.exists()) break block6;
            long l = file.lastModified();
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string3 = bufferedReader.readLine();
                if (string3 != null) {
                    this.uid = string3.trim();
                }
                string = this.uid;
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    LOGGER.error((Object)exception, (Throwable)exception);
                }
            }
            bufferedReader.close();
            return string;
        }
        return null;
    }

    private String fixServerURL(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(this.version, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = this.version;
        }
        String string3 = String.format(string, this.getUID(), string2);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForUpdates(Set<Proxy> set) throws MalformedURLException {
        String string = this.fixServerURL(this.url);
        URL uRL = new URL(string);
        Observer observer = new Observer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void update(Observable observable, Object object) {
                Connector connector = (Connector)observable;
                if (UpdateCenter.this.finished) {
                    return;
                }
                LOGGER.trace((Object)("Notified from connector: " + connector));
                Properties properties = (Properties)object;
                if (properties != null && !properties.isEmpty()) {
                    UpdateCenter.this.finished = true;
                    UpdateCenter.this.setData(properties);
                    UpdateCenter updateCenter = UpdateCenter.this;
                    synchronized (updateCenter) {
                        UpdateCenter.this.notifyAll();
                    }
                }
            }
        };
        Vector<Thread> vector = new Vector<Thread>();
        for (Proxy object : set) {
            if (this.finished) continue;
            Thread thread = new Thread(new Connector(object, uRL, observer));
            vector.add(thread);
            thread.start();
        }
        Iterator iterator = this;
        synchronized (iterator) {
            try {
                if (!this.finished) {
                    LOGGER.trace((Object)"Waiting until at least one connector finishes successfuly.");
                    this.wait(this.updateTimeout);
                    if (this.finished) {
                        LOGGER.trace((Object)"Done. Update server responded!");
                    } else {
                        LOGGER.warn((Object)"Timeout has been reached !");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn((Object)interruptedException, (Throwable)interruptedException);
            }
        }
        for (Thread thread : vector) {
            if (!thread.isAlive()) continue;
            try {
                LOGGER.trace((Object)("Kill: " + thread));
                thread.interrupt();
            }
            catch (SecurityException securityException) {
                LOGGER.warn((Object)securityException, (Throwable)securityException);
            }
        }
        vector.clear();
        vector = null;
        return this.finished;
    }

    private Set<Proxy> guessProxies() {
        if (this.proxyDiscoveries == null || this.proxyDiscoveries.size() == 0) {
            return null;
        }
        HashSet<Proxy> hashSet = new HashSet<Proxy>();
        for (ProxyDiscovery proxyDiscovery : this.proxyDiscoveries) {
            Proxy proxy = proxyDiscovery.getProxy();
            if (proxy == null || hashSet.add(proxy)) continue;
            LOGGER.warn((Object)("Proxy " + proxy + "already in the set."));
        }
        return hashSet;
    }

    @Override
    public void run() {
        LOGGER.debug((Object)"Checking for product update ... ");
        if (this.period == 0L || this.url == null || this.url.length() == 0) {
            return;
        }
        if (this.hasTimeElapsed()) {
            String string = this.getUID();
            if (string == null || string != null && !Utils.isUIDValid(string)) {
                string = this.uidAccessor.getSystemUID(this.version);
                if (string == null) {
                    string = Utils.createUID();
                    LOGGER.debug((Object)"Generated new UID");
                    this.uidAccessor.setSystemUID(this.version, string);
                }
                LOGGER.debug((Object)("UID: " + string));
                this.setUID(string);
            }
            this.updateTimestamp(this.uid);
            this.properties = null;
            String string2 = this.getUpdateProperty(VERSION_WINDOWS_PROPERTY);
            String string3 = this.getUpdateProperty(URL_WINDOWS_PROPERTY);
            if (string2 != null && !string2.equals(this.version)) {
                this.showMessage("Latest Windows version available.", string2 + "\n" + string3);
            }
            string2 = this.getUpdateProperty(VERSION_MACOSX_PROPERTY);
            string3 = this.getUpdateProperty(URL_MACOSX_PROPERTY);
            if (string2 != null && !string2.equals(this.version)) {
                this.showMessage("Latest Mac OSX version available.", string2 + "\n" + string3);
            }
            string2 = this.getUpdateProperty(VERSION_LINUX_PROPERTY);
            string3 = this.getUpdateProperty(URL_LINUX_PROPERTY);
            if (string2 != null && !string2.equals(this.version)) {
                this.showMessage("Latest Linux version available.", string2 + "\n" + string3);
            }
        }
    }

    private void showMessage(String string, String string2) {
        if (this.trayManager != null) {
            this.trayManager.showMessage(string, string2);
        }
        LOGGER.info((Object)("Show message:" + string + "\n" + string2));
    }

    class Connector
    extends Observable
    implements Runnable {
        private Properties data;
        private Proxy proxy;
        private URL url;
        private HttpURLConnection con;

        Connector(Proxy proxy, URL uRL, Observer observer) {
            this.addObserver(observer);
            this.data = new Properties();
            this.proxy = proxy;
            this.url = uRL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.trace((Object)("Opening connection to: " + this.url + " via proxy: " + this.proxy + " agent: " + System.getProperty("http.agent")));
                this.con = (HttpURLConnection)this.url.openConnection(this.proxy);
                this.con.setConnectTimeout(UpdateCenter.this.connectionTimeout);
                this.con.setUseCaches(false);
                int n = this.con.getResponseCode();
                if (200 == n) {
                    InputStream inputStream = this.con.getInputStream();
                    if (inputStream != null) {
                        this.data.load(inputStream);
                    }
                } else {
                    LOGGER.warn((Object)("Update server response code: " + n));
                }
            }
            catch (UnknownHostException unknownHostException) {
                LOGGER.warn((Object)("Unknown host exception for url:" + this.url + " opened via proxy: " + this.proxy));
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Error reading stream.", (Throwable)iOException);
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception, (Throwable)exception);
            }
            finally {
                this.setChanged();
                this.notifyObservers(this.data);
            }
        }
    }
}

