/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.aut;

import com.sun.jme.toolkit.aut.proxy.ProxyDiscovery;
import com.sun.kvem.environment.Debug;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.zip.CRC32;

public class Utils {
    public static ProxyDiscovery[] discoveries = null;
    public static Debug debug = Debug.create(Utils.class);

    private Utils() {
    }

    public static String createUID() {
        try {
            long l = System.currentTimeMillis();
            byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL)};
            byte[] byArray2 = InetAddress.getLocalHost().getAddress();
            int n = System.identityHashCode(new Object());
            byte[] byArray3 = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            int n2 = secureRandom.nextInt();
            byte[] byArray4 = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray4, 0, byArray4.length);
            cRC32.update(byArray3, 0, byArray3.length);
            cRC32.update(byArray2, 0, byArray2.length);
            cRC32.update(byArray, 0, byArray.length);
            long l2 = cRC32.getValue();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Utils.hexEncode(byArray4));
            stringBuffer.append(Utils.hexEncode(byArray3));
            stringBuffer.append(Utils.hexEncode(byArray2));
            stringBuffer.append(Utils.hexEncode(byArray));
            stringBuffer.append(Long.toHexString(l2));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            debug.exception(3, (Throwable)exception);
            return null;
        }
    }

    public static boolean isUIDValid(String string) {
        if (string == null || string.length() != 40) {
            debug.println(3, "UID is invalid (null or incorrect length) !");
            return false;
        }
        String string2 = string.substring(32);
        String string3 = string.substring(0, 32);
        byte[] byArray = new byte[16];
        int n = 0;
        for (int i = 0; i < 31; i += 2) {
            String string4 = string3.substring(i, i + 2);
            byArray[n] = (byte)Integer.parseInt(string4, 16);
            ++n;
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        long l = cRC32.getValue();
        String string5 = Long.toHexString(l);
        boolean bl = string5.equalsIgnoreCase(string2);
        if (!bl) {
            debug.println(3, "UID failed crc checksum!");
        }
        return bl;
    }

    public static String hexEncode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(cArray[(by & 0xF0) >> 4]);
            stringBuffer.append(cArray[by & 0xF]);
        }
        return stringBuffer.toString();
    }
}

