/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.aut.proxy;

import com.sun.jme.toolkit.aut.proxy.ProxySettingsParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class ProxyDiscovery {
    private static final Logger LOGGER = Logger.getLogger(ProxyDiscovery.class);
    static final String EMPTY = "";
    Proxy proxyCache;

    public abstract Proxy findProxy();

    public Proxy getProxy() {
        if (this.proxyCache == null) {
            this.proxyCache = this.findProxy();
        }
        return this.proxyCache;
    }

    Proxy scanSettingsForProxy(File file, final Pattern pattern, ProxySettingsParser proxySettingsParser) {
        try {
            int n;
            if (file == null || !file.exists()) {
                return null;
            }
            String[] stringArray = null;
            String[] stringArray2 = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return ProxyDiscovery.this.matches(string, pattern);
                }
            });
            if (stringArray2 != null && (n = 0) < stringArray2.length) {
                File file2 = new File(file, stringArray2[n]);
                stringArray = proxySettingsParser.parse(file2);
                if (stringArray == null || stringArray.length < 2) {
                    return null;
                }
                String string = stringArray[0];
                String string2 = stringArray[1];
                if (string != null && string2 != null) {
                    if (string.equals(EMPTY) && string2.equals(EMPTY)) {
                        return Proxy.NO_PROXY;
                    }
                    int n2 = Integer.parseInt(string2);
                    return new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(string, n2));
                }
                return null;
            }
            File[] fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            Object var7_9 = null;
            Proxy proxy = null;
            for (int i = 0; fileArray != null && i < fileArray.length && var7_9 == null; ++i) {
                proxy = this.scanSettingsForProxy(fileArray[i], pattern, proxySettingsParser);
                if (null == proxy) continue;
                return proxy;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)illegalArgumentException, (Throwable)illegalArgumentException);
        }
        catch (SecurityException securityException) {
            LOGGER.error((Object)securityException, (Throwable)securityException);
        }
        return null;
    }

    private boolean matches(String string, Pattern pattern) {
        return pattern.matcher(string).matches();
    }
}

