/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.server.rmiimpl;

import com.sun.jme.toolkit.remoting.client.api.CallbackRegistration;
import com.sun.jme.toolkit.remoting.server.api.ObjectServer;
import com.sun.jme.toolkit.remoting.server.rmiimpl.CallbackServerImplMBean;
import com.sun.jme.toolkit.remoting.shared.rmiimpl.CallbackNotification;
import com.sun.jme.toolkit.remoting.shared.rmiimpl.CallbackServer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.apache.log4j.Logger;

public class CallbackServerImpl
extends NotificationBroadcasterSupport
implements CallbackServerImplMBean {
    private static Logger log = Logger.getLogger(CallbackServerImpl.class);
    private Map<Long, CallbackEntry> callbacks = new HashMap<Long, CallbackEntry>();
    private long lastId = 0L;
    private ObjectServer objectServer;

    public CallbackServerImpl(ObjectServer objectServer) {
        log.debug((Object)"CallbackServer created");
        this.objectServer = objectServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerCallback(String string, Class clazz, CallbackRegistration callbackRegistration) throws Exception {
        log.debug((Object)("Registering callback on " + string + " with " + clazz.getSimpleName()));
        long l = this.lastId++;
        Object object = this.objectServer.findLocalObject(string);
        if (object == null) {
            throw new Exception("Can't find object: " + string);
        }
        Object object2 = this.createListnerProxy(l, clazz, string);
        callbackRegistration.registerWith(object2, object);
        Map<Long, CallbackEntry> map = this.callbacks;
        synchronized (map) {
            this.callbacks.put(l, new CallbackEntry(l, object, object2, callbackRegistration));
        }
        log.debug((Object)("Callback succesfully registered with id " + l + "."));
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(long l) throws Exception {
        CallbackEntry callbackEntry = null;
        log.debug((Object)("Removing callback with id " + l));
        Map<Long, CallbackEntry> map = this.callbacks;
        synchronized (map) {
            callbackEntry = this.callbacks.remove(l);
        }
        if (callbackEntry == null) {
            log.debug((Object)("Callback " + l + " not found, nothing done."));
            return;
        }
        callbackEntry.registration.unregisterFrom(callbackEntry.listenerProxy, callbackEntry.source);
        log.debug((Object)("Callback " + l + " removed from object."));
    }

    private void sendInvocationNotification(long l, String string, Method method, Object[] objectArray) {
        CallbackNotification callbackNotification = new CallbackNotification(l, (CallbackServer)this, string, method.getName(), (Class[])method.getParameterTypes(), objectArray);
        this.sendNotification((Notification)callbackNotification);
        log.debug((Object)("sendInvocationNotification " + l + ' ' + string + ' ' + method.getName()));
    }

    private Object createListnerProxy(long l, Class clazz, String string) {
        Class[] classArray = new Class[]{CallbackProxy.class, clazz};
        return Proxy.newProxyInstance(CallbackServerImpl.class.getClassLoader(), classArray, (InvocationHandler)new CallbackInvocationHandler(l, string));
    }

    class CallbackEntry {
        long id;
        Object source;
        Object listenerProxy;
        CallbackRegistration registration;

        public CallbackEntry(long l, Object object, Object object2, CallbackRegistration callbackRegistration) {
            this.id = l;
            this.source = object;
            this.listenerProxy = object2;
            this.registration = callbackRegistration;
        }
    }

    class CallbackInvocationHandler
    implements InvocationHandler {
        private String objectName;
        private long id;

        public CallbackInvocationHandler(long l, String string) {
            this.objectName = string;
            this.id = l;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if ("equals".equals(method.getName())) {
                Object object2 = objectArray[0];
                if (Proxy.isProxyClass(object2.getClass()) && object2 instanceof CallbackProxy) {
                    CallbackProxy callbackProxy = (CallbackProxy)object2;
                    return this.id == callbackProxy.getCallbackId();
                }
                return false;
            }
            if ("hashCode".equals(method.getName())) {
                return (int)this.id;
            }
            if ("toString".equals(method.getName())) {
                return "CallbackProxy(" + this.id + ")";
            }
            if ("getCallbackId".equals(method.getName())) {
                return this.id;
            }
            CallbackServerImpl.this.sendInvocationNotification(this.id, this.objectName, method, objectArray);
            return null;
        }
    }

    public static interface CallbackProxy {
        public long getCallbackId();
    }
}

