/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.server.rmiimpl;

import com.sun.jme.toolkit.remoting.server.api.ObjectServer;
import com.sun.jme.toolkit.remoting.server.rmiimpl.CallbackServerImpl;
import com.sun.jme.toolkit.remoting.shared.rmiimpl.CallbackServer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ObjectServerImpl
implements ObjectServer,
Context {
    private String name;
    private CallbackServer callbackServer;
    protected transient MBeanServer mBeanServer;
    private Map<String, Object> localRegistry = new HashMap<String, Object>();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ObjectServerImpl() {
        this.mBeanServer = MBeanServerFactory.createMBeanServer();
    }

    public void start() throws Exception {
        this.callbackServer = new CallbackServerImpl(this);
        this.registerObject(this.callbackServer, "CallbackServer");
    }

    public void stop() throws Exception {
        this.unregisterObject("CallbackServer");
        this.callbackServer = null;
    }

    public void registerObject(Object object, String string) {
        try {
            this.localRegistry.put(string, object);
            this.mBeanServer.registerMBean(object, ObjectServerImpl.objectName(string));
        }
        catch (JMException jMException) {
            throw new IllegalArgumentException(jMException);
        }
    }

    public void unregisterObject(String string) {
        try {
            this.localRegistry.remove(string);
            this.mBeanServer.unregisterMBean(ObjectServerImpl.objectName(string));
        }
        catch (JMException jMException) {
            throw new IllegalArgumentException(jMException);
        }
    }

    public Object findLocalObject(String string) {
        return this.localRegistry.get(string);
    }

    private static ObjectName objectName(String string) throws MalformedObjectNameException {
        return ObjectName.getInstance(":object=" + string);
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.findLocalObject(string);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        try {
            this.registerObject(object, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void unbind(String string) throws NamingException {
        try {
            this.unregisterObject(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException();
    }
}

