/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.server.rmiimpl;

import com.sun.jme.toolkit.remoting.server.rmiimpl.ObjectServerImpl;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashMap;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

public class RemotingConnectorImpl {
    private int rmiRegistryPort;
    private String rmiRegistryHost;
    private String name;
    private RMIServerSocketFactory serverSocketFactory;
    private RMIClientSocketFactory clientSocketFactory;
    private transient JMXConnectorServer connectorServer;
    private transient ObjectServerImpl objectServerImpl;
    private static final Logger LOGGER = Logger.getLogger(RemotingConnectorImpl.class);

    public void setRmiRegistryPort(int n) {
        this.rmiRegistryPort = n;
    }

    public void setRmiRegistryHost(String string) {
        this.rmiRegistryHost = string;
    }

    public void setObjectServerImpl(ObjectServerImpl objectServerImpl) {
        this.objectServerImpl = objectServerImpl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setServerSocketFactory(RMIServerSocketFactory rMIServerSocketFactory) {
        this.serverSocketFactory = rMIServerSocketFactory;
    }

    public void setClientSocketFactory(RMIClientSocketFactory rMIClientSocketFactory) {
        this.clientSocketFactory = rMIClientSocketFactory;
    }

    public void start() throws Exception {
        JMXServiceURL jMXServiceURL = new JMXServiceURL(this.jmxServiceUrl());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.clientSocketFactory != null) {
            hashMap.put("jmx.remote.rmi.client.socket.factory", this.clientSocketFactory);
        }
        if (this.serverSocketFactory != null) {
            hashMap.put("jmx.remote.rmi.server.socket.factory", this.serverSocketFactory);
        }
        LOGGER.info((Object)("Starting JMX connector on " + jMXServiceURL));
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, this.objectServerImpl.mBeanServer);
        this.connectorServer.start();
    }

    public void stop() throws Exception {
        this.connectorServer.stop();
        this.connectorServer = null;
    }

    private String jmxServiceUrl() {
        return "service:jmx:rmi:///jndi/rmi://" + this.rmiRegistryHost + ":" + this.rmiRegistryPort + "/" + (this.name != null ? this.name : this.objectServerImpl.getName());
    }
}

