/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.bridge;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;

public class JavameNetworking {
    private static final Logger LOGGER = Logger.getLogger(JavameNetworking.class);
    private InetAddress serverAddress;
    private int serverPortNumber;
    private ServerSocket notificationServerSocket;
    private int timeout;

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(InetAddress inetAddress) {
        this.serverAddress = inetAddress;
    }

    public int getServerPortNumber() {
        return this.serverPortNumber;
    }

    public void setServerportNumber(int n) {
        this.serverPortNumber = n;
    }

    public ServerSocket getNotificationServerSocket() {
        return this.notificationServerSocket;
    }

    public void create() {
        try {
            LOGGER.debug((Object)("Opening socket with timeout " + this.timeout));
            this.notificationServerSocket = new ServerSocket(0);
            this.notificationServerSocket.setSoTimeout(this.timeout);
            this.serverAddress = InetAddress.getLocalHost();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"Can't create JavameNetworking object", (Throwable)iOException);
        }
    }

    public void start() throws IOException {
        try {
            LOGGER.debug((Object)"Waiting for serverPortNumber");
            this.serverPortNumber = this.receiveRemotingPortNumber();
            LOGGER.debug((Object)("serverPortNumber=" + this.serverPortNumber));
            LOGGER.debug((Object)("serverAddress=" + this.serverPortNumber));
        }
        catch (SocketTimeoutException socketTimeoutException) {
            LOGGER.warn((Object)"JavaME side did not connect!");
            throw socketTimeoutException;
        }
        finally {
            try {
                this.notificationServerSocket.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveRemotingPortNumber() throws IOException {
        Socket socket = this.notificationServerSocket.accept();
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            try {
                n = dataInputStream.readInt();
            }
            catch (Throwable throwable) {
                dataInputStream.close();
                throw throwable;
            }
            dataInputStream.close();
            return n;
        }
        finally {
            socket.close();
        }
    }
}

