/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.bridge;

import com.sun.jme.remoting.CommException;
import com.sun.jme.remoting.DefaultNamedObjectRegistry;
import com.sun.jme.remoting.NamedObjectRegistry;
import com.sun.jme.remoting.RemotingHandler;
import com.sun.jme.toolkit.remoting.bridge.JavameNetworking;
import com.sun.jme.toolkit.remoting.bridge.JavameRemotingServiceListener;
import com.sun.jme.toolkit.remoting.bridge.SocketConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public final class JavameRemotingService {
    private static final Logger LOGGER = Logger.getLogger(JavameRemotingService.class);
    private final JavameRemotingServiceListener listener;
    private DefaultNamedObjectRegistry namedObjectRegistry;
    private RemotingHandler remotingHandler;
    private Socket commSocket;
    private Thread thread;
    private boolean closed;
    private JavameNetworking javameNetworking;
    private SocketConfiguration socketConfiguration;

    public JavameRemotingService() {
        this(null);
    }

    public JavameRemotingService(JavameRemotingServiceListener javameRemotingServiceListener) {
        this.listener = javameRemotingServiceListener;
    }

    public void setJavameNetworking(JavameNetworking javameNetworking) {
        this.javameNetworking = javameNetworking;
    }

    public void setSocketConfiguration(SocketConfiguration socketConfiguration) {
        this.socketConfiguration = socketConfiguration;
    }

    public void registerRemotableObject(String string, Object object, Class clazz) {
        this.namedObjectRegistry.registerRemotableObject(string, object, clazz);
    }

    public void registerObjectStubClass(String string, Class clazz) {
        this.namedObjectRegistry.registerObjectStubClass(string, clazz);
    }

    public <T> T getRemoteObjectReference(String string, Class<T> clazz) throws CommException {
        return clazz.cast(this.remotingHandler.getRemoteObjectReference(string));
    }

    public <T> T getRemoteObject(String string, Class<T> clazz) throws CommException {
        return clazz.cast(this.remotingHandler.getRemoteObject(string));
    }

    public void versionCheck() throws CommException {
        this.remotingHandler.versionCheck();
    }

    public InetAddress getHostAddress() {
        return this.commSocket.getLocalAddress();
    }

    public void start() throws IOException {
        try {
            this.namedObjectRegistry = new DefaultNamedObjectRegistry();
            this.commSocket = new Socket();
            if (this.socketConfiguration != null) {
                this.socketConfiguration.applyTo(this.commSocket);
            }
            this.commSocket.connect(new InetSocketAddress(this.javameNetworking.getServerAddress(), this.javameNetworking.getServerPortNumber()));
            LOGGER.debug((Object)("Succesfully opened socket at " + this.javameNetworking.getServerAddress() + ":" + this.javameNetworking.getServerPortNumber()));
            this.remotingHandler = RemotingHandler.createInstance((NamedObjectRegistry)this.namedObjectRegistry, (InputStream)new BufferedInputStream(this.commSocket.getInputStream()), (OutputStream)new BufferedOutputStream(this.commSocket.getOutputStream()));
            this.thread = new Thread("Remoting service"){

                @Override
                public void run() {
                    JavameRemotingService.this.threadRun();
                }
            };
            this.thread.start();
        }
        catch (IOException iOException) {
            LOGGER.trace((Object)"Can't start JavameRemotingService", (Throwable)iOException);
            throw iOException;
        }
    }

    public void stop() {
        this.remotingHandler.stopDispatchingLoop();
        this.closeSocket();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadRun() {
        this.remotingHandler.executeDispatchingLoop();
        this.closeSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        boolean bl = false;
        JavameRemotingService javameRemotingService = this;
        synchronized (javameRemotingService) {
            if (!this.closed) {
                try {
                    this.commSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.closed = true;
                bl = true;
            }
        }
        if (bl && this.listener != null) {
            this.listener.serviceStopped(this);
        }
    }
}

