/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.remoting.bridge;

import com.sun.jme.toolkit.remoting.bridge.JavameRemotingService;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public final class SocketConfiguration {
    private static final Logger LOGGER = Logger.getLogger(JavameRemotingService.class);
    private boolean keepAlive;
    private boolean reuseAddress;
    private boolean tcpNoDelay;
    private int soLinger = -1;
    private int soTimeout;
    private int receiveBufferSize;
    private int sendBufferSize;

    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    public void setReuseAddress(boolean bl) {
        this.reuseAddress = bl;
    }

    public void setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    public void setSoLinger(int n) {
        this.soLinger = n;
    }

    public void setSoTimeout(int n) {
        this.soTimeout = n;
    }

    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n;
    }

    public void setSendBufferSize(int n) {
        this.sendBufferSize = n;
    }

    public void applyTo(Socket socket) throws IOException {
        LOGGER.debug((Object)"Setting socket options...");
        socket.setKeepAlive(this.keepAlive);
        socket.setReuseAddress(this.reuseAddress);
        socket.setTcpNoDelay(this.tcpNoDelay);
        socket.setSoLinger(this.soLinger >= 0, this.soLinger >= 0 ? this.soLinger : 0);
        socket.setSoTimeout(this.soTimeout);
        if (this.receiveBufferSize > 0) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize > 0) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Socket options set successfully:");
            LOGGER.debug((Object)("  keep alive: " + socket.getKeepAlive()));
            LOGGER.debug((Object)("  reuse address: " + socket.getReuseAddress()));
            LOGGER.debug((Object)("  tcp no delay: " + socket.getTcpNoDelay()));
            LOGGER.debug((Object)("  so linger: " + socket.getSoLinger()));
            LOGGER.debug((Object)("  so timeout: " + socket.getSoTimeout()));
            LOGGER.debug((Object)("  recv buffer size: " + socket.getReceiveBufferSize()));
            LOGGER.debug((Object)("  send buffer size: " + socket.getSendBufferSize()));
        }
    }
}

