/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ui.about;

import com.sun.jme.toolkit.ui.about.ResourceButton;
import com.sun.kvem.util.ClipboardUtils;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.util.WindowUtils;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ButtonPanel
extends JPanel {
    private Dialog ownerFrame;

    public void setOwnerFrame(Dialog dialog) {
        this.ownerFrame = dialog;
    }

    public ButtonPanel(Dialog dialog) {
        this.ownerFrame = dialog;
        this.add(this.okButton());
        try {
            ToolkitResources.getBundle().getString("MORE_INFORMATION");
            this.add(this.buttonMore());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private JButton okButton() {
        JButton jButton = this.buttonOk();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonPanel.this.ownerFrame.setVisible(false);
            }
        });
        return jButton;
    }

    private JButton buttonMore() {
        ResourceButton resourceButton = new ResourceButton("MORE_INFORMATION", "showConfiguration");
        resourceButton.setFocusable(true);
        resourceButton.setToolTipText(ToolkitResources.getString((String)"MORE_INFORMATION_HELP"));
        resourceButton.setMnemonic(ToolkitResources.getString((String)"MORE_INFORMATION_SHORTCUT").charAt(0));
        resourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonPanel.this.showConfiguration();
            }
        });
        return resourceButton;
    }

    public void showConfiguration() {
        final JDialog jDialog = new JDialog(this.ownerFrame, true);
        DefaultFocusTraversalPolicy defaultFocusTraversalPolicy = new DefaultFocusTraversalPolicy();
        jDialog.setFocusTraversalPolicy(defaultFocusTraversalPolicy);
        String string = ToolkitResources.getString((String)"CONFIG_DIALOG_TITLE");
        jDialog.setTitle(string);
        AccessibleContext accessibleContext = jDialog.getAccessibleContext();
        accessibleContext.setAccessibleName("About dialog");
        accessibleContext.setAccessibleDescription("A dialog with information about the CDC Toolkit");
        JButton jButton = this.buttonCopy();
        JButton jButton2 = this.buttonOk();
        JPanel jPanel = new JPanel();
        jPanel.add(jButton2);
        jPanel.add(jButton);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ok")) {
                    jDialog.setVisible(false);
                    jDialog.dispose();
                } else if (actionEvent.getActionCommand().equals("copy")) {
                    ClipboardUtils.copy((String)ButtonPanel.configString());
                }
            }
        };
        jButton2.addActionListener(actionListener);
        jButton.addActionListener(actionListener);
        jDialog.getContentPane().add("South", jPanel);
        jDialog.getContentPane().add(this.scrollPane());
        jDialog.pack();
        WindowUtils.center((Window)jDialog, (Window)jDialog);
        jDialog.setVisible(true);
        jButton2.requestFocus();
    }

    static String configString() {
        String[] stringArray = new String[]{"java.vendor", "JAVA_VENDOR", "java.version", "JAVA_VERSION", "os.name", "OS_NAME", "os.version", "OS_VERSION", "os.arch", "OS_ARCH", "user.region", "REGION", "user.language", "LANGUAGE", "emulator.home", "INSTALL_DIR"};
        StringBuffer stringBuffer = new StringBuffer(ToolkitResources.getString((String)"VERSION_HTML"));
        Object[] objectArray = new Object[2];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = System.getProperty(stringArray[i]);
            if (string == null) continue;
            String string2 = ToolkitResources.getString((String)stringArray[++i]);
            stringBuffer.append("\n");
            objectArray[0] = string2;
            objectArray[1] = string;
            String string3 = ToolkitResources.format((String)"PROPERTY_FORMAT", (Object[])objectArray);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private JButton buttonOk() {
        ResourceButton resourceButton = new ResourceButton("OK", "ok");
        resourceButton.setFocusable(true);
        resourceButton.setToolTipText(ToolkitResources.getString((String)"OK_HELP"));
        resourceButton.setMnemonic(ToolkitResources.getString((String)"OK_SHORTCUT").charAt(0));
        return resourceButton;
    }

    private JButton buttonCopy() {
        ResourceButton resourceButton = new ResourceButton("COPY_TO_CLIPBOARD", "copy");
        resourceButton.setFocusable(true);
        resourceButton.setToolTipText(ToolkitResources.getString((String)"COPY_TO_CLIPBOARD_HELP"));
        resourceButton.setMnemonic(ToolkitResources.getString((String)"COPY_TO_CLIPBOARD_SHORTCUT").charAt(0));
        return resourceButton;
    }

    private JScrollPane scrollPane() {
        return new JScrollPane(this.configArea(), 20, 30);
    }

    private JTextArea configArea() {
        JTextArea jTextArea = new JTextArea(9, 50);
        jTextArea.setText(ButtonPanel.configString());
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        return jTextArea;
    }
}

