/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n;

import com.sun.cldc.i18n.StreamReader;
import com.sun.cldc.i18n.StreamWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class Helper {
    public static final String defaultEncoding = "ISO8859_1";
    public static final boolean ISO8859_1_ONLY_SUPPORTED = true;
    private static final String defaultMEPath = "com.sun.cldc.i18n.j2me";
    private static String lastReaderEncoding;
    private static StreamReader lastReader;
    private static String lastWriterEncoding;
    private static StreamWriter lastWriter;

    private Helper() {
    }

    public static Reader getStreamReader(InputStream is) {
        try {
            return Helper.getStreamReader(is, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException();
        }
    }

    public static Reader getStreamReader(InputStream is, String name) throws UnsupportedEncodingException {
        if (is == null || name == null) {
            throw new NullPointerException();
        }
        StreamReader fr = (StreamReader)Helper.getStreamReaderOrWriter(name, "_Reader");
        return fr.open(is, name);
    }

    private static Object getStreamReaderOrWriter(String name, String suffix) throws UnsupportedEncodingException {
        if (name == null) {
            throw new NullPointerException();
        }
        name = Helper.internalNameForEncoding(name);
        try {
            String className = "com.sun.cldc.i18n.j2me." + name + suffix;
            Class clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new UnsupportedEncodingException();
        }
        catch (InstantiationException x) {
            throw new RuntimeException();
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException();
        }
    }

    public static Writer getStreamWriter(OutputStream os) {
        try {
            return Helper.getStreamWriter(os, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException();
        }
    }

    public static Writer getStreamWriter(OutputStream os, String name) throws UnsupportedEncodingException {
        if (os == null || name == null) {
            throw new NullPointerException();
        }
        StreamWriter sw = (StreamWriter)Helper.getStreamReaderOrWriter(name, "_Writer");
        return sw.open(os, name);
    }

    public static char[] byteToCharArray(byte[] buffer, int offset, int length) {
        try {
            return Helper.byteToCharArray(buffer, offset, length, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException();
        }
    }

    public static byte[] charToByteArray(char[] buffer, int offset, int length) {
        try {
            return Helper.charToByteArray(buffer, offset, length, defaultEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException();
        }
    }

    public static char[] byteToCharArray(byte[] buffer, int offset, int length, String enc) throws UnsupportedEncodingException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset > buffer.length - length) {
            throw new IndexOutOfBoundsException();
        }
        if (Helper.isISO8859_1(enc)) {
            char[] value = new char[length];
            for (int i = 0; i < length; ++i) {
                value[i] = (char)(buffer[i + offset] & 0xFF);
            }
            return value;
        }
        throw new UnsupportedEncodingException(enc);
    }

    private static synchronized char[] byteToCharArray0(byte[] buffer, int offset, int length, String enc) throws UnsupportedEncodingException {
        if (lastReaderEncoding == null || !lastReaderEncoding.equals(enc)) {
            lastReader = (StreamReader)Helper.getStreamReaderOrWriter(enc, "_Reader");
            lastReaderEncoding = enc;
        }
        int size = lastReader.sizeOf(buffer, offset, length);
        char[] outbuf = new char[size];
        lastReader.open(new ByteArrayInputStream(buffer, offset, length), enc);
        try {
            int numread = lastReader.read(outbuf, 0, size);
            if (numread < size) {
                lastReader.read(outbuf, numread, size - numread);
            }
            lastReader.close();
        }
        catch (IOException x) {
            throw new RuntimeException();
        }
        return outbuf;
    }

    private static synchronized byte[] charToByteArray0(char[] buffer, int offset, int length, String enc) throws UnsupportedEncodingException {
        if (lastWriterEncoding == null || !lastWriterEncoding.equals(enc)) {
            lastWriter = (StreamWriter)Helper.getStreamReaderOrWriter(enc, "_Writer");
            lastWriterEncoding = enc;
        }
        int size = lastWriter.sizeOf(buffer, offset, length);
        ByteArrayOutputStream os = new ByteArrayOutputStream(size);
        lastWriter.open(os, enc);
        try {
            lastWriter.write(buffer, offset, length);
            lastWriter.close();
        }
        catch (IOException x) {
            throw new RuntimeException();
        }
        try {
            os.close();
        }
        catch (IOException x) {
            // empty catch block
        }
        return os.toByteArray();
    }

    public static byte[] charToByteArray(char[] buffer, int offset, int length, String enc) throws UnsupportedEncodingException {
        if (Helper.isISO8859_1(enc)) {
            byte[] value = new byte[length];
            for (int i = 0; i < length; ++i) {
                value[i] = (byte)buffer[i + offset];
            }
            return value;
        }
        throw new UnsupportedEncodingException(enc);
    }

    public static boolean isISO8859_1(String encodingName) {
        return encodingName.equals(defaultEncoding) || Helper.internalNameForEncoding(encodingName).equals(defaultEncoding);
    }

    private static String internalNameForEncoding(String encodingName) {
        String internalName = Helper.normalizeEncodingName(encodingName);
        if (internalName.equals("US_ASCII")) {
            return defaultEncoding;
        }
        if (internalName.equals("ISO_8859_1")) {
            return defaultEncoding;
        }
        return internalName;
    }

    private static String normalizeEncodingName(String encodingName) {
        StringBuffer normalizedName = new StringBuffer(encodingName);
        for (int i = 0; i < normalizedName.length(); ++i) {
            char currentChar = normalizedName.charAt(i);
            if (currentChar == '-' || currentChar == ':') {
                normalizedName.setCharAt(i, '_');
                continue;
            }
            normalizedName.setCharAt(i, Character.toUpperCase(currentChar));
        }
        return normalizedName.toString();
    }
}

