/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.CallbackThread;
import com.sun.squawk.HookWrapper;
import com.sun.squawk.Isolate;
import com.sun.squawk.util.SquawkVector;

final class CallbackGroup {
    final Isolate iso;
    SquawkVector hooks;

    CallbackGroup(Isolate iso) {
        this.iso = iso;
        this.hooks = new SquawkVector();
    }

    int count() {
        return this.hooks.size();
    }

    synchronized void add(Runnable hook) {
        if (this.findHook(hook) >= 0) {
            throw new IllegalArgumentException();
        }
        this.hooks.addElement(hook);
    }

    private int findHook(Runnable hook) {
        int len = this.hooks.size();
        for (int i = 0; i < len; ++i) {
            if (this.hooks.elementAt(i) != hook) continue;
            return i;
        }
        return -1;
    }

    synchronized boolean remove(Runnable hook) {
        int i = this.findHook(hook);
        if (i >= 0) {
            this.hooks.removeElementAt(i);
            return true;
        }
        return false;
    }

    synchronized HookWrapper findHookWrapper(Object hook) {
        int len = this.hooks.size();
        for (int i = 0; i < len; ++i) {
            HookWrapper hw;
            Object h = this.hooks.elementAt(i);
            if (!(h instanceof HookWrapper) || (hw = (HookWrapper)h).getWrappedHook() != hook) continue;
            return hw;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAllHooksInContext() {
        Object[] hks;
        CallbackGroup callbackGroup = this;
        synchronized (callbackGroup) {
            hks = new Runnable[this.hooks.size()];
            this.hooks.copyInto(hks);
        }
        int len = this.hooks.size();
        for (int i = 0; i < len; ++i) {
            Object hook = hks[i];
            try {
                hook.run();
                continue;
            }
            catch (RuntimeException e) {
                System.err.print("Exception thrown executing callback. Exception printed and ignored:");
                e.printStackTrace();
            }
        }
    }

    void run() {
        if (Isolate.currentIsolate() == this.iso) {
            this.runAllHooksInContext();
        } else {
            CallbackThread thr = new CallbackThread(this);
            thr.start();
            try {
                thr.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

