/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.ExecutionPoint;
import com.sun.squawk.Offset;
import com.sun.squawk.util.Assert;

public abstract class Debugger {
    public abstract void notifyEvent(Event var1);

    public static final class SingleStep {
        public static final int REQUESTED = 1;
        public static final int HIT = 2;
        public static final int DEFERRED = 3;
        private int state = 1;
        final Offset startFO;
        final Offset startBCI;
        final int targetBCI;
        final int dupBCI;
        final int afterDupBCI;
        final Offset reportedFO;
        final Offset reportedBCI;
        final int size;
        final int depth;

        public SingleStep(Offset startFO, Offset startBCI, int targetBCI, int dupBCI, int afterDupBCI, int size, int depth) {
            this.startFO = startFO;
            this.startBCI = startBCI;
            this.targetBCI = targetBCI;
            this.dupBCI = dupBCI;
            this.afterDupBCI = afterDupBCI;
            this.reportedFO = Offset.zero();
            this.reportedBCI = Offset.zero();
            this.size = size;
            this.depth = depth;
        }

        void changeState(int newState) {
            this.state = newState;
        }

        public final int getState() {
            return this.state;
        }
    }

    public static class ExceptionEvent
    extends LocationEvent {
        public final ExecutionPoint catchLocation;
        public final boolean isCaught;

        public ExceptionEvent(Throwable exception, ExecutionPoint throwLocation, ExecutionPoint catchLocation, boolean isCaught) {
            super(4, exception, throwLocation);
            this.catchLocation = catchLocation;
            this.isCaught = isCaught;
        }

        String name() {
            return "exception";
        }
    }

    public static class SingleStepEvent
    extends LocationEvent {
        public SingleStepEvent(ExecutionPoint location) {
            super(1, null, location);
        }

        String name() {
            return "step";
        }
    }

    public static class BreakpointEvent
    extends LocationEvent {
        public BreakpointEvent(ExecutionPoint location) {
            super(2, null, location);
        }

        String name() {
            return "breakpoint";
        }
    }

    public static abstract class LocationEvent
    extends Event {
        public final ExecutionPoint location;

        public LocationEvent(int type, Object object, ExecutionPoint location) {
            super(type, object);
            this.location = location;
        }

        abstract String name();
    }

    public static class Event {
        public static final int VM_DISCONNECTED = 100;
        public static final int SINGLE_STEP = 1;
        public static final int BREAKPOINT = 2;
        public static final int FRAME_POP = 3;
        public static final int EXCEPTION = 4;
        public static final int USER_DEFINED = 5;
        public static final int THREAD_START = 6;
        public static final int THREAD_END = 7;
        public static final int CLASS_PREPARE = 8;
        public static final int CLASS_UNLOAD = 9;
        public static final int CLASS_LOAD = 10;
        public static final int FIELD_ACCESS = 20;
        public static final int FIELD_MODIFICATION = 21;
        public static final int EXCEPTION_CATCH = 30;
        public static final int METHOD_ENTRY = 40;
        public static final int METHOD_EXIT = 41;
        public static final int VM_INIT = 90;
        public static final int VM_DEATH = 99;
        public static final int VM_START = 90;
        public static final int THREAD_DEATH = 7;
        public final int kind;
        public final Object object;
        private Object threadID;
        private Thread thread;

        public Event(int kind, Object object) {
            this.kind = kind;
            this.object = object;
        }

        public void setThread(Thread thread, Object threadID) {
            Assert.always(thread != null && threadID != null);
            Assert.always(this.thread == null && this.threadID == null);
            this.thread = thread;
            this.threadID = threadID;
        }

        public Object getThreadID() {
            return this.threadID;
        }

        public Thread getThread() {
            return this.thread;
        }
    }
}

