/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.Offset;
import com.sun.squawk.VM;
import java.io.PrintStream;

public final class ExecutionPoint {
    public final Offset frame;
    public final Offset bci;
    public final Object mp;

    public ExecutionPoint(Offset frame, Offset bci, Object mp) {
        this.frame = frame;
        this.bci = bci;
        this.mp = mp;
    }

    public Klass getKlass() {
        return VM.asKlass(NativeUnsafe.getObject(this.mp, -3));
    }

    public Method getMethod() {
        return this.getKlass().findMethod(this.mp);
    }

    private void printKnownMethod(PrintStream out, Klass klass, String methodName, int[] lnt) {
        out.print("at ");
        out.print(klass.getName());
        out.print('.');
        out.print(methodName);
        out.print('(');
        String src = klass.getSourceFileName();
        if (src != null) {
            out.print(src);
            out.print(':');
        }
        if (lnt != null) {
            int lno = Method.getLineNumber(lnt, this.bci.toPrimitive());
            out.print(lno);
        } else {
            out.print("bci=");
            out.print(this.bci.toPrimitive());
        }
        out.print(')');
    }

    private void printUnknownMethod(PrintStream out, Klass klass, String methodKind, int index) {
        out.print("in ");
        out.print(methodKind);
        out.print(" method #");
        out.print(index);
        out.print(" of ");
        out.print(klass.getName());
        out.print("(bci=");
        out.print(this.bci.toPrimitive());
        out.print(')');
    }

    private String calcStaticMethodName(Klass klass, int index) {
        if (index == klass.getClinitIndex()) {
            return "<clinit>";
        }
        if (index == klass.getDefaultConstructorIndex()) {
            return "<init>";
        }
        if (index == klass.getMainIndex()) {
            return "main";
        }
        return null;
    }

    private String calcVirtualMethodName(Klass klass, int index, Object[] temp) {
        if (klass != null) {
            Method method = klass.lookupVirtualMethod(index);
            if (method != null) {
                return method.getName();
            }
            int islot = klass.findISlot(index, temp);
            if (islot >= 0) {
                Klass iKlass = (Klass)temp[0];
                method = iKlass.getMethod(islot, false);
                if (method != null) {
                    return method.getName();
                }
                return null;
            }
            return this.calcVirtualMethodName(klass.getSuperclass(), index, temp);
        }
        return null;
    }

    private void printToVM(Klass klass, String methodName, int[] lnt) {
        VM.print("at ");
        VM.print(klass.getInternalName());
        VM.print('.');
        VM.print(methodName);
        VM.print('(');
        String src = klass.getSourceFileName();
        if (src != null) {
            VM.print(src);
            VM.print(':');
        }
        if (lnt != null) {
            int lno = Method.getLineNumber(lnt, this.bci.toPrimitive());
            VM.print(lno);
        } else {
            VM.print("bci=");
            VM.printOffset(this.bci);
        }
        VM.println(')');
    }

    private void printToVM(Klass klass, String methodKind, int index) {
        VM.print("in ");
        VM.print(methodKind);
        VM.print(" method #");
        VM.print(index);
        VM.print(" of ");
        VM.print(klass.getInternalName());
        VM.print("(bci=");
        VM.printOffset(this.bci);
        VM.println(')');
    }

    void printToVM() {
        try {
            Klass klass = this.getKlass();
            Method method = klass.findMethod(this.mp);
            if (method == null) {
                int index = klass.getMethodIndex(this.mp, true);
                if (index >= 0) {
                    String methodName = this.calcStaticMethodName(klass, index);
                    if (methodName != null) {
                        this.printToVM(klass, methodName, null);
                    } else {
                        this.printToVM(klass, "static", index);
                    }
                } else {
                    index = klass.getMethodIndex(this.mp, false);
                    if (index >= 0) {
                        this.printToVM(klass, "virtual", index);
                    }
                }
            } else {
                this.printToVM(klass, method.getName(), method.getLineNumberTable());
            }
        }
        catch (Throwable e) {
            VM.println("Exception thrown in StackTraceElement.printToVM()");
        }
    }

    public void print(PrintStream out) {
        try {
            Klass klass = this.getKlass();
            Method method = klass.findMethod(this.mp);
            if (method == null) {
                int index = klass.getMethodIndex(this.mp, true);
                if (index >= 0) {
                    String methodName = this.calcStaticMethodName(klass, index);
                    if (methodName != null) {
                        this.printKnownMethod(out, klass, methodName, null);
                    } else {
                        this.printUnknownMethod(out, klass, "static", index);
                    }
                } else {
                    index = klass.getMethodIndex(this.mp, false);
                    if (index >= 0) {
                        String methodName = this.calcVirtualMethodName(klass, index, new Object[1]);
                        if (methodName != null) {
                            this.printKnownMethod(out, klass, methodName, null);
                        } else {
                            this.printUnknownMethod(out, klass, "virtual", index);
                        }
                    }
                }
            } else {
                this.printKnownMethod(out, klass, method.getName(), method.getLineNumberTable());
            }
        }
        catch (Throwable e) {
            if (VM.isVerbose()) {
                VM.printVMStackTrace(e, "***", "Exception thrown in StackTraceElement.print():");
            }
            VM.print("*** Error decoding this StackTraceElement:\n    ");
            this.printToVM();
            out.print("------");
        }
    }
}

