/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.ExecutionPoint;
import com.sun.squawk.Offset;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;

final class HitBreakpoint {
    public static final int BP_HIT = 1;
    public static final int BP_REPORTED = 2;
    public static final int EXC_HIT = 3;
    public static final int EXC_REPORTING = 4;
    public static final int EXC_REPORTED = 5;
    final VMThread thread;
    private int state;
    final Offset hitOrThrowFO;
    final Offset hitOrThrowBCI;
    final Offset catchFO;
    final Offset catchBCI;
    final Throwable exception;

    HitBreakpoint(VMThread thread, Offset hitFO, Offset hitBCI) {
        this.thread = thread;
        this.exception = null;
        this.hitOrThrowFO = hitFO;
        this.hitOrThrowBCI = hitBCI;
        this.catchFO = Offset.zero();
        this.catchBCI = Offset.zero();
        this.setState(1);
    }

    HitBreakpoint(VMThread thread, Offset throwFO, Offset throwBCI, Throwable exception, Offset catchFO, Offset catchBCI) {
        this.thread = thread;
        this.hitOrThrowFO = throwFO;
        this.hitOrThrowBCI = throwBCI;
        this.catchFO = catchFO;
        this.catchBCI = catchBCI;
        this.exception = exception;
        this.setState(3);
    }

    Throwable getException() {
        return this.exception;
    }

    ExecutionPoint getLocation() {
        return new ExecutionPoint(this.hitOrThrowFO, this.hitOrThrowBCI, this.getMethod());
    }

    ExecutionPoint getCatchLocation() {
        return new ExecutionPoint(this.catchFO, this.catchBCI, this.getCatchMethod());
    }

    final int getState() {
        return this.state;
    }

    final void setState(int value) {
        this.state = value;
    }

    Object getMethod() {
        return VM.getMP(this.thread.frameOffsetAsPointer(this.hitOrThrowFO));
    }

    Object getCatchMethod() {
        return this.catchFO.isZero() ? null : VM.getMP(this.thread.frameOffsetAsPointer(this.catchFO));
    }

    boolean isCaught() {
        Offset appThreadTop = this.thread.getAppThreadTop();
        return appThreadTop.isZero() || appThreadTop.lt(this.catchFO);
    }
}

