/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.CallbackManager;
import com.sun.squawk.CrossIsolateThread;
import com.sun.squawk.Debugger;
import com.sun.squawk.GC;
import com.sun.squawk.HitBreakpoint;
import com.sun.squawk.HookWrapper;
import com.sun.squawk.Klass;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.ObjectMemoryLoader;
import com.sun.squawk.ObjectMemorySerializer;
import com.sun.squawk.Suite;
import com.sun.squawk.TranslatorInterface;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import com.sun.squawk.io.MulticastOutputStream;
import com.sun.squawk.io.mailboxes.Mailbox;
import com.sun.squawk.io.mailboxes.MailboxAddress;
import com.sun.squawk.pragma.AllowInlinedPragma;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkHashtable;
import com.sun.squawk.util.SquawkVector;
import com.sun.squawk.vm.CS;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.microedition.io.Connector;

public final class Isolate
implements Runnable {
    private static final int NEW = 0;
    private static final int ALIVE = 1;
    private static final int HIBERNATED = 2;
    private static final int EXITED = 3;
    private static final String MIDLET_WRAPPER_CLASS = "com.sun.squawk.imp.MIDletMainWrapper";
    private Debugger debugger;
    private final int id;
    private final String mainClassName;
    private String[] args;
    private Suite leafSuite;
    private final Suite bootstrapSuite;
    private SquawkHashtable childThreads = new SquawkHashtable();
    private Isolate parentIsolate;
    private SquawkHashtable childIsolates;
    private boolean classKlassInitialized;
    private int state;
    private int exitCode;
    private final String parentSuiteSourceURI;
    private final String classPath;
    private int channelContext;
    private byte[] hibernatedChannelContext;
    private int guiIn;
    private int guiOut;
    private SquawkHashtable monitorHashtable = new SquawkHashtable();
    private TranslatorInterface translator;
    private Klass translatorClass;
    private Object classStateQueue;
    private SquawkHashtable internedStrings;
    private VMThread hibernatedRunThreads;
    private VMThread hibernatedTimerThreads;
    private Object savedStackChunks;
    private VMThread joiners;
    private SquawkHashtable properties;
    private int transitioningState;
    private SquawkHashtable mailboxes;
    private SquawkHashtable mailboxAddresses;
    private CallbackManager shutdownHooks;
    private CallbackManager suspendHooks;
    private CallbackManager resumeHooks;
    private Runnable shutdownHook;
    private boolean isMidlet;
    private String name;
    public static final int SHUTDOWN_EVENT_MASK = 1;
    public static final int HIBERNATE_EVENT_MASK = 2;
    public static final int UNHIBERNATE_EVENT_MASK = 4;
    public final MulticastOutputStream stdout = new MulticastOutputStream();
    public final MulticastOutputStream stderr = new MulticastOutputStream();
    private Breakpoint[] breakpoints;

    Isolate(String mainClassName, String[] args, Suite suite) {
        this.mainClassName = mainClassName;
        this.args = args;
        this.leafSuite = suite;
        this.classPath = null;
        this.parentSuiteSourceURI = null;
        this.state = 0;
        this.id = VM.allocateIsolateID();
        this.name = mainClassName;
        while (suite.getParent() != null) {
            suite = suite.getParent();
        }
        this.bootstrapSuite = suite;
        VM.registerIsolate(this);
        Assert.always(VM.getCurrentIsolate() == null);
    }

    private void addProperties(Hashtable properties) {
        if (properties != null) {
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)properties.get(key);
                this.setProperty(key, value);
            }
        }
    }

    public Isolate(Hashtable properties, String mainClassName, String[] args, String classPath, String parentSuiteSourceURI) {
        if (mainClassName == null || args == null) {
            throw new NullPointerException();
        }
        this.mainClassName = this.copyIfCurrentThreadIsExternal(mainClassName);
        this.args = this.copyIfCurrentThreadIsExternal(args);
        this.classPath = this.copyIfCurrentThreadIsExternal(classPath);
        this.parentSuiteSourceURI = this.copyIfCurrentThreadIsExternal(parentSuiteSourceURI);
        this.state = 0;
        this.id = VM.allocateIsolateID();
        this.name = this.mainClassName;
        Isolate currentIsolate = VM.getCurrentIsolate();
        currentIsolate.addIsolate(this);
        this.bootstrapSuite = this.parentIsolate.bootstrapSuite;
        this.addProperties(VM.getCommandLineProperties());
        this.addProperties(properties);
        try {
            this.updateLeafSuite(true);
        }
        catch (Error e) {
            System.err.println("Error constructing Isolate based on suite: " + parentSuiteSourceURI + " and classpath: " + classPath);
            throw e;
        }
        VM.registerIsolate(this);
    }

    public Isolate(String mainClassName, String[] args, String classPath, String parentSuiteSourceURI) {
        this(null, mainClassName, args, classPath, parentSuiteSourceURI);
    }

    public Isolate(Hashtable properties, int midletNum, String classPath, String parentSuiteSourceURI) {
        this(properties, MIDLET_WRAPPER_CLASS, new String[0], classPath, parentSuiteSourceURI);
        this.args = new String[1];
        this.args[0] = "MIDlet-" + midletNum;
    }

    private boolean isCurrentThreadExternal() {
        VMThread currentThread;
        return !VM.isHosted() && (currentThread = VMThread.currentThread()) != null && currentThread.getThreadNumber() != 0 && currentThread.getIsolate() != this;
    }

    private String copyIfCurrentThreadIsExternal(String s) {
        if (s != null && GC.inRam(s) && this.isCurrentThreadExternal()) {
            return new String(s);
        }
        return s;
    }

    private String[] copyIfCurrentThreadIsExternal(String[] arr) {
        if (arr != null && this.isCurrentThreadExternal()) {
            String[] result = new String[arr.length];
            for (int i = 0; i != arr.length; ++i) {
                result[i] = this.copyIfCurrentThreadIsExternal(arr[i]);
            }
            return result;
        }
        return arr;
    }

    public String getName() {
        return this.copyIfCurrentThreadIsExternal(this.name);
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException();
        }
        this.name = this.copyIfCurrentThreadIsExternal(newName);
    }

    public String getClassPath() {
        return this.copyIfCurrentThreadIsExternal(this.classPath);
    }

    public static Isolate[] getIsolates() {
        SquawkVector set = new SquawkVector();
        VM.copyIsolatesInto(set);
        Object[] isolates = new Isolate[set.size()];
        set.copyInto(isolates);
        return isolates;
    }

    public String getParentSuiteSourceURI() {
        return this.parentSuiteSourceURI == null ? "memory:bootstrap" : this.parentSuiteSourceURI;
    }

    public String getMainClassName() {
        return this.copyIfCurrentThreadIsExternal(this.mainClassName);
    }

    public static Isolate currentIsolate() {
        return VM.getCurrentIsolate();
    }

    public boolean isTrusted() {
        return true;
    }

    public String[] getMainClassArguments() {
        return this.copyIfCurrentThreadIsExternal(this.args);
    }

    Suite getBootstrapSuite() {
        return this.bootstrapSuite;
    }

    public Suite getLeafSuite() {
        return this.leafSuite;
    }

    SquawkHashtable getMonitorHashtable() {
        return this.monitorHashtable;
    }

    void setTranslator(TranslatorInterface translator) throws HostedPragma {
        this.translator = translator;
    }

    void setTranslatorClass(Klass translatorClass) {
        Assert.always(!VM.isHosted());
        if (GC.inRam(translatorClass)) {
            throw new IllegalArgumentException("translator class must be in read-only memory");
        }
        this.translatorClass = translatorClass;
    }

    public static TranslatorInterface getDefaultTranslator() throws AllowInlinedPragma {
        try {
            Klass klass;
            Suite tsuite;
            String translatorSuiteUrl = System.getProperty("com.sun.squawk.Isolate.getDefaultTranslator");
            if (translatorSuiteUrl == null) {
                translatorSuiteUrl = "file://translator.suite";
            }
            if ((tsuite = Suite.getSuite(translatorSuiteUrl, false)) != null && (klass = tsuite.lookup("com.sun.squawk.translator.Translator")) != null) {
                return (TranslatorInterface)klass.newInstance();
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public TranslatorInterface getTranslator() throws AllowInlinedPragma {
        if (VM.isHosted()) {
            return this.translator;
        }
        try {
            Klass klass;
            Klass klass2 = klass = this.translatorClass != null ? this.translatorClass : this.leafSuite.lookup("com.sun.squawk.translator.Translator");
            if (klass == null) {
                return Isolate.getDefaultTranslator();
            }
            return (TranslatorInterface)klass.newInstance();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new SquawkHashtable();
        }
        key = this.copyIfCurrentThreadIsExternal(key);
        if (value == null) {
            this.properties.remove(key);
        } else {
            value = this.copyIfCurrentThreadIsExternal(value);
            this.properties.put(key, value);
        }
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.copyIfCurrentThreadIsExternal((String)this.properties.get(key));
    }

    public Enumeration getProperties() {
        return new PropEnumeration(this);
    }

    private CallbackManager getCallbackManager(int eventKind) {
        switch (eventKind) {
            case 1: {
                if (this.shutdownHooks == null) {
                    this.shutdownHooks = new CallbackManager(true);
                }
                return this.shutdownHooks;
            }
            case 2: {
                if (this.suspendHooks == null) {
                    this.suspendHooks = new CallbackManager(false);
                }
                return this.suspendHooks;
            }
            case 4: {
                if (this.resumeHooks == null) {
                    this.resumeHooks = new CallbackManager(false);
                }
                return this.resumeHooks;
            }
        }
        throw new IllegalArgumentException("Illegal isolate event kind " + eventKind);
    }

    public void addLifecycleListener(LifecycleListener listener, int eventSet) {
        if ((eventSet & 7) == 0) {
            throw new IllegalArgumentException("Illegal isolate event set " + eventSet);
        }
        if ((eventSet & 1) != 0) {
            this.addLifecycleListener0(listener, 1);
        }
        if ((eventSet & 2) != 0) {
            this.addLifecycleListener0(listener, 2);
        }
        if ((eventSet & 4) != 0) {
            this.addLifecycleListener0(listener, 4);
        }
    }

    private void addLifecycleListener0(LifecycleListener listener, int eventKind) {
        CallbackManager cbm = this.getCallbackManager(eventKind);
        Isolate currentIsolate = Isolate.currentIsolate();
        if (this == currentIsolate) {
            cbm.add(currentIsolate, new LocalListenerWrapper(listener, eventKind));
        } else {
            RemoteListenerWrapper rlw = new RemoteListenerWrapper(this, listener, eventKind);
            currentIsolate.getCallbackManager(1).add(currentIsolate, rlw.getCleanupHook());
            cbm.add(currentIsolate, rlw);
        }
    }

    public boolean removeLifecycleListener(LifecycleListener listener, int eventSet) {
        if ((eventSet & 7) == 0) {
            throw new IllegalArgumentException("Illegal isolate event set " + eventSet);
        }
        boolean result = true;
        if ((eventSet & 1) != 0) {
            result &= this.removeLifecycleListener0(listener, 1);
        }
        if ((eventSet & 2) != 0) {
            result &= this.removeLifecycleListener0(listener, 2);
        }
        if ((eventSet & 4) != 0) {
            result &= this.removeLifecycleListener0(listener, 4);
        }
        return result;
    }

    private boolean removeLifecycleListener0(LifecycleListener listener, int eventKind) {
        Isolate currentIsolate;
        CallbackManager cbm = this.getCallbackManager(eventKind);
        HookWrapper hw = cbm.findHookWrapper(currentIsolate = Isolate.currentIsolate(), listener);
        if (hw == null) {
            return false;
        }
        if (this == currentIsolate) {
            return cbm.remove(hw);
        }
        if (hw instanceof RemoteListenerWrapper) {
            RemoteListenerWrapper rlw = (RemoteListenerWrapper)hw;
            currentIsolate.getCallbackManager(1).remove(rlw.getCleanupHook());
            return cbm.remove(rlw);
        }
        throw Assert.shouldNotReachHere();
    }

    Object getClassState(Klass klass) {
        VM.extendsEnabled = false;
        Object first = this.classStateQueue;
        Object res = null;
        if (first == null) {
            VM.extendsEnabled = true;
            Assert.always(!this.classKlassInitialized);
        } else if (NativeUnsafe.getObject(first, 0) == klass) {
            res = first;
        } else {
            Object last = first;
            Object ks = NativeUnsafe.getObject(first, 1);
            while (ks != null) {
                if (NativeUnsafe.getObject(ks, 0) == klass) {
                    if (last != null) {
                        Object ksnext = NativeUnsafe.getObject(ks, 1);
                        NativeUnsafe.setObject(last, 1, ksnext);
                        NativeUnsafe.setObject(ks, 1, first);
                        this.classStateQueue = ks;
                    }
                    res = ks;
                    break;
                }
                last = ks;
                ks = NativeUnsafe.getObject(ks, 1);
            }
        }
        VM.extendsEnabled = true;
        if (res != null) {
            CS.check(res);
            CS.check(this.classStateQueue);
            VM.addToClassStateCache(klass, res);
        }
        return res;
    }

    void addClassState(Object ks) {
        CS.check(ks);
        VM.extendsEnabled = false;
        Object first = this.classStateQueue;
        NativeUnsafe.setObject(ks, 1, first);
        this.classStateQueue = ks;
        VM.extendsEnabled = true;
    }

    Object getClassStateForStaticVariableAccess(Klass klass, int offset) {
        Object ks = this.getClassState(klass);
        if (ks == null) {
            ks = klass.initializeInternal();
        }
        return ks;
    }

    private String intern0(String value) {
        String internedString = Isolate.lookupInterned(value);
        if (internedString == null) {
            this.internedStrings.put(value, value);
            internedString = value;
        }
        return internedString;
    }

    private String lookupInterned0(String value) {
        if (this.internedStrings == null) {
            this.internedStrings = new SquawkHashtable();
            if (!VM.isHosted()) {
                GC.getStrings(this.internedStrings);
            }
        }
        return (String)this.internedStrings.get(value);
    }

    public static String intern(String value) {
        return VM.getCurrentIsolate().intern0(value);
    }

    public static String lookupInterned(String value) {
        return VM.getCurrentIsolate().lookupInterned0(value);
    }

    void primitiveThreadStart() {
        VMThread.asVMThread(new CrossIsolateThread(this, "primitve-thread")).primitiveThreadStart();
    }

    public void start() {
        CrossIsolateThread t = new CrossIsolateThread(this, this.mainClassName + " - main");
        t.start();
    }

    void initializeClassKlass() {
        if (!this.classKlassInitialized) {
            Klass klassKlass = this.bootstrapSuite.getKlass(4);
            Klass klassGlobalArray = this.bootstrapSuite.getKlass(30);
            Object cs = GC.newClassState(klassKlass, klassGlobalArray);
            this.addClassState(cs);
            klassKlass.clinit();
            this.classKlassInitialized = true;
        }
    }

    int getChannelContext() {
        if (this.channelContext == 0) {
            this.channelContext = VM.createChannelContext(this.hibernatedChannelContext);
            this.hibernatedChannelContext = null;
        }
        return this.channelContext;
    }

    int getGuiInputChannel() throws IOException {
        if (this.guiIn == 0) {
            this.guiIn = VM.getChannel(2);
        }
        return this.guiIn;
    }

    int getGuiOutputChannel() throws IOException {
        if (this.guiOut == 0) {
            this.guiOut = VM.getChannel(3);
            VM.execGraphicsIO(37, 0, 0, 0, 0, 0, 0, this.mainClassName, null);
        }
        return this.guiOut;
    }

    private void updateLeafSuite(boolean prepass) {
        if (!prepass) {
            // empty if block
        }
        if (this.parentSuiteSourceURI != null || this.classPath != null) {
            Suite parent = this.parentSuiteSourceURI == null ? this.bootstrapSuite : Suite.getSuite(this.parentSuiteSourceURI);
            String leafSuiteName = this.getProperty("leaf.suite.name");
            if (leafSuiteName == null) {
                leafSuiteName = "-leaf" + VM.getNextHashcode() + "-";
            }
            this.leafSuite = this.classPath == null ? parent : new Suite(leafSuiteName, parent);
        } else {
            this.leafSuite = this.bootstrapSuite;
        }
    }

    private void addVMShutdownHook() {
        this.shutdownHook = new Runnable(){

            public void run() {
                Isolate.this.runShutdownListeners();
            }
        };
        VM.addShutdownHook(this, this.shutdownHook);
    }

    private void removeVMShutdownHook() {
        if (this.shutdownHook != null) {
            boolean did = VM.removeShutdownHook(this, this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    public final void run() throws IllegalStateException {
        if (this.state != 0) {
            throw new IllegalStateException("cannot restart isolate");
        }
        if (VMThread.currentThread().getIsolate() != this) {
            throw new IllegalStateException("cannot run isolate from external thread");
        }
        this.changeState(1);
        this.initializeClassKlass();
        this.updateLeafSuite(false);
        System.currentTimeMillis();
        String initializerClassName = VM.getIsolateInitializerClassName();
        if (VM.isVeryVerbose()) {
            System.out.print("[Starting isolate for '" + this.mainClassName);
            if (this.args != null) {
                for (int i = 0; i != this.args.length; ++i) {
                    System.out.print(" " + this.args[i]);
                }
            }
            System.out.print("' with class path set to '" + this.classPath + "'");
            if (this.parentSuiteSourceURI != null) {
                System.out.print(" and parent suite URI set to '" + this.parentSuiteSourceURI + "'");
            }
            if (this.leafSuite != null) {
                System.out.print(" and leaf suite '" + this.leafSuite + "'");
            }
            if (initializerClassName != null) {
                System.out.print(" will invoke specified initializer " + initializerClassName);
            }
            System.out.println("]");
        }
        this.addVMShutdownHook();
        if (initializerClassName != null) {
            Klass klass = null;
            try {
                klass = Klass.forName(initializerClassName);
            }
            catch (ClassNotFoundException e) {
                System.err.println("No such class " + initializerClassName + ": " + e);
                this.exit(998);
            }
            boolean wasFirstInitialized = VM.isFirstIsolateInitialized();
            if (!wasFirstInitialized) {
                VM.setFirstIsolateInitialized(true);
            }
            klass.main(new String[]{wasFirstInitialized ? "false" : "true"});
        }
        if (this.debugger != null && !this.isMidlet()) {
            this.debugger.notifyEvent(new Debugger.Event(90, VMThread.currentThread()));
        }
        Klass klass = null;
        try {
            klass = Klass.forName(this.mainClassName);
            klass.main(this.args);
            System.out.flush();
            System.err.flush();
        }
        catch (ClassNotFoundException ex) {
            System.err.println("No such class " + this.mainClassName + ": " + ex);
            this.exit(999);
        }
    }

    public void join() {
        if (this.state <= 1) {
            VMThread.isolateJoin(this);
        }
        if (this.childIsolates != null) {
            Enumeration e = this.childIsolates.elements();
            while (e.hasMoreElements()) {
                Isolate isolate = (Isolate)e.nextElement();
                isolate.join();
            }
        }
        this.childIsolates = null;
    }

    void addIsolate(Isolate childIsolate) {
        childIsolate.parentIsolate = this;
        if (this.childIsolates == null) {
            this.childIsolates = new SquawkHashtable();
        }
        this.childIsolates.put(childIsolate, childIsolate);
    }

    void addThread(VMThread thread) {
        this.childThreads.put(thread, thread);
    }

    boolean removeThread(VMThread thread) {
        this.childThreads.remove(thread);
        if (thread.isDaemon()) {
            return false;
        }
        Enumeration e = this.childThreads.elements();
        while (e.hasMoreElements()) {
            thread = (VMThread)e.nextElement();
            if (thread.isDaemon()) continue;
            return false;
        }
        return true;
    }

    public boolean isClassKlassInitialized() {
        return this.classKlassInitialized;
    }

    private void runShutdownListeners() {
        if (this.shutdownHooks != null) {
            this.shutdownHooks.runHooks();
            this.shutdownHooks.removeAll();
            this.shutdownHooks = null;
        }
    }

    public void exit(int code) {
        if (this.state != 1) {
            throw new IllegalStateException("cannot exit an isolate that is not alive: state=" + this.state);
        }
        this.shutdown(code, true);
    }

    void abort(int code) {
        this.shutdown(code, false);
    }

    void shutdown(int code, boolean doExitHooks) {
        if (this.state == 1) {
            this.exitCode = code;
        }
        if (this.debugger != null) {
            this.debugger.notifyEvent(new Debugger.Event(99, this));
        }
        try {
            this.hibernate(false, 3, doExitHooks);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.shouldNotReachHere("[Isolate.java:1732] ");
        }
    }

    public void save(DataOutputStream dos, String uri) throws IOException {
        this.save(dos, uri, VM.isBigEndian());
    }

    public void save(DataOutputStream dos, String uri, boolean bigEndian) throws IOException {
        if (this.state != 2 && this.state != 3) {
            throw new IllegalStateException("cannot save unhibernated isolate");
        }
        this.internedStrings = null;
        Assert.always(this.savedStackChunks == null);
        ObjectMemorySerializer.ControlBlock cb = VM.copyObjectGraph(this);
        Assert.always(this.savedStackChunks == null);
        Suite readOnlySuite = this.leafSuite;
        while (GC.inRam(readOnlySuite)) {
            readOnlySuite = readOnlySuite.getParent();
        }
        ObjectMemorySerializer.save(dos, uri, cb, readOnlySuite.getReadOnlyObjectMemory(), bigEndian);
    }

    public static Isolate load(DataInputStream dis, String uri) {
        ObjectMemory om = ObjectMemoryLoader.load((DataInputStream)dis, (String)uri, (boolean)false).objectMemory;
        return Isolate.load(om);
    }

    private static Isolate load(ObjectMemory om) {
        Object root = om.getRoot();
        if (!(root instanceof Isolate)) {
            throw new Error("object memory with URI '" + om.getURI() + "' does not contain an isolate");
        }
        Isolate isolate = (Isolate)root;
        GC.getCollector().registerStackChunks(isolate.savedStackChunks);
        isolate.savedStackChunks = null;
        VM.registerIsolate(isolate);
        if (VM.isVerbose()) {
            int old = VM.setStream(2);
            VM.print("UNHIBERNATED_ISOLATE.RELOCATION=");
            VM.printUWord(om.getStart().toUWord());
            VM.println();
            VM.setStream(old);
        }
        return isolate;
    }

    public void hibernate() throws IOException, IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException("cannot hiberate an unstarted isolate");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("cannot hibernate a hibernated or exited isolate");
        }
        if (this.debugger != null) {
            throw new IllegalStateException("cannot hibernate an isolate with an attached debugger");
        }
        this.hibernate(true, 2, true);
    }

    private void changeState(int newState) {
        this.state = newState;
    }

    private void hibernate(boolean hibernateIO, int newState, boolean doHooks) throws IOException {
        if (hibernateIO && VM.isVeryVerbose()) {
            System.out.print("[Hibernating isolate for '" + this.mainClassName + "' with class path set to '" + this.classPath + "'");
            if (this.parentSuiteSourceURI != null) {
                System.out.print(" and parent suite URI set to '" + this.parentSuiteSourceURI + "'");
            }
            if (this.leafSuite != null) {
                System.out.print(" and leaf suite '" + this.leafSuite + "'");
            }
            System.out.println("]");
        }
        if (this.state != newState && newState > this.transitioningState) {
            this.transitioningState = newState;
            if (doHooks) {
                switch (newState) {
                    case 2: {
                        if (this.suspendHooks == null) break;
                        this.suspendHooks.runHooks();
                        break;
                    }
                    case 3: {
                        this.runShutdownListeners();
                    }
                }
            }
            this.removeVMShutdownHook();
            this.cleanupMailboxes();
            int channelContextToSave = this.getChannelContext();
            if (hibernateIO && channelContextToSave > 0) {
                this.hibernatedChannelContext = VM.hibernateChannelContext(channelContextToSave);
            }
            this.changeState(newState);
            this.transitioningState = 0;
            if (channelContextToSave > 0) {
                VM.deleteChannelContext(channelContextToSave);
                this.channelContext = 0;
            }
            if (this.parentIsolate != null) {
                this.parentIsolate.childIsolates.remove(this);
                this.parentIsolate = null;
            }
            VMThread.hibernateIsolate(this, this.state == 3);
        }
    }

    void addToHibernatedRunThread(VMThread thread) {
        thread.nextThread = this.hibernatedRunThreads;
        this.hibernatedRunThreads = thread;
    }

    void addToHibernatedTimerThread(VMThread thread) {
        thread.nextTimerThread = this.hibernatedTimerThreads;
        this.hibernatedTimerThreads = thread;
    }

    public void unhibernate() {
        if (this.state != 2) {
            throw new RuntimeException("Cannot unhibernate isolate that is not in hibernation state");
        }
        this.changeState(1);
        Isolate currentIsolate = VM.getCurrentIsolate();
        currentIsolate.addIsolate(this);
        VMThread.unhibernateIsolate(this);
        this.addVMShutdownHook();
        if (this.resumeHooks != null) {
            this.resumeHooks.runHooks();
        }
    }

    VMThread getHibernatedRunThreads() {
        VMThread res = this.hibernatedRunThreads;
        this.hibernatedRunThreads = null;
        return res;
    }

    VMThread getHibernatedTimerThreads() {
        VMThread res = this.hibernatedTimerThreads;
        this.hibernatedTimerThreads = null;
        return res;
    }

    public boolean isHibernated() {
        return this.state == 2;
    }

    public boolean isAlive() {
        return this.state == 1;
    }

    public boolean isExited() {
        return this.state == 3;
    }

    public boolean isNew() {
        return this.state == 0;
    }

    public boolean isBeingDebugged() {
        return this.debugger != null;
    }

    public boolean isMidlet() {
        return this.mainClassName.equals(MIDLET_WRAPPER_CLASS);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    void addJoiner(VMThread thread) {
        thread.nextThread = this.joiners;
        this.joiners = thread;
    }

    VMThread getJoiners() {
        VMThread res = this.joiners;
        this.joiners = null;
        return res;
    }

    public String toString() {
        String res = "isolate " + this.id + " \"" + this.name + "\"";
        res = this.isAlive() ? res.concat(" (ALIVE)") : (this.isExited() ? res.concat(" (EXITED)") : (this.isHibernated() ? res.concat(" (HIBERNATED)") : res.concat(" (NEW)")));
        return res;
    }

    public void addOut(String url) {
        this.addStream(this.stdout, url);
    }

    public void addErr(String url) {
        this.addStream(this.stderr, url);
    }

    public void removeOut(String url) {
        OutputStream oldstrm = this.stdout.remove(url);
        try {
            oldstrm.flush();
            oldstrm.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void removeErr(String url) {
        OutputStream oldstrm = this.stderr.remove(url);
        try {
            oldstrm.flush();
            oldstrm.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void clearOut() {
        try {
            this.stdout.flush();
            this.stdout.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.stdout.removeAll();
    }

    public void clearErr() {
        try {
            this.stderr.flush();
            this.stderr.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.stderr.removeAll();
    }

    private void addStream(MulticastOutputStream mos, String url) {
        if (this.isCurrentThreadExternal()) {
            url = new String(url);
            mos.add(url, new DelayedURLOutputStream(url));
        } else {
            try {
                mos.add(url, Connector.openOutputStream(url));
            }
            catch (IOException e) {
                VM.println("IO error opening standard stream to " + url + ": " + e);
            }
        }
    }

    public String[] listOut() {
        return this.listStreams(this.stdout);
    }

    public String[] listErr() {
        return this.listStreams(this.stderr);
    }

    private String[] listStreams(MulticastOutputStream mos) {
        int i;
        String[] names = new String[mos.getSize()];
        Enumeration e = mos.listNames();
        try {
            for (i = 0; i != names.length; ++i) {
                names[i] = (String)e.nextElement();
            }
        }
        catch (NoSuchElementException ex) {
            String[] old = names;
            names = new String[i];
            System.arraycopy(old, 0, names, 0, i);
        }
        return names;
    }

    public void recordMailbox(Mailbox mailbox) {
        if (this.mailboxes == null) {
            this.mailboxes = new SquawkHashtable();
        } else if (this.mailboxes.get(mailbox) != null) {
            throw new IllegalStateException(mailbox + " is already recorded");
        }
        this.mailboxes.put(mailbox, mailbox);
    }

    public void forgetMailbox(Mailbox mailbox) {
        if (this.mailboxes == null || this.mailboxes.get(mailbox) == null) {
            throw new IllegalStateException(mailbox + " is not recorded");
        }
        this.mailboxes.remove(mailbox);
    }

    public void recordMailboxAddress(MailboxAddress address) {
        if (this.mailboxAddresses == null) {
            this.mailboxAddresses = new SquawkHashtable();
        } else if (this.mailboxAddresses.get(address) != null) {
            throw new IllegalStateException(address + " is already recorded");
        }
        this.mailboxAddresses.put(address, address);
    }

    public void forgetMailboxAddress(MailboxAddress address) {
        if (this.mailboxAddresses == null || this.mailboxAddresses.get(address) == null) {
            throw new IllegalStateException(address + " is not recorded");
        }
        this.mailboxAddresses.remove(address);
    }

    public void cleanupMailboxes() {
        try {
            if (this.mailboxAddresses != null) {
                if (VM.isVeryVerbose()) {
                    System.err.println("Closing addresses...");
                }
                Enumeration addressE = this.mailboxAddresses.elements();
                while (addressE.hasMoreElements()) {
                    MailboxAddress address = (MailboxAddress)addressE.nextElement();
                    if (VM.isVeryVerbose()) {
                        System.err.println("Closing address " + address);
                    }
                    address.close();
                }
            }
            if (this.mailboxes != null) {
                if (VM.isVeryVerbose()) {
                    System.err.println("Closing mailboxes...");
                }
                Enumeration mailboxE = this.mailboxes.elements();
                while (mailboxE.hasMoreElements()) {
                    Mailbox mailbox = (Mailbox)mailboxE.nextElement();
                    if (VM.isVeryVerbose()) {
                        System.err.println("Closing mailbox " + mailbox);
                    }
                    mailbox.close();
                }
            }
        }
        catch (RuntimeException e) {
            System.err.println("Uncaught exception while cleaning up mailboxes: " + e);
            e.printStackTrace();
        }
    }

    public void printAllThreadStates(PrintStream out) {
        Enumeration e = this.getChildThreads();
        while (e.hasMoreElements()) {
            VMThread thr = (VMThread)e.nextElement();
            thr.printState(out);
            if (!thr.isAlive()) continue;
            thr.printStackTrace(out);
        }
    }

    public static void printAllIsolateStates(PrintStream out) {
        Isolate[] isos = Isolate.getIsolates();
        for (int i = 0; i < isos.length; ++i) {
            Isolate iso = isos[i];
            VM.outPrintln(out, "--- " + iso + " status ---");
            iso.printAllThreadStates(out);
        }
    }

    void setDebugger(Debugger debugger) {
        if (debugger == null && this.debugger != null) {
            Enumeration e = this.childThreads.elements();
            while (e.hasMoreElements()) {
                VMThread thread = (VMThread)e.nextElement();
                thread.clearStep();
                HitBreakpoint hbp = thread.getHitBreakpoint();
                if (hbp == null || hbp.exception != null) continue;
                thread.clearBreakpoint();
            }
        }
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public Enumeration getChildThreads() {
        return this.childThreads.elements();
    }

    public int getChildThreadCount() {
        return this.childThreads.size();
    }

    public int getId() {
        return this.id;
    }

    public void updateBreakpoints(Breakpoint[] breakpoints) {
        this.breakpoints = breakpoints;
    }

    public static class Breakpoint {
        public final Object mp;
        public final int ip;

        public Breakpoint(Object mp, int ip) {
            this.mp = mp;
            this.ip = ip;
        }

        public boolean equals(Object o) {
            if (o instanceof Breakpoint) {
                Breakpoint bp = (Breakpoint)o;
                return bp.mp == this.mp && bp.ip == this.ip;
            }
            return false;
        }

        public int hashCode() {
            return this.ip;
        }
    }

    static class DelayedURLOutputStream
    extends OutputStream {
        private OutputStream out;
        private final String url;

        private synchronized OutputStream out() throws IOException {
            if (this.out == null) {
                try {
                    this.out = Connector.openOutputStream(this.url);
                }
                catch (IOException e) {
                    VM.println("IO error opening standard stream to " + this.url + ": " + e);
                    throw e;
                }
            }
            return this.out;
        }

        public DelayedURLOutputStream(String url) {
            this.url = url;
        }

        public void write(int b) throws IOException {
            this.out().write(b);
        }

        public void write(byte[] b) throws IOException {
            this.out().write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out().write(b, off, len);
        }

        public synchronized void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        public synchronized void close() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
    }

    static final class RemoteListenerWrapper
    extends LocalListenerWrapper {
        private final Runnable cleanupHook;
        private final Isolate local = Isolate.currentIsolate();
        private final Isolate remote;

        RemoteListenerWrapper(Isolate remote, LifecycleListener listener, int eventKind) {
            super(listener, eventKind);
            this.remote = remote;
            this.cleanupHook = new RemoteListenerCleanupHook();
        }

        public void run() {
            this.listener.handleLifecycleListenerEvent(this.remote, this.eventKind);
            if (this.eventKind == 1) {
                this.local.getCallbackManager(1).remove(this.getCleanupHook());
            }
        }

        Runnable getCleanupHook() {
            return this.cleanupHook;
        }

        final class RemoteListenerCleanupHook
        implements Runnable {
            RemoteListenerCleanupHook() {
            }

            public void run() {
                RemoteListenerWrapper thisWrapper = RemoteListenerWrapper.this;
                CallbackManager cbm = thisWrapper.remote.getCallbackManager(thisWrapper.eventKind);
                cbm.remove(thisWrapper);
            }
        }
    }

    static class LocalListenerWrapper
    implements HookWrapper {
        final LifecycleListener listener;
        final int eventKind;

        public LocalListenerWrapper(LifecycleListener listener, int eventKind) {
            this.listener = listener;
            this.eventKind = eventKind;
        }

        public void run() {
            this.listener.handleLifecycleListenerEvent(Isolate.currentIsolate(), this.eventKind);
        }

        public Object getWrappedHook() {
            return this.listener;
        }
    }

    public static interface LifecycleListener {
        public void handleLifecycleListenerEvent(Isolate var1, int var2);
    }

    static class PropEnumeration
    implements Enumeration {
        private Enumeration realEnum;
        private Isolate iso;

        PropEnumeration(Isolate iso) {
            this.iso = iso;
            this.realEnum = iso.properties.keys();
        }

        public boolean hasMoreElements() {
            return this.realEnum.hasMoreElements();
        }

        public Object nextElement() {
            return this.iso.copyIfCurrentThreadIsExternal((String)this.realEnum.nextElement());
        }
    }
}

