/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.ClassFileField;
import com.sun.squawk.ClassFileMethod;
import com.sun.squawk.Debugger;
import com.sun.squawk.Field;
import com.sun.squawk.GC;
import com.sun.squawk.Isolate;
import com.sun.squawk.KlassMetadata;
import com.sun.squawk.Member;
import com.sun.squawk.Method;
import com.sun.squawk.MethodBody;
import com.sun.squawk.Modifier;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.Suite;
import com.sun.squawk.SymbolParser;
import com.sun.squawk.TranslatorInterface;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import com.sun.squawk.pragma.AllowInlinedPragma;
import com.sun.squawk.pragma.ForceInlinedPragma;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.pragma.NotInlinedPragma;
import com.sun.squawk.pragma.PragmaException;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkHashtable;
import com.sun.squawk.util.SquawkVector;
import com.sun.squawk.vm.Global;
import java.io.InputStream;
import java.util.Hashtable;

public class Klass {
    private final Klass self = this;
    private Object[] virtualMethods;
    private Object[] staticMethods;
    private final String name;
    private final Klass componentType;
    private Klass superType;
    private Klass[] interfaces;
    private short[][] interfaceVTableMaps;
    private Object[] objects;
    private UWord[] oopMap;
    private UWord oopMapWord;
    private UWord[] dataMap;
    private UWord dataMapWord;
    private int dataMapLength;
    private int modifiers;
    private byte state = 0;
    private final short id;
    private short instanceSizeBytes;
    private short staticFieldsSize;
    private short refStaticFieldsSize;
    private short indexForInit = (short)-1;
    private short indexForClinit = (short)-1;
    private short indexForMain = (short)-1;
    private byte initModifiers;
    private boolean mustClinit;
    public static final int ILLEGAL_METHOD_OFFSET = 65535;
    private static SquawkHashtable klassToClass;
    private static Klass klassClass;
    public static final Klass[] NO_CLASSES;
    public static final boolean DEBUG_CODE_ENABLED = false;
    public static final boolean ASSERTIONS_ENABLED = false;
    public static final boolean TRACING_ENABLED = false;
    public static final boolean SQUAWK_64 = false;
    public static final byte STATE_DEFINED = 0;
    public static final byte STATE_LOADING = 1;
    public static final byte STATE_LOADED = 2;
    public static final byte STATE_CONVERTING = 3;
    public static final byte STATE_CONVERTED = 4;
    public static final byte STATE_ERROR = 5;
    public static final int DATAMAP_ENTRY_BITS = 2;
    public static final int DATAMAP_ENTRY_MASK = 3;
    public static final int DATAMAP_ENTRIES_PER_WORD = 16;
    private static final Object[] NO_METHODS;
    private static short[][] NO_INTERFACE_VTABLE_MAPS;
    static KlassInitializationState initializationQueue;
    private static final int INITSTATE_NOTINITIALIZED = 0;
    private static final int INITSTATE_INITIALIZING = 1;
    private static final int INITSTATE_INITIALIZED = 2;
    private static final int INITSTATE_FAILED = 3;
    public static Klass TOP;
    public static Klass ONE_WORD;
    public static Klass TWO_WORD;
    public static Klass BOOLEAN;
    public static Klass BYTE;
    public static Klass CHAR;
    public static Klass SHORT;
    public static Klass INT;
    public static Klass FLOAT;
    public static Klass LONG;
    public static Klass LONG2;
    public static Klass DOUBLE;
    public static Klass DOUBLE2;
    public static Klass VOID;
    public static Klass REFERENCE;
    public static Klass UNINITIALIZED;
    public static Klass UNINITIALIZED_THIS;
    public static Klass UNINITIALIZED_NEW;
    public static Klass NULL;
    public static Klass OBJECT;
    public static Klass STRING;
    public static Klass THROWABLE;
    public static Klass KLASS;
    public static Klass OBJECT_ARRAY;
    public static Klass STRING_ARRAY;
    public static Klass BOOLEAN_ARRAY;
    public static Klass BYTE_ARRAY;
    public static Klass CHAR_ARRAY;
    public static Klass SHORT_ARRAY;
    public static Klass INT_ARRAY;
    public static Klass FLOAT_ARRAY;
    public static Klass LONG_ARRAY;
    public static Klass DOUBLE_ARRAY;
    public static Klass STRING_OF_BYTES;
    public static Klass LOCAL;
    public static Klass LOCAL_ARRAY;
    public static Klass GLOBAL;
    public static Klass GLOBAL_ARRAY;
    public static Klass GLOBAL_ARRAYARRAY;
    public static Klass BYTECODE;
    public static Klass BYTECODE_ARRAY;
    public static Klass ADDRESS;
    public static Klass ADDRESS_ARRAY;
    public static Klass UWORD;
    public static Klass UWORD_ARRAY;
    public static Klass OFFSET;
    public static Klass NATIVEUNSAFE;

    public static Class asClass(Klass klass) {
        Class c;
        if (klassToClass == null) {
            klassToClass = new SquawkHashtable();
            klassClass = VM.getCurrentIsolate().getBootstrapSuite().lookup("java.lang.Class");
            Assert.always(klassClass != null);
        }
        if ((c = (Class)klassToClass.get(klass)) == null) {
            c = (Class)GC.newInstance(klassClass);
            NativeUnsafe.setObject(c, 0, klass);
            klassToClass.put(klass, c);
        }
        return c;
    }

    public static Klass asKlass(Class c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return (Klass)NativeUnsafe.getObject(c, 0);
    }

    public static Klass forName(String className) throws ClassNotFoundException {
        return Klass.forName(className, false, true);
    }

    static synchronized Klass forName(String className, boolean allowSystemClasses, boolean runClassInitializer) throws ClassNotFoundException {
        if (VM.isVeryVerbose()) {
            VM.print("[Klass.forName(");
            VM.print(className);
            VM.println(")]");
        }
        Klass klass = Klass.getClass(className, -1, false);
        Throwable cnfe = null;
        Isolate isolate = VM.getCurrentIsolate();
        if (klass == null) {
            if (isolate.getLeafSuite().isClosed()) {
                cnfe = new ClassNotFoundException(className + " [The current isolate has no class path]");
            } else if (!allowSystemClasses && (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("com.sun.squawk.") || className.startsWith("com.sun.cldc."))) {
                String packageName = className.substring(0, className.lastIndexOf(46));
                cnfe = new ClassNotFoundException("Prohibited package name: " + packageName);
            } else {
                TranslatorInterface translator = isolate.getTranslator();
                if (translator != null) {
                    translator.open(isolate.getLeafSuite(), isolate.getClassPath());
                    if (translator.isValidClassName(className)) {
                        klass = Klass.getClass(className, false);
                        translator.load(klass);
                        translator.close(3);
                    }
                } else if (VM.isVerbose()) {
                    VM.println("[translator not found - dynamic class loading disabled]");
                }
            }
        }
        if (klass != null && klass.getState() != 0) {
            if (runClassInitializer) {
                klass.initialiseClass();
            }
            return klass;
        }
        if (VM.getCurrentIsolate().getLeafSuite().shouldThrowNoClassDefFoundErrorFor(className)) {
            if (cnfe != null) {
                throw new NoClassDefFoundError(cnfe.getMessage());
            }
            throw new NoClassDefFoundError(className);
        }
        if (cnfe != null) {
            throw cnfe;
        }
        throw new ClassNotFoundException(className);
    }

    void initForObjectGraphLoader(MethodBody[] virtualMethods, MethodBody[] staticMethods, Klass superType, Klass[] interfaces, Object[] objects, UWord[] oopMap, UWord oopMapWord, UWord[] dataMap, UWord dataMapWord, int dataMapLength, int modifiers, byte state, short instanceSizeBytes, short staticFieldsSize, short refStaticFieldsSize, short indexForInit, short indexForClinit, short indexForMain, byte initModifiers, boolean mustClinit) {
        this.virtualMethods = virtualMethods;
        this.staticMethods = staticMethods;
        this.superType = superType;
        this.interfaces = interfaces;
        this.objects = objects;
        this.oopMap = oopMap;
        this.oopMapWord = oopMapWord;
        this.dataMap = dataMap;
        this.dataMapWord = dataMapWord;
        this.dataMapLength = dataMapLength;
        this.modifiers = modifiers;
        this.state = state;
        this.instanceSizeBytes = instanceSizeBytes;
        this.staticFieldsSize = staticFieldsSize;
        this.refStaticFieldsSize = refStaticFieldsSize;
        this.indexForInit = indexForInit;
        this.indexForClinit = indexForClinit;
        this.indexForMain = indexForMain;
        this.initModifiers = initModifiers;
        this.mustClinit = mustClinit;
    }

    public final Object newInstance() throws InstantiationException, IllegalAccessException {
        Assert.always(!this.isSquawkArray() && !this.isInterface() && !this.isAbstract() && this.hasDefaultConstructor());
        Object res = GC.newInstance(this);
        try {
            VM.callStaticOneParm(this, this.indexForInit & 0xFF, res);
        }
        catch (NoClassDefFoundError e) {
            if (e.getMessage() != null && e.getMessage().equals("static method missing")) {
                throw new NoClassDefFoundError("Error calling default constructor in newInstance() for class " + this.getName() + "\n error: " + e.toString());
            }
            throw e;
        }
        return res;
    }

    public final int getModifiers() throws AllowInlinedPragma {
        return this.modifiers;
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public final boolean isPrimitive() {
        return Modifier.isPrimitive(this.getModifiers());
    }

    public final boolean hasGlobalStatics() {
        return Modifier.hasGlobalStatics(this.getModifiers());
    }

    public final boolean hasMain() {
        return this.indexForMain != -1;
    }

    final short getMainIndex() {
        return this.indexForMain;
    }

    final short getClinitIndex() {
        return this.indexForClinit;
    }

    public final boolean hasDefaultConstructor() {
        return this.indexForInit != -1;
    }

    final short getDefaultConstructorIndex() {
        return this.indexForInit;
    }

    public final int getDefaultConstructorModifiers() {
        return this.initModifiers;
    }

    public final String toString() {
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    public final boolean isInstance(Object obj) {
        return obj != null && this.isAssignableFrom(GC.getKlass(obj));
    }

    public final boolean isArray() {
        return Modifier.isArray(this.getModifiers());
    }

    public final boolean isSquawkPrimitive() {
        return Modifier.isSquawkPrimitive(this.getModifiers());
    }

    public final boolean isSquawkArray() throws ForceInlinedPragma {
        return Klass.isSquawkArray(this);
    }

    static boolean isSquawkArray(Klass klass) throws ForceInlinedPragma {
        return Modifier.isSquawkArray(klass.modifiers);
    }

    final int getSquawkArrayComponentDataSize() throws ForceInlinedPragma {
        return Klass.getSquawkArrayComponentDataSize(this);
    }

    static int getSquawkArrayComponentDataSize(Klass klass) {
        if (klass.id == 26) {
            return 1;
        }
        if (klass.id == 2) {
            return 2;
        }
        return Klass.getDataSize(Klass.getComponentType(klass));
    }

    public final String getName() {
        if (!this.isArray()) {
            return this.name;
        }
        Klass base = this.componentType;
        int dimensions = 1;
        while (base.isArray()) {
            base = base.getComponentType();
            ++dimensions;
        }
        if (!base.isPrimitive()) {
            return this.name.substring(0, dimensions) + 'L' + this.name.substring(dimensions) + ';';
        }
        char primitive = Klass.getSignatureFirstChar(base.getSystemID());
        return this.name.substring(0, dimensions) + primitive;
    }

    public final Klass getSuperclass() {
        if (this.isInterface() || this.isPrimitive() || this.isInternalType() || this == VOID || this == OBJECT) {
            return null;
        }
        return this.superType;
    }

    public final boolean isAssignableFrom(Klass klass) {
        if (this == klass || this == TOP) {
            return true;
        }
        if (klass.isSubtypeOf(this)) {
            return true;
        }
        if (klass == NULL) {
            return this.isInterface() || this.isSubtypeOf(OBJECT);
        }
        if (this.isArray()) {
            if (klass.isArray()) {
                return this.getComponentType().isAssignableFrom(klass.getComponentType());
            }
        } else if (this.isInterface()) {
            return klass.isImplementorOf(this);
        }
        return false;
    }

    public final InputStream getResourceAsStream(String name) {
        Isolate isolate = VM.getCurrentIsolate();
        Suite suite = isolate.getLeafSuite();
        if (suite == null) {
            suite = isolate.getBootstrapSuite();
        }
        return suite.getResourceAsStream(name, this);
    }

    private Klass(String name, Klass componentType, int suiteID, boolean hasSystemID) {
        this.name = name;
        this.id = hasSystemID ? (short)suiteID : (short)(-(suiteID + 1));
        this.oopMapWord = UWord.zero();
        Assert.always((suiteID & 0xFFFF) == suiteID);
        if (name.charAt(0) == '[') {
            int log2ComponentDataSize;
            this.componentType = componentType;
            this.modifiers = 6815745;
            this.superType = OBJECT;
            this.interfaces = NO_CLASSES;
            switch (componentType.getDataSize()) {
                case 1: {
                    log2ComponentDataSize = 0;
                    break;
                }
                case 2: {
                    log2ComponentDataSize = 1;
                    break;
                }
                case 4: {
                    log2ComponentDataSize = 2;
                    break;
                }
                case 8: {
                    log2ComponentDataSize = 3;
                    break;
                }
                default: {
                    throw Assert.shouldNotReachHere();
                }
            }
            this.dataMapWord = UWord.fromPrimitive(log2ComponentDataSize);
        } else {
            this.componentType = null;
            this.dataMapWord = UWord.zero();
            if (hasSystemID && (suiteID == 2 || suiteID == 26)) {
                this.modifiers = 0x400000;
                int log2ComponentDataSize = 0;
                if (suiteID == 2) {
                    log2ComponentDataSize = 1;
                }
                this.dataMapWord = UWord.fromPrimitive(log2ComponentDataSize);
            }
        }
    }

    protected Klass(String name, Klass superType) {
        this.name = name;
        this.id = Short.MIN_VALUE;
        this.modifiers = 524289;
        this.superType = superType;
        this.state = (byte)4;
        this.componentType = null;
        this.oopMapWord = UWord.zero();
        this.dataMapWord = UWord.zero();
    }

    public final void updateModifiers(int modifiers) {
        if ((this.modifiers & modifiers) == modifiers) {
            return;
        }
        if ((modifiers & 0x80000) != 0) {
            this.state = (byte)4;
            this.interfaces = NO_CLASSES;
        }
        this.modifiers |= modifiers;
        if ((modifiers & 0x1000000) != 0) {
            this.resizeStaticFields();
        }
    }

    public final String getInternalName() {
        return Klass.getInternalName(this);
    }

    static String getInternalName(Klass klass) {
        return klass.name;
    }

    public final String getSignature() {
        if (this.isPrimitive() || this == VOID) {
            return "" + Klass.getSignatureFirstChar(this.getSystemID());
        }
        if (this.isArray()) {
            return this.getName().replace('.', '/');
        }
        return "L" + this.getName().replace('.', '/') + ";";
    }

    public static char getSignatureFirstChar(int systemID) {
        switch (systemID) {
            case 6: {
                return 'Z';
            }
            case 7: {
                return 'B';
            }
            case 8: {
                return 'C';
            }
            case 9: {
                return 'S';
            }
            case 10: {
                return 'I';
            }
            case 11: {
                return 'J';
            }
            case 13: {
                return 'F';
            }
            case 14: {
                return 'D';
            }
            case 5: {
                return 'V';
            }
        }
        return 'L';
    }

    public static String getNames(Klass[] klasses) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i != klasses.length; ++i) {
            buf.append(klasses[i].getName());
            if (i == klasses.length - 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public final int getSuiteID() throws ForceInlinedPragma {
        return Klass.getSuiteID(this);
    }

    public final int getSystemID() throws AllowInlinedPragma {
        return Klass.getSystemID(this);
    }

    static int getSuiteID(Klass klass) {
        return klass.id >= 0 ? klass.id : -(klass.id + 1);
    }

    static int getSystemID(Klass klass) {
        return klass.id;
    }

    public final Klass getComponentType() {
        return Klass.getComponentType(this);
    }

    static Klass getComponentType(Klass klass) {
        return klass.componentType;
    }

    final int getInstanceSize() throws ForceInlinedPragma {
        return Klass.getInstanceSize(this);
    }

    static int getInstanceSize(Klass klass) throws ForceInlinedPragma {
        return (klass.instanceSizeBytes + 3) / 4;
    }

    public final int getStaticFieldsSize() {
        return this.staticFieldsSize;
    }

    public final int getRefStaticFieldsSize() {
        return Klass.getRefStaticFieldsSize(this);
    }

    static int getRefStaticFieldsSize(Klass klass) {
        return klass.refStaticFieldsSize;
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public final boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public final boolean isSourceSynthetic() {
        return Modifier.isSourceSynthetic(this.getModifiers());
    }

    public final boolean isPragma() {
        return this.name.startsWith("com.sun.squawk.pragma.");
    }

    public final boolean isInternalType() {
        return this.name.charAt(this.name.length() - 1) == '-';
    }

    final boolean isSubclassOf(Klass klass) {
        if (this.isPrimitive() != klass.isPrimitive()) {
            return false;
        }
        for (Klass thisClass = this; thisClass != null; thisClass = thisClass.getSuperclass()) {
            if (thisClass != klass) continue;
            return true;
        }
        return false;
    }

    static boolean isSubtypeOf(Klass thisClass, Klass klass) {
        while (thisClass != null) {
            if (thisClass == klass) {
                return true;
            }
            thisClass = thisClass.superType;
        }
        return false;
    }

    final boolean isSubtypeOf(Klass klass) throws ForceInlinedPragma {
        return Klass.isSubtypeOf(this, klass);
    }

    private final boolean isImplementorOf(Klass anInterface) {
        for (int i = 0; i < this.interfaces.length; ++i) {
            Klass iface = this.interfaces[i];
            if (iface != anInterface && !iface.isImplementorOf(anInterface)) continue;
            return true;
        }
        if (this.getSuperclass() != null) {
            return this.superType.isImplementorOf(anInterface);
        }
        return false;
    }

    public final boolean isInSamePackageAs(Klass klass) {
        int last2;
        String name1 = this.getInternalName();
        String name2 = klass.getInternalName();
        int last1 = name1.lastIndexOf(46);
        if (last1 != (last2 = name2.lastIndexOf(46))) {
            return false;
        }
        if (last1 == -1) {
            return true;
        }
        for (int i = 0; i < last1; ++i) {
            if (name1.charAt(i) == name2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean isAccessibleFrom(Klass klass) {
        return klass == null || klass == this || this.isPublic() || this.isInSamePackageAs(klass);
    }

    public final boolean isReferenceType() {
        return !this.isPrimitive() && this != LONG2 && this != DOUBLE2 && !this.isSquawkPrimitive();
    }

    public final int getDataSize() throws ForceInlinedPragma {
        return Klass.getDataSize(this);
    }

    static int getDataSize(Klass klass) {
        switch (Klass.getSystemID(klass)) {
            case 6: 
            case 7: 
            case 32: {
                return 1;
            }
            case 8: 
            case 9: {
                return 2;
            }
            case 11: 
            case 14: {
                return 8;
            }
            case 10: 
            case 13: {
                return 4;
            }
        }
        return 4;
    }

    public final Klass getSuperType() {
        return this.superType;
    }

    public final Klass[] getInterfaces() {
        if (this.interfaces == null) {
            return NO_CLASSES;
        }
        Klass[] arr = new Klass[this.interfaces.length];
        System.arraycopy(this.interfaces, 0, arr, 0, arr.length);
        return arr;
    }

    final int findSlot(Klass iklass, int islot) {
        int icount = this.interfaces.length;
        for (int i = 0; i < icount; ++i) {
            if (this.interfaces[i] != iklass) continue;
            return this.interfaceVTableMaps[i][islot];
        }
        return this.superType.findSlot(iklass, islot);
    }

    final int findISlot(int vslot, Object[] results) {
        int icount = this.interfaceVTableMaps.length;
        for (int i = 0; i < icount; ++i) {
            short[] islots = this.interfaceVTableMaps[i];
            int scount = islots.length;
            for (int j = 0; j < scount; ++j) {
                if (islots[j] != vslot) continue;
                Klass iKlass = this.interfaces[i];
                results[0] = iKlass;
                return j;
            }
        }
        return -1;
    }

    public final Object[] getVirtualMethods() {
        return this.virtualMethods;
    }

    public final Object[] getStaticMethods() {
        return this.staticMethods;
    }

    public static String toString(Member member, boolean showType) {
        String s = member.getFullyQualifiedName();
        if (member instanceof Method) {
            Method method = (Method)member;
            StringBuffer buf = showType ? new StringBuffer(method.getReturnType().getInternalName()).append(' ').append(s) : new StringBuffer(s);
            Klass[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 0) {
                buf.append("()");
            } else {
                buf.append('(');
                for (int i = 0; i < parameterTypes.length; ++i) {
                    buf.append(parameterTypes[i].getInternalName());
                    if (i == parameterTypes.length - 1) continue;
                    buf.append(',');
                }
                buf.append(')');
            }
            s = buf.toString();
        } else {
            Field field = (Field)member;
            if (showType) {
                s = field.getType().getInternalName() + ' ' + s;
            }
        }
        return s;
    }

    public static boolean isAccessibleFrom(Member member, Klass klass) {
        return Klass.isAccessibleFrom(member.getDefiningClass(), member.getModifiers(), klass);
    }

    public static boolean isAccessibleFrom(Klass definingClass, int modifiers, Klass accessingKlass) {
        if (accessingKlass == null || definingClass == accessingKlass || Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (definingClass.isInSamePackageAs(accessingKlass)) {
            return true;
        }
        if (Modifier.isProtected(modifiers)) {
            return accessingKlass.getSuperclass().isSubclassOf(definingClass);
        }
        return false;
    }

    public final boolean isDoubleWord() {
        return Modifier.isDoubleWord(this.getModifiers());
    }

    private void resizeStaticFields() {
        int count = this.getFieldCount(true);
        for (int i = 0; i != count; ++i) {
            Field field = this.getField(i, true);
            int offset = field.getOffset();
            if (field.getType().isDoubleWord()) {
                ++offset;
            }
            if (this.staticFieldsSize > offset) continue;
            int newSize = offset + 1;
            this.staticFieldsSize = (short)newSize;
            if ((this.staticFieldsSize & 0xFFFF) == newSize) continue;
            throw new NoClassDefFoundError("static fields overflow");
        }
    }

    public final int getState() {
        return this.state;
    }

    public final void changeState(byte state) {
        this.state = state;
        if (this.isArray()) {
            this.virtualMethods = this.superType.virtualMethods;
        } else if (state == 4) {
            Debugger debugger;
            if (!this.isSynthetic() && this != OBJECT) {
                if (!this.isInterface()) {
                    int i;
                    for (i = 0; i != this.virtualMethods.length; ++i) {
                        if (this.virtualMethods[i] == null && i < this.superType.virtualMethods.length) {
                            this.virtualMethods[i] = this.superType.virtualMethods[i];
                        }
                        if (this.isAbstract() || this.virtualMethods[i] != null || this.isSquawkPrimitive()) continue;
                        this.virtualMethods[i] = Klass.OBJECT.virtualMethods[9];
                        Assert.always(this.virtualMethods[i] != null);
                    }
                    for (i = 0; i != this.staticMethods.length; ++i) {
                        if (this.staticMethods[i] != null) continue;
                        this.staticMethods[i] = Klass.OBJECT.staticMethods[1];
                    }
                }
                if (!VM.isHosted()) {
                    this.fixupMethodTables();
                }
            }
            if (!VM.isHosted() && !this.isInternalType() && (debugger = VM.getCurrentIsolate().getDebugger()) != null) {
                debugger.notifyEvent(new Debugger.Event(8, this));
            }
            if (VM.isVerbose() && !this.isSynthetic()) {
                System.out.println("[Loaded " + this.name + "]");
            }
        }
    }

    protected final void setSuperType(Klass superType) {
        this.superType = superType;
    }

    public final void setClassFileDefinition(Klass superClass, Klass[] interfaces, ClassFileMethod[] virtualMethods, ClassFileMethod[] staticMethods, ClassFileField[] instanceFields, ClassFileField[] staticFields, String sourceFile) {
        if (superClass != null && this != STRING_OF_BYTES) {
            this.setSuperType(superClass);
        }
        if (!this.isInterface()) {
            this.initializeInstanceFields(instanceFields);
        }
        staticFields = this.initializeStaticFields(staticFields);
        this.initializeVTable(virtualMethods);
        this.initializeSTable(staticMethods);
        Suite suite = VM.getCurrentIsolate().getLeafSuite();
        KlassMetadata metadata = new KlassMetadata(this, virtualMethods, staticMethods, instanceFields, staticFields, sourceFile, this.virtualMethods.length, this.staticMethods.length);
        suite.installMetadata(metadata);
        this.setInterfaces(interfaces);
    }

    private ClassFileField[] initializeStaticFields(ClassFileField[] fields) {
        if (fields.length == 0) {
            return fields;
        }
        int refOffset = 0;
        int primitiveOffset = 0;
        int constantOffset = 0;
        int refIndex = 0;
        int primitiveIndex = 0;
        int constantIndex = 0;
        for (int i = 0; i != fields.length; ++i) {
            ClassFileField field = fields[i];
            Klass type = field.getType();
            if (!type.isReferenceType()) {
                int fieldModifiers = field.getModifiers();
                if (!Modifier.hasConstant(fieldModifiers) || !Modifier.isFinal(fieldModifiers)) {
                    field.setOffset(primitiveOffset++);
                    if (type.isDoubleWord()) {
                        ++primitiveOffset;
                    }
                    ++constantIndex;
                    continue;
                }
                field.setOffset(constantOffset++);
                if (!type.isDoubleWord()) continue;
                ++constantOffset;
                continue;
            }
            field.setOffset(refOffset++);
            ++primitiveIndex;
            ++constantIndex;
        }
        ClassFileField[] sortedFields = new ClassFileField[fields.length];
        int constantSize = constantOffset;
        constantOffset = primitiveOffset + refOffset;
        primitiveOffset = refOffset;
        for (int i = 0; i != fields.length; ++i) {
            ClassFileField field = fields[i];
            Klass type = field.getType();
            int offset = field.getOffset();
            if (!type.isReferenceType()) {
                int fieldModifiers = field.getModifiers();
                if (!Modifier.hasConstant(fieldModifiers) || !Modifier.isFinal(fieldModifiers)) {
                    offset += primitiveOffset;
                    sortedFields[primitiveIndex++] = field;
                } else {
                    offset += constantOffset;
                    sortedFields[constantIndex++] = field;
                }
                field.setOffset(offset);
                continue;
            }
            sortedFields[refIndex++] = field;
        }
        if (this.hasGlobalStatics()) {
            Klass.initializeGlobalStatics(this, fields);
        }
        if (!VM.isHosted() && constantSize > 0) {
            this.modifiers |= 0x1000000;
        }
        this.staticFieldsSize = (short)(constantOffset + constantSize);
        this.refStaticFieldsSize = (short)primitiveOffset;
        if ((this.staticFieldsSize & 0xFFFF) != constantOffset + constantSize) {
            throw new NoClassDefFoundError("static fields overflow");
        }
        return sortedFields;
    }

    private static void initializeGlobalStatics(Klass klass, ClassFileField[] fields) {
        Hashtable intGlobals = Global.getGlobalInts();
        Hashtable addrGlobals = Global.getGlobalAddrs();
        Hashtable oopGlobals = Global.getGlobalOops();
        for (int i = 0; i != fields.length; ++i) {
            Hashtable table;
            ClassFileField field = fields[i];
            int fieldModifiers = field.getModifiers();
            Klass type = field.getType();
            String fieldname = klass.getInternalName() + "." + field.getName();
            if (Modifier.hasConstant(fieldModifiers) && Modifier.isFinal(fieldModifiers)) continue;
            switch (type.getSystemID()) {
                case 11: 
                case 14: 
                case 36: 
                case 38: {
                    Assert.shouldNotReachHere("[Klass.java:1968] ");
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    table = intGlobals;
                    break;
                }
                case 34: {
                    table = addrGlobals;
                    break;
                }
                default: {
                    table = oopGlobals;
                }
            }
            Integer index = (Integer)table.get(fieldname);
            if (index != null) continue;
            index = new Integer(table.size());
            table.put(fieldname, index);
        }
    }

    private void initializeInstanceFields(ClassFileField[] fields) {
        if (this == OBJECT) {
            this.oopMap = null;
            this.oopMapWord = UWord.zero();
            this.dataMap = null;
            this.dataMapWord = UWord.zero();
            return;
        }
        if (this == STRING || this == STRING_OF_BYTES) {
            this.oopMap = null;
            this.oopMapWord = UWord.zero();
            this.dataMap = null;
            return;
        }
        if (fields.length == 0) {
            this.instanceSizeBytes = this.superType.instanceSizeBytes;
            this.oopMap = this.superType.oopMap;
            this.oopMapWord = this.superType.oopMapWord;
            this.dataMap = this.superType.dataMap;
            this.dataMapWord = this.superType.dataMapWord;
            this.dataMapLength = this.superType.dataMapLength;
            return;
        }
        this.instanceSizeBytes = (short)this.initializeFieldOffsets(fields);
        if ((this.instanceSizeBytes & 0xFFFF) != this.instanceSizeBytes) {
            throw new NoClassDefFoundError("instance fields overflow");
        }
        this.initializeOopMap(fields);
        this.initializeDataMap(fields);
    }

    private int initializeFieldOffsets(ClassFileField[] fields) {
        int offset = GC.roundUpToWord(this.superType.instanceSizeBytes);
        block6: for (int i = 0; i != fields.length; ++i) {
            ClassFileField field = fields[i];
            Klass type = field.getType();
            switch (type.getSystemID()) {
                case 6: 
                case 7: {
                    field.setOffset(offset++);
                    continue block6;
                }
                case 8: 
                case 9: {
                    if (offset % 2 != 0) {
                        ++offset;
                    }
                    field.setOffset(offset / 2);
                    offset += 2;
                    continue block6;
                }
                case 11: 
                case 14: {
                    int modWord = offset % 4;
                    if (modWord != 0) {
                        offset += 4 - modWord;
                    }
                    field.setOffset(offset / 4);
                    offset += 8;
                    continue block6;
                }
                case 10: 
                case 13: {
                    int mod4 = offset % 4;
                    if (mod4 != 0) {
                        offset += 4 - mod4;
                    }
                    field.setOffset(offset / 4);
                    offset += 4;
                    continue block6;
                }
                default: {
                    int modWord = offset % 4;
                    if (modWord != 0) {
                        offset += 4 - modWord;
                    }
                    field.setOffset(offset / 4);
                    offset += 4;
                    continue block6;
                }
            }
        }
        return offset;
    }

    private void initializeOopMap(ClassFileField[] fields) {
        int instanceSize = this.getInstanceSize();
        if (instanceSize > 32) {
            this.oopMap = new UWord[(instanceSize + 32 - 1) / 32];
            if (this.superType.getInstanceSize() > 32) {
                UWord[] superOopMap = this.superType.oopMap;
                System.arraycopy(superOopMap, 0, this.oopMap, 0, superOopMap.length);
                for (int i = superOopMap.length; i < this.oopMap.length; ++i) {
                    this.oopMap[i] = UWord.zero();
                }
            } else {
                this.oopMap[0] = this.superType.oopMapWord;
                for (int i = 1; i < this.oopMap.length; ++i) {
                    this.oopMap[i] = UWord.zero();
                }
            }
        } else {
            this.oopMapWord = this.superType.oopMapWord;
        }
        for (int i = 0; i != fields.length; ++i) {
            ClassFileField field = fields[i];
            if (!field.getType().isReferenceType()) continue;
            int offset = field.getOffset();
            UWord bit = UWord.fromPrimitive(1 << offset % 32);
            if (instanceSize > 32) {
                int index = offset / 32;
                this.oopMap[index] = this.oopMap[index].or(bit);
                continue;
            }
            this.oopMapWord = this.oopMapWord.or(bit);
        }
    }

    private void initializeDataMap(ClassFileField[] fields) {
        int paddingEntries = GC.roundUpToWord(this.superType.instanceSizeBytes) - this.superType.instanceSizeBytes;
        int totalEntries = fields.length + this.superType.getDataMapLength() + paddingEntries;
        if (totalEntries > 16) {
            this.dataMap = new UWord[(totalEntries + 16 - 1) / 16];
            if (this.superType.getDataMapLength() > 16) {
                UWord[] superDataMap = this.superType.dataMap;
                System.arraycopy(superDataMap, 0, this.dataMap, 0, superDataMap.length);
                for (int i = superDataMap.length; i < this.dataMap.length; ++i) {
                    this.dataMap[i] = UWord.zero();
                }
            } else {
                this.dataMap[0] = this.superType.dataMapWord;
                for (int i = 1; i < this.dataMap.length; ++i) {
                    this.dataMap[i] = UWord.zero();
                }
            }
        } else {
            this.dataMapWord = this.superType.dataMapWord;
        }
        this.dataMapLength = this.superType.dataMapLength + paddingEntries;
        for (int i = 0; i != fields.length; ++i) {
            int log2DataSize = 0;
            ClassFileField field = fields[i];
            int dataSize = field.getType().getDataSize();
            switch (dataSize) {
                case 1: {
                    log2DataSize = 0;
                    break;
                }
                case 2: {
                    log2DataSize = 1;
                    break;
                }
                case 4: {
                    log2DataSize = 2;
                    break;
                }
                case 8: {
                    log2DataSize = 3;
                    break;
                }
                default: {
                    throw Assert.shouldNotReachHere();
                }
            }
            int shift = this.dataMapLength % 16 * 2;
            UWord encodedDataSize = UWord.fromPrimitive(log2DataSize << shift);
            if (totalEntries > 16) {
                int index = this.dataMapLength / 16;
                this.dataMap[index] = this.dataMap[index].or(encodedDataSize);
            } else {
                this.dataMapWord = this.dataMapWord.or(encodedDataSize);
            }
            ++this.dataMapLength;
        }
    }

    public final int getDataMapLength() {
        return this.dataMapLength;
    }

    public final int getDataMapEntry(int index) {
        UWord dataMapWord = this.dataMapLength > 16 ? this.dataMap[index / 16] : this.dataMapWord;
        int log2DataSize = dataMapWord.toPrimitive() >> index % 16 * 2 & 3;
        int dataSize = 1 << log2DataSize;
        return dataSize;
    }

    private static Object[] createMethodTable(int count) {
        return count == 0 ? NO_METHODS : new Object[count];
    }

    private void initializeVTable(ClassFileMethod[] methods) {
        if (this == OBJECT || this.isInterface()) {
            int offset = 0;
            for (int i = 0; i < methods.length; ++i) {
                ClassFileMethod method = methods[i];
                if (PragmaException.isHosted(method.getPragmas())) {
                    method.setOffset(65535);
                    continue;
                }
                method.setOffset(offset);
                offset = (short)(offset + 1);
            }
            this.virtualMethods = Klass.createMethodTable(offset);
        } else if (methods.length == 0) {
            this.virtualMethods = this.superType.virtualMethods;
        } else {
            int offset = this.superType.virtualMethods.length;
            for (int i = 0; i < methods.length; ++i) {
                ClassFileMethod method = methods[i];
                if (PragmaException.isHosted(method.getPragmas())) {
                    method.setOffset(65535);
                    continue;
                }
                Method superMethod = this.superType.lookupMethod(method.getName(), method.getParameterTypes(), method.getReturnType(), null, false);
                if (superMethod != null && !superMethod.getDefiningClass().isInterface()) {
                    if (superMethod.isFinal()) {
                        throw new NoClassDefFoundError("cannot override final method");
                    }
                    if (superMethod.isNative()) {
                        throw new NoClassDefFoundError("cannot override native method ");
                    }
                    if (superMethod.isAccessibleFrom(this)) {
                        method.setOffset(superMethod.getOffset());
                        continue;
                    }
                    method.setOffset(offset++);
                    continue;
                }
                method.setOffset(offset++);
            }
            this.virtualMethods = Klass.createMethodTable(offset);
        }
    }

    private void initializeSTable(ClassFileMethod[] methods) {
        int offset = 0;
        for (int i = 0; i != methods.length; i = (int)((short)(i + 1))) {
            ClassFileMethod method = methods[i];
            if (PragmaException.isHosted(method.getPragmas())) {
                method.setOffset(65535);
                continue;
            }
            method.setOffset(offset);
            if (method.isDefaultConstructor()) {
                this.indexForInit = (short)offset;
                this.initModifiers = (byte)method.getModifiers();
            } else if (method.isClinit()) {
                this.indexForClinit = (short)offset;
                Assert.always(!this.hasGlobalStatics());
            } else if (method.isMain()) {
                this.indexForMain = (short)offset;
            }
            offset = (short)(offset + 1);
        }
        this.mustClinit = this.setMustClinit();
        this.staticMethods = Klass.createMethodTable(offset);
    }

    public final void installMethodBody(MethodBody body, boolean isStatic) {
        int offset = body.getDefiningMethod().getOffset();
        Object[] methodTable = isStatic ? this.staticMethods : this.virtualMethods;
        methodTable[offset] = body;
        KlassMetadata klassmetadata = this.getMetadata();
        klassmetadata.setMethodMetadata(isStatic, offset, body.getMetadata());
    }

    public final String getSourceFileName() {
        KlassMetadata metadata = this.getMetadata();
        return metadata == null ? null : metadata.getSourceFileName();
    }

    final String getSourceFilePath() {
        int last;
        String fileName = this.getSourceFileName();
        if (fileName != null && (last = this.name.lastIndexOf(46)) >= 0) {
            fileName = this.name.substring(0, last + 1).replace('.', '/') + fileName;
        }
        return fileName;
    }

    private static void addToInterfaceClosure(SquawkVector closure, Klass[] interfaces) {
        for (int i = 0; i != interfaces.length; ++i) {
            Klass iface = interfaces[i];
            if (closure.contains(iface)) continue;
            closure.addElement(iface);
            if (iface.interfaces.length == 0) continue;
            Klass.addToInterfaceClosure(closure, iface.interfaces);
        }
    }

    private void setInterfaces(Klass[] cfInterfaces) {
        Klass superClass;
        if (this.isInterface() || this.isAbstract()) {
            this.interfaces = cfInterfaces;
            this.interfaceVTableMaps = NO_INTERFACE_VTABLE_MAPS;
            return;
        }
        SquawkVector closure = new SquawkVector(cfInterfaces.length);
        Klass.addToInterfaceClosure(closure, cfInterfaces);
        for (superClass = this.getSuperclass(); superClass != null && superClass.isAbstract(); superClass = superClass.getSuperclass()) {
            Klass.addToInterfaceClosure(closure, superClass.interfaces);
        }
        while (superClass != null) {
            if (!superClass.isAbstract()) {
                Klass[] superInterfaces = superClass.interfaces;
                for (int i = 0; i < superInterfaces.length; ++i) {
                    closure.removeElement(superInterfaces[i]);
                }
            }
            superClass = superClass.getSuperclass();
        }
        if (closure.isEmpty()) {
            this.interfaces = NO_CLASSES;
            this.interfaceVTableMaps = NO_INTERFACE_VTABLE_MAPS;
        } else {
            this.interfaces = new Klass[closure.size()];
            closure.copyInto(this.interfaces);
            this.interfaceVTableMaps = new short[closure.size()][];
            for (int i = 0; i < this.interfaces.length; ++i) {
                Klass iface = this.interfaces[i];
                int count = iface.getMethodCount(false);
                this.interfaceVTableMaps[i] = new short[count];
                short[] vtableMap = this.interfaceVTableMaps[i];
                for (int index = 0; index < count; ++index) {
                    Method ifaceMethod = iface.getMethod(index, false);
                    Method implMethod = this.lookupMethod(ifaceMethod.getName(), ifaceMethod.getParameterTypes(), ifaceMethod.getReturnType(), null, false);
                    int offset = implMethod == null || !implMethod.isPublic() || implMethod.isAbstract() ? 9 : implMethod.getOffset();
                    vtableMap[index] = (short)offset;
                }
            }
        }
    }

    public final Method lookupMethod(String name, Klass[] parameterTypes, Klass returnType, Klass currentClass, boolean isStatic) {
        Method method;
        Klass superClass;
        int category;
        KlassMetadata metadata = this.getMetadata();
        if (metadata == null) {
            return null;
        }
        SymbolParser parser = metadata.getSymbolParser();
        int mid = parser.lookupMember(category = isStatic ? 3 : 2, name, parameterTypes, returnType);
        if (mid != -1) {
            Method method2 = new Method(metadata, mid);
            if (currentClass == null || currentClass == this || method2.isPublic() || method2.isProtected() || !method2.isPrivate() && this.isInSamePackageAs(currentClass)) {
                return method2;
            }
        }
        Klass klass = superClass = this.isInterface() ? OBJECT : this.getSuperclass();
        if (superClass != null && !name.equals("<init>") && !name.equals("<clinit>") && (method = superClass.lookupMethod(name, parameterTypes, returnType, currentClass, isStatic)) != null) {
            return method;
        }
        if (!isStatic && this.interfaces != null) {
            for (int i = 0; i != this.interfaces.length; ++i) {
                Method method3 = this.interfaces[i].lookupMethod(name, parameterTypes, returnType, currentClass, false);
                if (method3 == null) continue;
                return method3;
            }
        }
        return null;
    }

    public final Method lookupVirtualMethod(int offset) {
        int category;
        Object[] table = this.virtualMethods;
        if (offset >= table.length) {
            return null;
        }
        KlassMetadata metadata = this.getMetadata();
        if (metadata == null) {
            return null;
        }
        SymbolParser parser = metadata.getSymbolParser();
        int mid = parser.lookupMethod(category = 2, offset);
        if (mid != -1) {
            return new Method(metadata, mid);
        }
        return null;
    }

    public final Field lookupField(String name, Klass type, boolean isStatic) {
        int category;
        KlassMetadata metadata = this.getMetadata();
        if (metadata == null) {
            return null;
        }
        SymbolParser parser = metadata.getSymbolParser();
        int mid = parser.lookupMember(category = isStatic ? 1 : 0, name, NO_CLASSES, type);
        if (mid != -1) {
            return new Field(metadata, mid);
        }
        Klass superClass = this.getSuperclass();
        if (superClass != null) {
            return superClass.lookupField(name, type, isStatic);
        }
        return null;
    }

    private KlassMetadata getMetadata() {
        if (this.isSynthetic() || this.isArray()) {
            return null;
        }
        return VM.getCurrentIsolate().getLeafSuite().getMetadata(this);
    }

    public final int getFieldCount(boolean isStatic) {
        int category = isStatic ? 1 : 0;
        KlassMetadata metadata = this.getMetadata();
        if (metadata == null) {
            return 0;
        }
        return metadata.getSymbolParser().getMemberCount(category);
    }

    public final Field getField(int index, boolean isStatic) {
        int category = isStatic ? 1 : 0;
        KlassMetadata metadata = this.getMetadata();
        if (metadata == null) {
            return null;
        }
        int fid = metadata.getSymbolParser().getMemberID(category, index);
        return new Field(metadata, fid);
    }

    public final int getMethodCount(boolean isStatic) {
        int category = isStatic ? 3 : 2;
        KlassMetadata metadata = this.getMetadata();
        if (metadata == null) {
            return 0;
        }
        return metadata.getSymbolParser().getMemberCount(category);
    }

    public final Method getMethod(int index, boolean isStatic) {
        int category = isStatic ? 3 : 2;
        KlassMetadata metadata = this.getMetadata();
        if (metadata == null) {
            return null;
        }
        SymbolParser parser = metadata.getSymbolParser();
        if (parser.getMemberCount(category) <= index) {
            return null;
        }
        int mid = parser.getMemberID(category, index);
        return new Method(metadata, mid);
    }

    public final int getMethodIndex(Object method, boolean isStatic) {
        Object[] methods = isStatic ? this.staticMethods : this.virtualMethods;
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i] != method) continue;
            return i;
        }
        return -1;
    }

    public final Object getMethodObject(Method method) {
        Object[] table = method.isStatic() ? this.staticMethods : this.virtualMethods;
        return table[method.getOffset()];
    }

    public static boolean isMissingMethodObject(Object method, boolean isStatic) {
        Object match = isStatic ? Klass.OBJECT.staticMethods[1] : Klass.OBJECT.virtualMethods[9];
        return method == match;
    }

    Method findMethod(Object body) {
        if (body instanceof MethodBody) {
            MethodBody mbody = (MethodBody)body;
            if (mbody.getDefiningClass() == this) {
                return mbody.getDefiningMethod();
            }
            return null;
        }
        KlassMetadata metadata = this.getMetadata();
        if (metadata == null) {
            return null;
        }
        if (VM.asKlass(NativeUnsafe.getObject(body, -3)) != this) {
            return null;
        }
        int methodID = -1;
        SymbolParser parser = metadata.getSymbolParser();
        int index = this.getMethodIndex(body, false);
        if (index >= 0) {
            methodID = parser.lookupMethod(2, index);
        }
        if (methodID == -1 && (index = this.getMethodIndex(body, true)) >= 0) {
            methodID = parser.lookupMethod(3, index);
        }
        if (methodID != -1) {
            return new Method(metadata, methodID);
        }
        return null;
    }

    final boolean isInstanceWordReference(int wordIndex) throws ForceInlinedPragma {
        return Klass.isInstanceWordReference(this, wordIndex);
    }

    static boolean isInstanceWordReference(Klass klass, int wordIndex) {
        UWord word = Klass.getInstanceSize(klass) > 32 ? klass.oopMap[wordIndex / 32] : klass.oopMapWord;
        UWord bit = UWord.fromPrimitive(1 << wordIndex % 32);
        return word.and(bit).ne(UWord.zero());
    }

    public final void setObjectTable(Object[] objects) {
        this.objects = objects;
    }

    public final Object getObject(int index) {
        return this.objects[index];
    }

    public final int getObjectIndex(Object object) {
        for (int i = 0; i != this.objects.length; ++i) {
            if (this.objects[i] != object) continue;
            return i;
        }
        return -1;
    }

    public final int hashCode() {
        return this.id;
    }

    final void main(String[] args) throws NotInlinedPragma {
        int index = this.indexForMain & 0xFF;
        if (index == 255) {
            throw new Error("Class " + this.getName() + " has no main() method");
        }
        VMThread thread = VMThread.currentThread();
        thread.setAppThreadTop(thread.framePointerAsOffset(VM.getFP()));
        VM.callStaticOneParm(this, index, args);
    }

    private int getInitializationState() {
        if (this.getClassState() != null) {
            return 2;
        }
        KlassInitializationState istate = initializationQueue;
        while (istate != null && istate.klass != this) {
            istate = istate.next;
        }
        if (istate == null) {
            return 0;
        }
        if (istate.thread == null) {
            return 3;
        }
        return 1;
    }

    private void setInitializationState(VMThread thread) {
        KlassInitializationState first;
        KlassInitializationState istate = first = initializationQueue;
        while (istate != null && istate.klass != this) {
            istate = istate.next;
        }
        if (istate == null) {
            istate = new KlassInitializationState();
            istate.next = first;
            istate.thread = thread;
            istate.klass = this;
            istate.classState = GC.newClassState(this);
            initializationQueue = istate;
        } else {
            istate.thread = thread;
        }
    }

    private VMThread getInitializationThread() {
        KlassInitializationState istate = initializationQueue;
        while (istate.klass != this) {
            istate = istate.next;
        }
        return istate.thread;
    }

    private Object getInitializationClassState() {
        KlassInitializationState istate = initializationQueue;
        while (istate.klass != this) {
            istate = istate.next;
        }
        return istate.classState;
    }

    private void removeInitializationState() {
        KlassInitializationState istate = initializationQueue;
        KlassInitializationState prev = null;
        while (istate.klass != this) {
            prev = istate;
            istate = istate.next;
        }
        if (prev == null) {
            initializationQueue = istate.next;
        } else {
            prev.next = istate.next;
        }
    }

    private void fixupMethodTable(Object[] methods) {
        for (int i = 0; i != methods.length; ++i) {
            if (!(methods[i] instanceof MethodBody)) continue;
            MethodBody body = (MethodBody)methods[i];
            methods[i] = GC.newMethod(body.getDefiningClass(), body);
        }
    }

    final void fixupMethodTables() {
        this.fixupMethodTable(this.staticMethods);
        this.fixupMethodTable(this.virtualMethods);
    }

    private Object getClassState() {
        return VM.getCurrentIsolate().getClassState(this);
    }

    public final boolean isInitialized() {
        return this.getState() == 4 && (!this.mustClinit() || this.getClassState() != null);
    }

    final void initialiseClass() {
        if (this.getState() == 5) {
            throw new NoClassDefFoundError(this.getName());
        }
        if (this.mustClinit() && this.getClassState() == null) {
            this.initializeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object initializeInternal() {
        if (this.state == 5) {
            throw new NoClassDefFoundError(this.name);
        }
        Klass klass = this;
        synchronized (klass) {
            if (this.getInitializationState() == 1) {
                if (this.getInitializationThread() != VMThread.currentThread()) {
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (this.getInitializationState() == 1);
                } else {
                    return this.getInitializationClassState();
                }
            }
            if (this.getInitializationState() == 2) {
                return this.getClassState();
            }
            if (this.getInitializationState() == 3) {
                throw new NoClassDefFoundError();
            }
            Assert.always(VMThread.currentThread() != null);
            this.setInitializationState(VMThread.currentThread());
        }
        if (!this.isInterface() && this.superType != null && this.superType.mustClinit() && this.superType.getInitializationState() != 2) {
            try {
                this.superType.initializeInternal();
            }
            catch (Error ex) {
                Klass e = this;
                synchronized (e) {
                    this.setInitializationState(null);
                    this.notifyAll();
                }
                throw ex;
            }
            catch (Throwable ex) {
                VM.fatalVMError();
            }
        }
        try {
            if ((this.modifiers & 0x1000000) != 0) {
                int count = this.getFieldCount(true);
                for (int i = 0; i != count; ++i) {
                    Field field = this.getField(i, true);
                    if (!field.hasConstant()) continue;
                    Object cs = this.getInitializationClassState();
                    int offset = field.getOffset() + 2;
                    if (field.getType().isPrimitive()) {
                        long value = field.getPrimitiveConstantValue();
                        switch (field.getType().getSystemID()) {
                            case 11: {
                                NativeUnsafe.setLongAtWord(cs, offset, value);
                                break;
                            }
                            case 14: {
                                NativeUnsafe.setLongAtWord(cs, offset, value);
                                break;
                            }
                            case 13: {
                                NativeUnsafe.setUWord(cs, offset, UWord.fromPrimitive((int)value));
                                break;
                            }
                            default: {
                                NativeUnsafe.setUWord(cs, offset, UWord.fromPrimitive((int)value));
                                break;
                            }
                        }
                        continue;
                    }
                    String value = field.getStringConstantValue();
                    NativeUnsafe.setObject(cs, offset, value);
                }
            }
            this.clinit();
            Klass count = this;
            synchronized (count) {
                Object cs = this.getInitializationClassState();
                VM.getCurrentIsolate().addClassState(cs);
                this.removeInitializationState();
                this.notifyAll();
                return cs;
            }
        }
        catch (Throwable ex2) {
            Error ex2;
            if (!(ex2 instanceof Error)) {
                ex2.printStackTrace();
                ex2 = new Error("ExceptionInInitializer: " + this.name + ":" + ex2);
            }
            Klass klass2 = this;
            synchronized (klass2) {
                this.setInitializationState(null);
                this.notifyAll();
            }
            throw (Error)ex2;
        }
    }

    public final boolean mustClinit() {
        return this.mustClinit || (this.modifiers & 0x1000000) != 0;
    }

    private boolean setMustClinit() {
        if (this.indexForClinit >= 0) {
            return true;
        }
        if (this.superType == null) {
            return false;
        }
        return this.superType.setMustClinit();
    }

    final void clinit() {
        short index = this.indexForClinit;
        if (index != -1) {
            if (VM.isVeryVerbose()) {
                VM.print("[initializing ");
                VM.print(this.isInterface() ? "interface " : "class ");
                VM.print(this.name);
                VM.println("]");
            }
            VM.callStaticNoParm(this, index);
        }
    }

    private static Klass boot(Klass superType, String name, int systemID, int modifiers) {
        Klass klass;
        Isolate isolate = VM.getCurrentIsolate();
        Suite bootstrapSuite = isolate.getBootstrapSuite();
        Klass klass2 = klass = systemID == -1 ? bootstrapSuite.lookup(name) : bootstrapSuite.getKlass(systemID);
        if (klass != null) {
            return klass;
        }
        Assert.always(VM.isHosted());
        return Klass.bootHosted(superType, name, systemID, modifiers, bootstrapSuite);
    }

    private static Klass bootHosted(Klass superType, String name, int systemID, int modifiers, Suite bootstrapSuite) throws HostedPragma {
        Klass klass = Klass.getClass(name, systemID, true);
        klass.setSuperType(superType);
        klass.updateModifiers(modifiers | klass.getModifiers());
        return klass;
    }

    static void initBootstrapClasses() {
        boolean none = false;
        boolean publik = true;
        int synthetic = 524289;
        int synthetic2 = 0x180001;
        int primitive = 786433;
        int primitive2 = 0x1C0001;
        int squawkarray = 0x400001;
        int squawkprimitive = 0x800000;
        TOP = Klass.boot(null, "-T-", -1, 524289);
        ONE_WORD = Klass.boot(TOP, "-1-", -1, 524289);
        TWO_WORD = Klass.boot(TOP, "-2-", -1, 0x180001);
        INT = Klass.boot(ONE_WORD, "int", 10, 786433);
        BOOLEAN = Klass.boot(INT, "boolean", 6, 786433);
        BYTE = Klass.boot(INT, "byte", 7, 786433);
        CHAR = Klass.boot(INT, "char", 8, 786433);
        SHORT = Klass.boot(INT, "short", 9, 786433);
        FLOAT = Klass.boot(ONE_WORD, "float", 13, 786433);
        LONG = Klass.boot(TWO_WORD, "long", 11, 0x1C0001);
        LONG2 = Klass.boot(ONE_WORD, "-long2-", 12, 0x1C0001);
        DOUBLE = Klass.boot(TWO_WORD, "double", 14, 0x1C0001);
        DOUBLE2 = Klass.boot(ONE_WORD, "-double2-", 15, 0x1C0001);
        VOID = Klass.boot(TOP, "void", 5, 524289);
        REFERENCE = Klass.boot(ONE_WORD, "-ref-", -1, 524289);
        UNINITIALIZED = Klass.boot(REFERENCE, "-uninit-", -1, 524289);
        UNINITIALIZED_THIS = Klass.boot(UNINITIALIZED, "-uninit_this-", -1, 524289);
        UNINITIALIZED_NEW = Klass.boot(UNINITIALIZED, "-uninit_new-", -1, 524289);
        OBJECT = Klass.boot(REFERENCE, "java.lang.Object", 1, 0);
        STRING = Klass.boot(OBJECT, "java.lang.String", 2, 0x400001);
        THROWABLE = Klass.boot(OBJECT, "java.lang.Throwable", 3, 0);
        KLASS = Klass.boot(OBJECT, "com.sun.squawk.Klass", 4, 0);
        NULL = Klass.boot(OBJECT, "-null-", 0, 524289);
        OBJECT_ARRAY = Klass.boot(OBJECT, "[java.lang.Object", 16, 524289);
        STRING_ARRAY = Klass.boot(OBJECT, "[java.lang.String", 17, 524289);
        BOOLEAN_ARRAY = Klass.boot(OBJECT, "[boolean", 18, 524289);
        BYTE_ARRAY = Klass.boot(OBJECT, "[byte", 19, 524289);
        CHAR_ARRAY = Klass.boot(OBJECT, "[char", 20, 524289);
        SHORT_ARRAY = Klass.boot(OBJECT, "[short", 21, 524289);
        INT_ARRAY = Klass.boot(OBJECT, "[int", 22, 524289);
        LONG_ARRAY = Klass.boot(OBJECT, "[long", 23, 524289);
        FLOAT_ARRAY = Klass.boot(OBJECT, "[float", 24, 524289);
        DOUBLE_ARRAY = Klass.boot(OBJECT, "[double", 25, 524289);
        STRING_OF_BYTES = Klass.boot(STRING, "com.sun.squawk.StringOfBytes", 26, 0x400001);
        LOCAL = Klass.boot(ONE_WORD, "-local-", 27, 524289);
        LOCAL_ARRAY = Klass.boot(OBJECT, "[-local-", 29, 524289);
        GLOBAL = Klass.boot(ONE_WORD, "-global-", 28, 524289);
        GLOBAL_ARRAY = Klass.boot(OBJECT, "[-global-", 30, 524289);
        GLOBAL_ARRAYARRAY = Klass.boot(OBJECT, "[[-global-", 31, 524289);
        ADDRESS = Klass.boot(OBJECT, "com.sun.squawk.Address", 34, 0x800000);
        ADDRESS_ARRAY = Klass.boot(OBJECT, "[com.sun.squawk.Address", 35, 0);
        UWORD = Klass.boot(OBJECT, "com.sun.squawk.UWord", 36, 0x800000);
        UWORD_ARRAY = Klass.boot(OBJECT, "[com.sun.squawk.UWord", 37, 0);
        OFFSET = Klass.boot(OBJECT, "com.sun.squawk.Offset", 38, 0x800000);
        NATIVEUNSAFE = Klass.boot(OBJECT, "com.sun.squawk.NativeUnsafe", 39, 0);
        BYTECODE = Klass.boot(INT, "-bytecode-", 32, 524289);
        BYTECODE_ARRAY = Klass.boot(OBJECT, "[-bytecode-", 33, 524289);
        if (VM.isHosted()) {
            Klass.loadReservedSystemClasses();
        }
    }

    private static void loadReservedSystemClasses() throws HostedPragma {
        Isolate isolate = VM.getCurrentIsolate();
        Suite bootstrapSuite = isolate.getBootstrapSuite();
        TranslatorInterface translator = isolate.getTranslator();
        for (int systemID = 0; systemID <= 39; ++systemID) {
            Klass klass = bootstrapSuite.getKlass(systemID);
            if (!klass.isArray() && !klass.isSynthetic()) {
                translator.load(klass);
            }
            if (!klass.isArray() || klass.virtualMethods != null) continue;
            klass.virtualMethods = klass.superType.virtualMethods;
        }
    }

    public static Klass getClass(String name, boolean isFieldDescriptor) {
        if (isFieldDescriptor) {
            int dimensions = 0;
            while (name.charAt(dimensions) == '[') {
                ++dimensions;
            }
            char first = name.charAt(dimensions);
            if (first != 'L') {
                Klass klass;
                switch (first) {
                    case 'I': {
                        klass = INT;
                        break;
                    }
                    case 'J': {
                        klass = LONG;
                        break;
                    }
                    case 'F': {
                        klass = FLOAT;
                        break;
                    }
                    case 'D': {
                        klass = DOUBLE;
                        break;
                    }
                    case 'Z': {
                        klass = BOOLEAN;
                        break;
                    }
                    case 'C': {
                        klass = CHAR;
                        break;
                    }
                    case 'S': {
                        klass = SHORT;
                        break;
                    }
                    case 'B': {
                        klass = BYTE;
                        break;
                    }
                    case 'V': {
                        klass = VOID;
                        break;
                    }
                    default: {
                        Assert.shouldNotReachHere("[Klass.java:3797] ");
                        return null;
                    }
                }
                if (dimensions != 0) {
                    return Klass.getClass(name.substring(0, dimensions) + klass.getInternalName(), -1, true);
                }
                return klass;
            }
            String baseName = name.substring(dimensions + 1, name.length() - 1);
            baseName = baseName.replace('/', '.');
            name = dimensions != 0 ? name.substring(0, dimensions) + baseName : baseName;
            return Klass.getClass(name, -1, true);
        }
        return Klass.getClass(name, -1, true);
    }

    private static Klass getClass(String name, int systemID, boolean create) {
        Klass klass;
        Isolate isolate = VM.getCurrentIsolate();
        Suite suite = isolate.getLeafSuite();
        if (suite == null) {
            suite = isolate.getBootstrapSuite();
        }
        if ((klass = suite.lookup(name)) == null && create) {
            if (name.charAt(0) == '[') {
                String componentName = name.substring(1);
                Klass componentType = Klass.getClass(componentName, -1, true);
                int suiteID = systemID == -1 ? suite.getNextAvailableClassNumber() : systemID;
                klass = new Klass(name, componentType, suiteID, systemID != -1);
            } else {
                if (suite.shouldThrowNoClassDefFoundErrorFor(name)) {
                    throw new NoClassDefFoundError(name);
                }
                int suiteID = systemID == -1 ? suite.getNextAvailableClassNumber() : systemID;
                klass = new Klass(name, null, suiteID, systemID != -1);
            }
            suite.installClass(klass);
        }
        return klass;
    }

    public static Klass getSecondWordType(Klass type) {
        if (type == DOUBLE) {
            return DOUBLE2;
        }
        return LONG2;
    }

    static {
        NO_CLASSES = new Klass[0];
        NO_METHODS = new Object[0];
        NO_INTERFACE_VTABLE_MAPS = new short[0][];
        Klass.initBootstrapClasses();
    }

    static class KlassInitializationState {
        KlassInitializationState next;
        VMThread thread;
        Klass klass;
        Object classState;

        KlassInitializationState() {
        }
    }
}

