/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.ClassFileField;
import com.sun.squawk.ClassFileMethod;
import com.sun.squawk.Klass;
import com.sun.squawk.MethodMetadata;
import com.sun.squawk.Suite;
import com.sun.squawk.SymbolParser;
import com.sun.squawk.VM;
import com.sun.squawk.util.SquawkVector;

public final class KlassMetadata {
    private final Klass definedClass;
    private final byte[] symbols;
    private final Klass[] classTable;
    private final MethodMetadata[] virtualMethodsMetadata;
    private final MethodMetadata[] staticMethodsMetadata;
    private final String sourceFile;

    KlassMetadata(Klass definedClass, ClassFileMethod[] virtualMethods, ClassFileMethod[] staticMethods, ClassFileField[] instanceFields, ClassFileField[] staticFields, String sourceFile, int vtableSize, int stableSize) {
        SquawkVector types = new SquawkVector();
        this.definedClass = definedClass;
        this.symbols = SymbolParser.createSymbols(virtualMethods, staticMethods, instanceFields, staticFields, types);
        this.sourceFile = sourceFile;
        this.virtualMethodsMetadata = new MethodMetadata[vtableSize];
        this.staticMethodsMetadata = new MethodMetadata[stableSize];
        this.classTable = new Klass[types.size()];
        types.copyInto(this.classTable);
    }

    KlassMetadata(Klass definedClass, byte[] symbols, Klass[] classTable) {
        this.definedClass = definedClass;
        this.symbols = symbols;
        this.classTable = classTable;
        this.sourceFile = null;
        this.virtualMethodsMetadata = null;
        this.staticMethodsMetadata = null;
    }

    static int addSignatureType(SquawkVector types, Klass type) {
        int systemID = type.getSystemID();
        if (systemID >= 0) {
            return systemID << 1;
        }
        int index = types.indexOf(type);
        if (index == -1) {
            index = types.size();
            types.addElement(type);
        }
        return index << 1 | 1;
    }

    static Klass getSignatureType(Klass[] types, int typeID) {
        if ((typeID & 1) == 0) {
            int systemID = typeID >>> 1;
            return VM.getCurrentIsolate().getBootstrapSuite().getKlass(systemID);
        }
        int index = typeID >>> 1;
        return types[index];
    }

    void setMethodMetadata(boolean isStatic, int index, MethodMetadata metadata) {
        if (metadata != null) {
            if (isStatic) {
                this.staticMethodsMetadata[index] = metadata;
            } else {
                this.virtualMethodsMetadata[index] = metadata;
            }
        }
    }

    MethodMetadata getMethodMetadata(boolean isStatic, int index) {
        Object[] methodArray;
        MethodMetadata[] methods;
        MethodMetadata[] methodMetadataArray = methods = isStatic ? this.staticMethodsMetadata : this.virtualMethodsMetadata;
        if (methods == null) {
            return null;
        }
        Object[] objectArray = methodArray = isStatic ? this.definedClass.getStaticMethods() : this.definedClass.getVirtualMethods();
        if (methodArray.length == methods.length) {
            return methods[index];
        }
        int realIndex = MethodMetadata.binarySearch(methods, index);
        if (realIndex >= 0) {
            return methods[realIndex];
        }
        return null;
    }

    Klass getDefinedClass() {
        return this.definedClass;
    }

    String getSourceFileName() {
        return this.sourceFile;
    }

    SymbolParser getSymbolParser() {
        return SymbolParser.create(this.symbols, this.classTable);
    }

    SymbolParser getSymbolParser(int memberID) {
        return SymbolParser.create(this.symbols, this.classTable, memberID);
    }

    int getSize() {
        return this.symbols.length;
    }

    static void flush() {
        SymbolParser.flush();
    }

    private KlassMetadata(byte[] symbols, Klass[] classTable, KlassMetadata original, int type) {
        this.symbols = symbols;
        this.classTable = classTable;
        this.sourceFile = type == 3 ? original.sourceFile : null;
        this.definedClass = original.definedClass;
        this.staticMethodsMetadata = MethodMetadata.strip(original.staticMethodsMetadata);
        this.virtualMethodsMetadata = MethodMetadata.strip(original.virtualMethodsMetadata);
    }

    static KlassMetadata[] strip(Suite suite, KlassMetadata[] metadatas, int type) {
        if (metadatas == null) {
            return null;
        }
        if (type == 0) {
            return null;
        }
        KlassMetadata[] newMetadatas = new KlassMetadata[metadatas.length];
        block5: for (int i = 0; i != metadatas.length; ++i) {
            KlassMetadata metadata = metadatas[i];
            if (metadata == null) continue;
            switch (type) {
                case 3: {
                    newMetadatas[i] = new KlassMetadata(metadata.symbols, metadata.classTable, metadata, type);
                    continue block5;
                }
                case 0: {
                    newMetadatas[i] = new KlassMetadata(null, null, metadata, type);
                    continue block5;
                }
                case 1: 
                case 2: {
                    newMetadatas[i] = metadata.strip(type);
                    continue block5;
                }
                default: {
                    VM.fatalVMError();
                }
            }
        }
        return newMetadatas;
    }

    private KlassMetadata strip(int type) {
        if (VM.stripSymbols(this.definedClass)) {
            return null;
        }
        SquawkVector types = new SquawkVector(this.classTable.length);
        byte[] newSymbols = this.getSymbolParser().strip(this.definedClass, type, types);
        Object[] newClassTable = new Klass[types.size()];
        types.copyInto(newClassTable);
        return new KlassMetadata(newSymbols, (Klass[])newClassTable, this, type);
    }
}

