/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.GarbageCollector;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Lisp2Bitmap;
import com.sun.squawk.MethodBody;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemorySerializer;
import com.sun.squawk.Offset;
import com.sun.squawk.Ref;
import com.sun.squawk.Suite;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.pragma.AllowInlinedPragma;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.BitSet;
import com.sun.squawk.vm.CS;
import java.io.PrintStream;

public final class Lisp2GenerationalCollector
extends GarbageCollector {
    private static final int DEFAULT_YOUNG_GENERATION_PERCENT = 20;
    private final MarkingStack markingStack;
    private Address permanentMemoryStart;
    private Address memoryStart;
    private Address heapStart;
    private int heapSize;
    private Address heapEnd;
    private Address memoryEnd;
    private Address collectionStart;
    private Address collectionEnd;
    private Address sliceTable;
    private int sliceCount;
    private int sliceSize;
    private int sliceTableSize;
    private int sliceOffsetBits;
    private int sliceOffsetShift;
    private int classOffsetBits;
    private int classOffsetMask;
    private boolean nextCollectionIsFull;
    private Address youngGenerationStart;
    private int idealYoungGenerationSizePercent;
    private static final int MAX_MARKING_RECURSION = 4;
    private int markingRecursionLevel;
    private int movedOopMaps;
    private Object stackChunks;
    private Timer timer;
    private final Timer fullCollectionTimer;
    private final Timer partialCollectionTimer;
    private static final int MARK_VISITOR = 0;
    private static final int UPDATE_VISITOR = 1;
    private static final int VERIFY_VISITOR = 2;
    private static final int WRITE_BARRIER_VERIFY_VISITOR = 3;
    private static final boolean VERBOSE_MARK_OBJECT_TRACE = true;
    private Address firstDeadBlock;
    private Address lastDeadBlock;
    private Address firstMovingBlock;
    private boolean copyingObjectGraph;
    private Object copiedStackChunks;
    private Address copiedObjects;
    private BitSet oopMap;
    private Klass HashTableKlass;
    private Klass ByteArrayKlass;
    private Klass IsolateKlass;
    private Isolate theIsolate;
    private final Timer copyTimer;

    Lisp2GenerationalCollector(Address ramStart, Address ramEnd) {
        int ramSize = ramEnd.diff(ramStart).toInt();
        Assert.always(ramSize > 0);
        int heapSize = Lisp2GenerationalCollector.calculateMaxHeapSize(ramSize);
        int bitmapSize = ramSize - heapSize;
        Address bitmap = ramEnd.sub(bitmapSize);
        Lisp2Bitmap.initialize(bitmap, bitmapSize, ramStart);
        this.markingStack = new MarkingStack();
        this.fullCollectionTimer = new Timer(this);
        this.partialCollectionTimer = new Timer(this);
        this.copyTimer = new Timer(this);
    }

    private static int computeMaxClassAddressSpace(int heapSize) {
        int romSize = VM.getRomEnd().diff(VM.getRomStart()).toInt();
        int nvmSize = GC.getNvmSize();
        int max = heapSize > romSize ? heapSize : romSize;
        return nvmSize > max ? nvmSize : max;
    }

    private static int bitsRequiredFor(int limit) {
        int bits = 0;
        while (limit != 0) {
            ++bits;
            limit >>>= 1;
        }
        return bits;
    }

    private static int calculateBitmapSize(int memorySize) {
        Assert.always(GC.roundDownToWord(memorySize) == memorySize);
        int alignment = 128;
        memorySize = GC.roundUp(memorySize, alignment);
        int bitCount = memorySize / 4;
        int size = bitCount / 8;
        return GC.roundUpToWord(size);
    }

    private static int calculateMaxHeapSize(int memorySize) {
        int heapSize = GC.roundDownToWord(memorySize / 33 * 32);
        Assert.always(memorySize >= heapSize + Lisp2GenerationalCollector.calculateBitmapSize(heapSize));
        return heapSize;
    }

    void initialize(Address permanentMemoryStart, Address memoryStart, Address memoryEnd) {
        Assert.always(memoryEnd.roundUpToWord().eq(memoryEnd));
        Assert.always(memoryStart.roundUpToWord().eq(memoryStart));
        Assert.always(permanentMemoryStart.roundUpToWord().eq(permanentMemoryStart));
        this.permanentMemoryStart = permanentMemoryStart;
        this.memoryStart = memoryStart;
        this.memoryEnd = memoryEnd;
        this.initializeHeap();
        int youngGenerationSize = this.getYoungGenerationSize();
        Address youngGenerationEnd = this.youngGenerationStart.add(youngGenerationSize);
        GC.setAllocationParameters(this.heapStart, this.youngGenerationStart, youngGenerationEnd, this.heapEnd);
    }

    private void initializeHeap() {
        int alignment = 128;
        this.heapStart = this.memoryStart.roundUp(alignment);
        Address alignedMemoryEnd = this.memoryEnd.roundDown(alignment);
        int memorySize = alignedMemoryEnd.diff(this.heapStart).toInt();
        Assert.always(memorySize > 0, "insufficient memory for collector");
        int minimumMarkingStackSize = 40;
        this.heapSize = Lisp2GenerationalCollector.calculateMaxHeapSize(memorySize - 40);
        Assert.always(this.heapSize >= alignment, "insufficient memory for collector");
        this.heapSize = GC.roundUp(this.heapSize, alignment);
        this.heapEnd = this.heapStart.add(this.heapSize);
        Assert.always(this.heapSize > 0, "insufficient memory for collector");
        int bitmappedMemorySize = this.heapEnd.diff(this.permanentMemoryStart).toInt() + 4;
        int bitmapSize = Lisp2GenerationalCollector.calculateBitmapSize(bitmappedMemorySize);
        boolean firstIteration = true;
        while (firstIteration || this.heapSize + bitmapSize + this.sliceTableSize + 40 > memorySize) {
            if (firstIteration) {
                firstIteration = false;
            } else {
                this.heapSize -= alignment;
            }
            this.heapEnd = this.heapStart.add(this.heapSize);
            bitmappedMemorySize = this.heapEnd.diff(this.permanentMemoryStart).toInt() + 4;
            bitmapSize = Lisp2GenerationalCollector.calculateBitmapSize(bitmappedMemorySize);
            int heapOffsetBits = Lisp2GenerationalCollector.bitsRequiredFor(this.heapSize / 4);
            int maxClassSpaceSize = Lisp2GenerationalCollector.computeMaxClassAddressSpace(this.heapSize);
            this.classOffsetBits = Lisp2GenerationalCollector.bitsRequiredFor(maxClassSpaceSize / 4);
            this.classOffsetMask = (1 << this.classOffsetBits) - 1 << 2;
            this.sliceOffsetShift = this.classOffsetBits + 2;
            this.sliceOffsetBits = 32 - this.sliceOffsetShift;
            if (this.sliceOffsetBits < heapOffsetBits) {
                this.sliceSize = (1 << this.sliceOffsetBits) * 4;
                this.sliceCount = (this.heapSize + (this.sliceSize - 1)) / this.sliceSize;
                this.sliceTableSize = this.sliceCount * 4;
                continue;
            }
            this.sliceOffsetBits = heapOffsetBits;
            this.sliceTableSize = 4;
            this.sliceSize = this.heapSize;
            this.sliceCount = 1;
        }
        this.sliceTable = alignedMemoryEnd.sub(this.sliceTableSize);
        Address bitmap = this.sliceTable.sub(bitmapSize);
        this.idealYoungGenerationSizePercent = 20;
        this.youngGenerationStart = this.heapStart;
        Lisp2Bitmap.initialize(bitmap, bitmapSize, this.permanentMemoryStart);
        Assert.always(this.sliceTable.add(this.sliceTableSize).loeq(alignedMemoryEnd), "slice table overflows memory boundary");
        Assert.always(this.sliceOffsetBits < 32, "slice size overflows 32 bit address space");
        Assert.always(bitmap.add(bitmapSize).loeq(this.sliceTable), "bitmap collides with slice table");
        Assert.always(this.heapEnd.loeq(bitmap.sub(40)), "heap collides with marking stack");
        Assert.always(this.heapSize % alignment == 0, "heap size is non-aligned");
        Assert.always(bitmapSize % 4 == 0, "bitmap size is non-aligned");
        Assert.always(this.sliceTableSize % 4 == 0, "slice table size is non-aligned");
        Assert.always(Lisp2Bitmap.getAddressOfBitmapWordFor(this.permanentMemoryStart).eq(Lisp2Bitmap.getStart()), "incorrect bitmap base");
        Assert.always(Lisp2Bitmap.getAddressOfBitmapWordFor(this.heapEnd).lo(Lisp2Bitmap.getEnd()), "incorrect bitmap base");
    }

    boolean processCommandLineOption(String arg) {
        if (arg.startsWith("-young:")) {
            int percent = Integer.parseInt(arg.substring("-young:".length()));
            if (percent < 10 || percent > 100) {
                System.err.println("Warning: ratio specified for young generation invalid");
            } else {
                this.idealYoungGenerationSizePercent = percent;
            }
            return true;
        }
        return super.processCommandLineOption(arg);
    }

    void usage(PrintStream out) {
        out.println("    -young:<n>            young space size as % of heap (default=20%)");
        super.usage(out);
    }

    long freeMemory(Address allocationPointer) {
        return this.heapEnd.diff(allocationPointer).toPrimitive();
    }

    long totalMemory() {
        return this.heapSize;
    }

    private int getYoungGenerationSize() {
        int size = this.getIdealYoungGenerationSize();
        int available = this.heapEnd.diff(this.youngGenerationStart).toInt();
        if (available < size) {
            return available;
        }
        return size;
    }

    static int asPercentOf(long part, long total) {
        if (part > 92233720368547758L) {
            total /= 100L;
            part /= 100L;
        }
        return total == 0L ? 0 : (int)(part * 100L / total);
    }

    private int getIdealYoungGenerationSize() {
        return GC.roundDown(this.heapSize / 100 * this.idealYoungGenerationSizePercent, 4);
    }

    private boolean isFullCollection() {
        return this.heapStart.eq(this.collectionStart);
    }

    void dumpTimings(PrintStream out) {
        this.fullCollectionTimer.dump(out, true, GC.getFullCollectionCount());
        this.partialCollectionTimer.dump(out, false, GC.getPartialCollectionCount());
    }

    boolean collectGarbageInJava(Address allocTop, boolean forceFullGC) {
        if (this.nextCollectionIsFull || forceFullGC) {
            this.collectionStart = this.heapStart;
            this.nextCollectionIsFull = false;
        } else {
            this.collectionStart = this.youngGenerationStart;
        }
        this.collectionEnd = allocTop;
        this.timer = this.isFullCollection() ? this.fullCollectionTimer : this.partialCollectionTimer;
        long start = this.timer.reset();
        this.markingStack.setup(this.collectionEnd, Lisp2Bitmap.getStart());
        this.markingRecursionLevel = 4;
        this.findUnusedStackChunks();
        Lisp2Bitmap.clearBitsFor(this.collectionStart, this.collectionEnd.add(4));
        this.timer.finish(0);
        this.mark();
        this.computeAddresses();
        if (!this.firstMovingBlock.isZero()) {
            this.updatePointers();
            this.youngGenerationStart = this.compactObjects(this.firstDeadBlock, this.firstMovingBlock);
            if (this.movedOopMaps != 0) {
                this.fixupOopMaps(this.heapStart, this.youngGenerationStart, this.movedOopMaps);
                this.movedOopMaps = 0;
            }
        } else {
            this.youngGenerationStart = this.lastDeadBlock;
        }
        this.timer.reset();
        Lisp2Bitmap.clearBitsFor(this.permanentMemoryStart, this.youngGenerationStart);
        VM.deadbeef(this.youngGenerationStart, this.collectionEnd);
        int youngGenerationSize = this.getYoungGenerationSize();
        allocTop = this.youngGenerationStart.add(youngGenerationSize);
        GC.setAllocationParameters(this.heapStart, this.youngGenerationStart, allocTop, this.heapEnd);
        this.nextCollectionIsFull = youngGenerationSize < this.getIdealYoungGenerationSize();
        this.timer.updateMaxMin(this.timer.finish(7) - start);
        return this.isFullCollection();
    }

    private void fixupOopMaps(Address start, Address end, int movedOopMaps) {
        this.timer.reset();
        Address block = start;
        while (block.lo(end) && movedOopMaps != 0) {
            Klass klass;
            Address object = GC.blockToOop(block);
            if (GC.getKlass(object).getSystemID() == 4 && !(klass = VM.asKlass(object.toObject())).isInterface() && !klass.isArray() && !klass.isSynthetic() && klass.getInstanceSize() > 32 && NativeUnsafe.getUWord(klass, 10).ne(UWord.zero())) {
                NativeUnsafe.setUWord(klass, 10, UWord.zero());
                --movedOopMaps;
            }
            block = object.add(GC.getBodySize(GC.getKlass(object), object));
        }
        this.timer.finish(5);
    }

    void postCollection() {
        this.timer.reset();
        this.postProcessWeakReferences();
        this.timer.finish(6);
    }

    private void postProcessWeakReferences() {
        Ref ref = this.references;
        this.references = null;
        while (ref != null) {
            Ref next = ref.next;
            if (!ref.referent.isZero()) {
                this.addWeakReference(ref);
            }
            ref = next;
        }
    }

    private boolean findStackChunk(Object haystack, Object needle) {
        while (haystack != null) {
            GC.checkSC(haystack);
            if (haystack == needle) {
                return true;
            }
            haystack = NativeUnsafe.getObject(haystack, 0);
        }
        return false;
    }

    private void registerStackChunk(Object chunk) {
        Assert.always(NativeUnsafe.getObject(chunk, 1) != null);
        Assert.always(NativeUnsafe.getAddress(chunk, 0).isZero());
        GC.checkSC(chunk);
        NativeUnsafe.setObject(chunk, 0, this.stackChunks);
        this.stackChunks = Address.fromObject(chunk);
    }

    void registerStackChunks(Object sc) {
        this.verifyStackChunks();
        while (sc != null) {
            Object next = NativeUnsafe.getObject(sc, 0);
            NativeUnsafe.setObject(sc, 0, null);
            this.registerStackChunk(sc);
            sc = next;
        }
        this.verifyStackChunks();
    }

    void deregisterStackChunk(Object chunk) {
        this.verifyStackChunks();
        GC.checkSC(chunk);
        if (chunk == this.stackChunks) {
            this.stackChunks = NativeUnsafe.getObject(chunk, 0);
        } else {
            Object prev = this.stackChunks;
            while (NativeUnsafe.getObject(prev, 0) != chunk) {
                GC.checkSC(prev);
                prev = NativeUnsafe.getObject(prev, 0);
            }
            NativeUnsafe.setObject(prev, 0, NativeUnsafe.getObject(chunk, 0));
        }
        NativeUnsafe.setObject(chunk, 0, null);
        NativeUnsafe.setAddress(chunk, 1, null);
        NativeUnsafe.setAddress(chunk, 2, Address.zero());
        this.verifyStackChunks();
    }

    private Address visitOop(int visitor, Address base, int offset) {
        switch (visitor) {
            case 0: {
                Address object = NativeUnsafe.getAddress(base, offset);
                if (!object.isZero()) {
                    this.markObject(object);
                }
                return object;
            }
            case 1: {
                return this.updateOop(base, offset);
            }
        }
        Assert.shouldNotReachHere("[Lisp2GenerationalCollector.java:1170] illegal oop traversal phase");
        return Address.max();
    }

    private void visitInternalPointer(int visitor, Address base, int offset, Address object) {
        switch (visitor) {
            case 0: {
                break;
            }
            case 1: {
                if (Lisp2GenerationalCollector.isForwarded(object)) {
                    Address destination = this.getForwardedObject(object);
                    Offset delta = object.diff(destination);
                    Address ipointer = NativeUnsafe.getAddress(base, offset);
                    ipointer = ipointer.subOffset(delta);
                    NativeUnsafe.setAddress(base, offset, ipointer);
                }
                if (!this.copyingObjectGraph) break;
                Address pointerAddress = base.add(offset * 4);
                this.recordPointer(pointerAddress);
                break;
            }
            default: {
                Assert.shouldNotReachHere("[Lisp2GenerationalCollector.java:1257] illegal oop traversal phase");
            }
        }
    }

    private void indentTrace() {
        int level = 4 - this.markingRecursionLevel;
        for (int i = 0; i != level; ++i) {
            VM.print("  ");
        }
    }

    private void traverseOopsInObject(Address object, Address klass, int visitor) {
        if (visitor == 0) {
            this.visitOop(visitor, object, -1);
        } else if (Lisp2GenerationalCollector.isForwarded(object)) {
            this.updateClassPointerIfClassIsForwarded(object);
        } else {
            this.updateOAPointerIfOAIsForwarded(object);
        }
        if (Klass.isSquawkArray(VM.asKlass(klass))) {
            this.traverseOopsInArrayObject(object, klass, visitor);
        } else {
            this.traverseOopsInNonArrayObject(object, klass, visitor);
        }
    }

    private void traverseOopsInArrayObject(Address object, Address klass, int visitor) {
        switch (Klass.getSystemID(VM.asKlass(klass))) {
            case 2: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: 
            case 37: {
                break;
            }
            case 33: {
                this.visitOop(visitor, object, -3);
                break;
            }
            case 30: {
                Klass gaklass = VM.asKlass(NativeUnsafe.getObject(object, 0));
                if (gaklass == null) break;
                if (visitor == 0) {
                    CS.check(object.toObject());
                }
                int end = 2 + Klass.getRefStaticFieldsSize(gaklass);
                for (int i = 0; i < end; ++i) {
                    this.visitOop(visitor, object, i);
                }
                break;
            }
            case 29: {
                this.traverseOopsInStackChunk(object, visitor, true);
                if (visitor != 1 || this.copyingObjectGraph || !Lisp2GenerationalCollector.isForwarded(object)) break;
                this.updateInternalStackChunkPointers(object, this.getForwardedObject(object));
                break;
            }
            default: {
                int length = GC.getArrayLengthNoCheck(object);
                for (int i = 0; i < length; ++i) {
                    this.visitOop(visitor, object, i);
                }
            }
        }
    }

    private void traverseOopsInNonArrayObject(Address object, Address klass, int visitor) {
        Address oopMap;
        if (this.copyingObjectGraph && Klass.isSubtypeOf(VM.asKlass(klass), this.HashTableKlass)) {
            NativeUnsafe.setAddress(object, 0, Address.zero());
        }
        if (visitor == 1 && !this.copyingObjectGraph && Klass.getSystemID(VM.asKlass(klass)) == 4 && !(oopMap = NativeUnsafe.getAddress(object, 9)).isZero() && Lisp2GenerationalCollector.isForwarded(oopMap)) {
            NativeUnsafe.setUWord(object, 10, oopMap.toUWord());
            ++this.movedOopMaps;
        }
        int instanceSize = Klass.getInstanceSize(VM.asKlass(klass));
        UWord oopMapWord = NativeUnsafe.getUWord(klass, 10);
        if (instanceSize > 32) {
            oopMap = visitor == 1 && !oopMapWord.isZero() ? Address.fromPrimitive(oopMapWord.toPrimitive()) : NativeUnsafe.getAddress(klass, 9);
            int oopMapLength = (instanceSize + 32 - 1) / 32;
            for (int i = 0; i != oopMapLength; ++i) {
                int word = NativeUnsafe.getUWord(oopMap, i).toPrimitive();
                this.traverseOopsForBitmapWord(object, visitor, word, i * 32);
            }
        } else {
            int word = oopMapWord.toPrimitive();
            this.traverseOopsForBitmapWord(object, visitor, word, 0);
        }
    }

    private void updateClassPointerIfClassIsForwarded(Address object) {
        Address classOrAssociation = this.getClassOrAssociationFromForwardedObject(object);
        if (Lisp2GenerationalCollector.isClassPointer(object, classOrAssociation) && Lisp2GenerationalCollector.isForwarded(classOrAssociation)) {
            Address destination = this.getForwardedObject(object);
            NativeUnsafe.setAddress(object, -1, this.getForwardedObject(classOrAssociation));
            this.forwardObject(object, destination);
        }
    }

    private void updateOAPointerIfOAIsForwarded(Address object) {
        Address classOrAssociation = NativeUnsafe.getAddress(object, -1);
        if (!Lisp2GenerationalCollector.isClassPointer(object, classOrAssociation)) {
            this.updateOop(object, -1);
        }
    }

    private void traverseOopsForBitmapWord(Address object, int visitor, int word, int offset) {
        while (word != 0) {
            if ((word & 1) != 0) {
                this.visitOop(visitor, object, offset);
            }
            ++offset;
            word >>>= 1;
        }
    }

    private void traverseOopsInStackChunk(Address chunk, int visitor, boolean header) {
        GC.checkSC(chunk.toObject());
        Address fp = NativeUnsafe.getAddress(chunk, 2);
        if (header) {
            if (visitor != 0) {
                if (this.copyingObjectGraph) {
                    Assert.always(visitor != 1 || this.findStackChunk(this.copiedStackChunks, chunk.toObject()));
                }
                this.visitOop(visitor, chunk, 0);
            }
            this.visitOop(visitor, chunk, 1);
        }
        boolean isInnerMostActivation = true;
        while (!fp.isZero()) {
            this.traverseOopsInActivation(fp, isInnerMostActivation, visitor);
            fp = VM.getPreviousFP(fp);
            isInnerMostActivation = false;
        }
    }

    private void traverseOopsInActivation(Address fp, boolean isInnerMostActivation, int visitor) {
        int bite;
        boolean isOop;
        Address mp = NativeUnsafe.getAddress(fp, 0);
        Address returnFP = VM.getPreviousFP(fp);
        Address returnIP = VM.getPreviousIP(fp);
        if (!returnIP.isZero()) {
            Address returnMP = NativeUnsafe.getAddress(returnFP, 0);
            this.visitInternalPointer(visitor, fp, 2, returnMP);
        }
        int localCount = isInnerMostActivation ? 1 : MethodBody.decodeLocalCount(mp.toObject());
        int parameterCount = MethodBody.decodeParameterCount(mp.toObject());
        int mapOffset = MethodBody.decodeOopmapOffset(mp.toObject());
        int bitOffset = -1;
        int byteOffset = 0;
        int varOffset = 3;
        while (parameterCount-- > 0) {
            if (++bitOffset == 8) {
                bitOffset = 0;
                ++byteOffset;
            }
            boolean bl = isOop = ((bite = NativeUnsafe.getByte(mp, mapOffset + byteOffset)) >>> bitOffset & 1) != 0;
            if (isOop) {
                this.visitOop(visitor, fp, varOffset);
            }
            ++varOffset;
        }
        varOffset = 0;
        while (localCount-- > 0) {
            if (++bitOffset == 8) {
                bitOffset = 0;
                ++byteOffset;
            }
            boolean bl = isOop = ((bite = NativeUnsafe.getByte(mp, mapOffset + byteOffset)) >>> bitOffset & 1) != 0;
            if (isOop) {
                this.visitOop(visitor, fp, varOffset);
            }
            --varOffset;
        }
    }

    private void traverseWriteBarrierOops(Address start, Address end, int visitor) {
        Address objectAddress;
        Lisp2Bitmap.Iterator.start(start, end, false);
        while (!(objectAddress = Lisp2Bitmap.Iterator.getNext()).isZero()) {
            this.visitOop(visitor, objectAddress, 0);
        }
    }

    private void mark() {
        this.timer.reset();
        this.markRoots();
        if (!this.isFullCollection()) {
            this.markWriteBarrierRoots();
            this.markStackChunks();
        }
        this.markCollectionSpace();
        if (this.references != null) {
            this.processWeakReferences();
            this.markObject(Address.fromObject(this.references));
            this.markCollectionSpace();
        }
        if (this.isFullCollection()) {
            this.pruneStackChunks();
        }
        this.timer.finish(1);
    }

    private void markCollectionSpace() {
        while (this.markingStack.hasOverflowed()) {
            Address object;
            this.markingStack.resetOverflow();
            Lisp2Bitmap.Iterator.start(this.collectionStart, this.collectionEnd, true);
            while (!(object = Lisp2Bitmap.Iterator.getNext()).isZero()) {
                this.traverseOopsInObject(object, Address.fromObject(GC.getKlass(object)), 0);
                while (!(object = this.markingStack.pop()).isZero()) {
                    this.traverseOopsInObject(object, Address.fromObject(GC.getKlass(object)), 0);
                }
            }
        }
    }

    private void markRoots() {
        for (int i = 0; i < VM.getGlobalOopCount(); ++i) {
            Address object = Address.fromObject(VM.getGlobalOop(i));
            if (object.isZero()) continue;
            this.markObject(object);
        }
    }

    private void markWriteBarrierRoots() {
        this.traverseWriteBarrierOops(this.heapStart, this.collectionStart, 0);
    }

    private void markStackChunks() {
        Address chunk = Address.fromObject(this.stackChunks);
        Assert.always(!this.copyingObjectGraph);
        while (!chunk.isZero()) {
            GC.checkSC(chunk);
            if (!this.inCollectionSpace(chunk) || !Lisp2Bitmap.testBitFor(chunk)) {
                this.traverseOopsInStackChunk(chunk, 0, true);
            }
            chunk = NativeUnsafe.getAddress(chunk, 0);
        }
    }

    private void verifyStackChunks() throws AllowInlinedPragma {
    }

    private void findUnusedStackChunks() {
        boolean keptCount = false;
        boolean prunedCount = false;
        this.verifyStackChunks();
        Address sc = Address.fromObject(this.stackChunks);
        this.stackChunks = null;
        Address kept = Address.zero();
        while (!sc.isZero()) {
            GC.checkSC(sc);
            Address next = NativeUnsafe.getAddress(sc, 0);
            if (NativeUnsafe.getObject(sc, 1) != null) {
                if (kept.isZero()) {
                    kept = sc;
                    NativeUnsafe.setAddress(sc, 0, Address.zero());
                } else {
                    NativeUnsafe.setAddress(sc, 0, kept);
                    Lisp2Bitmap.setBitFor(sc.add(0));
                    kept = sc;
                }
            } else {
                NativeUnsafe.setAddress(sc, 1, Address.zero());
                NativeUnsafe.setAddress(sc, 0, Address.zero());
                NativeUnsafe.setAddress(sc, 2, Address.zero());
            }
            sc = next;
        }
        this.stackChunks = kept;
        this.verifyStackChunks();
    }

    private void pruneStackChunks() {
        Assert.always(this.isFullCollection());
        boolean keptCount = false;
        boolean prunedCount = false;
        this.verifyStackChunks();
        Address sc = Address.fromObject(this.stackChunks);
        this.stackChunks = null;
        Address kept = Address.zero();
        while (!sc.isZero()) {
            GC.checkSC(sc);
            Address next = NativeUnsafe.getAddress(sc, 0);
            if (Lisp2Bitmap.testBitFor(sc)) {
                if (kept.isZero()) {
                    kept = sc;
                    NativeUnsafe.setAddress(sc, 0, Address.zero());
                } else {
                    NativeUnsafe.setAddress(sc, 0, kept);
                    kept = sc;
                }
            } else {
                NativeUnsafe.setAddress(sc, 1, Address.zero());
                NativeUnsafe.setAddress(sc, 0, Address.zero());
                NativeUnsafe.setAddress(sc, 2, Address.zero());
            }
            sc = next;
        }
        this.stackChunks = kept;
        this.verifyStackChunks();
    }

    private void processWeakReferences() {
        Ref ref = this.references;
        while (ref != null) {
            boolean keep = false;
            Address referent = ref.referent;
            Address refAddress = Address.fromObject(ref);
            if (!(this.inCollectionSpace(refAddress) && !Lisp2Bitmap.testBitFor(refAddress) || this.inCollectionSpace(referent) && !Lisp2Bitmap.testBitFor(referent))) {
                keep = true;
            }
            if (!keep) {
                ref.referent = Address.zero();
            }
            ref = ref.next;
        }
    }

    private void markObject(Address object) {
        if (this.inCollectionSpace(object) && !Lisp2Bitmap.testAndSetBitFor(object)) {
            if (this.markingRecursionLevel == 0) {
                this.markingStack.push(object);
            } else {
                Klass klass = GC.getKlass(object);
                --this.markingRecursionLevel;
                this.traverseOopsInObject(object, Address.fromObject(klass), 0);
                while (!(object = this.markingStack.pop()).isZero()) {
                    klass = GC.getKlass(object);
                    this.traverseOopsInObject(object, Address.fromObject(klass), 0);
                }
                ++this.markingRecursionLevel;
            }
        }
    }

    private Address computeAddresses() {
        Address object;
        this.timer.reset();
        Address free = !this.copyingObjectGraph ? this.collectionStart : this.copiedObjects;
        Address returnValue = Address.zero();
        this.firstDeadBlock = Address.zero();
        this.lastDeadBlock = Address.zero();
        this.firstMovingBlock = Address.zero();
        for (int i = 0; i != this.sliceCount; ++i) {
            NativeUnsafe.setAddress(this.sliceTable, i, Address.zero());
        }
        Lisp2Bitmap.Iterator.start(this.collectionStart, this.collectionEnd, true);
        while (!(object = Lisp2Bitmap.Iterator.getNext()).isZero()) {
            Klass klass = GC.getKlass(object);
            int headerSize = object.diff(GC.oopToBlock(klass, object)).toInt();
            Address objectDestination = free.add(headerSize);
            Offset delta = object.diff(objectDestination);
            int size = GC.getBodySize(klass, object);
            if (!delta.isZero()) {
                if (this.copyingObjectGraph) {
                    Address block = object.sub(headerSize);
                    Address destinationBlock = objectDestination.sub(headerSize);
                    if (Klass.getSystemID(klass) != 29) {
                        int blockSize = headerSize + size;
                        Address destinationBlockEnd = destinationBlock.add(blockSize);
                        if (destinationBlockEnd.hi(this.heapEnd)) {
                            Lisp2Bitmap.Iterator.terminate();
                            this.timer.finish(2);
                            return Address.zero();
                        }
                        returnValue = destinationBlockEnd;
                        VM.copyBytes(block, 0, destinationBlock, 0, blockSize, false);
                    } else if ((size = this.copyStackChunk(object, size, objectDestination)) == -1) {
                        Lisp2Bitmap.Iterator.terminate();
                        this.timer.finish(2);
                        return Address.zero();
                    }
                }
                this.forwardObject(object, objectDestination);
                if (VM.isVerbose() && Klass.getSystemID(klass) == 33) {
                    int old = VM.setStream(2);
                    if (!this.copyingObjectGraph) {
                        VM.print("METHOD.");
                        VM.printAddress(objectDestination);
                        VM.print(".MOVED_FROM=");
                        VM.printAddress(object);
                        VM.println();
                    } else {
                        VM.print("SAVED_METHOD.");
                        VM.printOffset(objectDestination.diff(this.collectionEnd.add(8)));
                        VM.print(".COPIED_FROM=");
                        VM.printAddress(object);
                        VM.println();
                    }
                    VM.setStream(old);
                }
                if (!this.copyingObjectGraph && this.firstDeadBlock.isZero()) {
                    this.firstDeadBlock = free;
                    this.firstMovingBlock = object.sub(headerSize);
                }
            }
            free = objectDestination.add(size);
        }
        if (!this.copyingObjectGraph) {
            if (this.firstDeadBlock.isZero()) {
                this.firstDeadBlock = free;
                this.firstMovingBlock = null;
            }
            this.lastDeadBlock = free;
            this.updateWeakReferences();
        }
        this.timer.finish(2);
        return returnValue;
    }

    private Address updateWeakReferent(Ref weakRef, Address referent) {
        if (!referent.isZero()) {
            Address newAddress = this.getPossiblyForwardedObject(referent);
            return newAddress;
        }
        return referent;
    }

    private void updateWeakReferences() {
        Ref ref = this.references;
        while (ref != null) {
            ref.referent = this.updateWeakReferent(ref, ref.referent);
            ref = ref.next;
        }
    }

    private Address calculateLastReservedSlot(Address chunk) {
        Address fp;
        GC.checkSC(chunk);
        Address lastReservedSlot = fp = NativeUnsafe.getAddress(chunk, 2);
        boolean isInnerMostActivation = true;
        while (!fp.isZero()) {
            Address returnFP;
            int stackCount;
            Object mp;
            int localCount = isInnerMostActivation ? 1 : MethodBody.decodeLocalCount(mp);
            int reserved = (localCount + (stackCount = MethodBody.decodeStackCount(mp = NativeUnsafe.getObject(fp, 0))) + 3) * 4;
            if (fp.sub(reserved).lo(lastReservedSlot)) {
                lastReservedSlot = fp.sub(reserved);
            }
            fp = returnFP = NativeUnsafe.getAddress(fp, 1);
            isInnerMostActivation = false;
        }
        return lastReservedSlot;
    }

    private int copyStackChunk(Address src, int size, Address dst) {
        Address dstFP;
        Address dstEnd;
        Address dstLRS;
        int usedSize;
        GC.checkSC(src);
        NativeUnsafe.setAddress(dst, -1, NativeUnsafe.getAddress(src, -1));
        Address srcEnd = src.add(size);
        Address srcLRS = this.calculateLastReservedSlot(src);
        int fixedSize = 20;
        Address srcFP = NativeUnsafe.getAddress(src, 2);
        if (srcLRS.isZero()) {
            usedSize = 0;
            dstLRS = Address.zero();
            dstEnd = dst.add(20);
            dstFP = Address.zero();
        } else {
            usedSize = srcEnd.diff(srcLRS).toInt();
            dstLRS = dst.add(20);
            dstEnd = dstLRS.add(usedSize);
            srcFP = NativeUnsafe.getAddress(src, 2);
            dstFP = dstLRS.addOffset(srcFP.diff(srcLRS));
        }
        size = dstEnd.diff(dst).toInt();
        if (dstEnd.hi(this.heapEnd)) {
            return -1;
        }
        VM.copyBytes(src, 0, dst, 0, 20, false);
        if (NativeUnsafe.getObject(src, 1) == null) {
            Assert.always(srcLRS.isZero());
            Assert.always(srcFP.isZero());
            Assert.always(dstFP.isZero());
        } else {
            if (this.copiedStackChunks != null) {
                GC.checkSC(this.copiedStackChunks);
            }
            NativeUnsafe.setAddress(dst, 0, this.copiedStackChunks);
            this.copiedStackChunks = dst;
        }
        if (!srcLRS.isZero()) {
            VM.copyBytes(srcLRS, 0, dstLRS, 0, usedSize, false);
        }
        GC.setHeaderLength(dst, size / 4);
        NativeUnsafe.setAddress(dst, 2, dstFP);
        this.recordPointer(dst.add(8));
        while (!srcFP.isZero()) {
            Address returnFP = NativeUnsafe.getAddress(srcFP, 1);
            Offset delta = returnFP.diff(srcFP);
            srcFP = returnFP;
            Address pointerAddress = dstFP.add(4);
            dstFP = srcFP.isZero() ? Address.zero() : dstFP.addOffset(delta);
            NativeUnsafe.setAddress(pointerAddress, 0, dstFP);
            this.recordPointer(pointerAddress);
        }
        GC.checkSC(dst);
        return size;
    }

    private boolean inHeap(Address object) {
        return object.hi(this.heapStart) && object.loeq(this.heapEnd);
    }

    private Offset getOffsetInHeap(Address object) {
        return object.diff(this.heapStart);
    }

    private Address getObjectInHeap(Offset offset) {
        return this.heapStart.addOffset(offset);
    }

    private void forwardObject(Address object, Address objectDestination) {
        Address classOrAssociation = NativeUnsafe.getAddress(object, -1);
        UWord encodedClassWord = this.encodeForwardingPointer(object, objectDestination).or(this.encodeClassOrAssociationPointer(classOrAssociation));
        NativeUnsafe.setAddress(object, -1, Address.zero().or(encodedClassWord));
    }

    private UWord encodeForwardingPointer(Address object, Address destination) {
        Offset offsetInSlice;
        int sliceIndex = this.getSliceIndexForObject(object);
        Address sliceDestination = NativeUnsafe.getAddress(this.sliceTable, sliceIndex);
        if (sliceDestination.isZero()) {
            sliceDestination = destination;
            offsetInSlice = Offset.zero();
            NativeUnsafe.setAddress(this.sliceTable, sliceIndex, sliceDestination);
        } else {
            offsetInSlice = destination.diff(sliceDestination);
        }
        offsetInSlice = offsetInSlice.bytesToWords();
        UWord encodedDestination = UWord.fromPrimitive(offsetInSlice.toPrimitive() << this.sliceOffsetShift);
        return encodedDestination;
    }

    private Address decodeForwardingPointer(Address object, UWord encodedDestination) {
        int sliceIndex = this.getSliceIndexForObject(object);
        Offset offsetInSlice = Offset.fromPrimitive(encodedDestination.toPrimitive() >>> this.sliceOffsetShift).wordsToBytes();
        Address sliceDestination = NativeUnsafe.getAddress(this.sliceTable, sliceIndex);
        return sliceDestination.addOffset(offsetInSlice);
    }

    private UWord encodeClassOrAssociationPointer(Address classOrAssociation) {
        int tag;
        Offset classOrAssociationOffset;
        if (this.inHeap(classOrAssociation)) {
            classOrAssociationOffset = this.getOffsetInHeap(classOrAssociation);
            tag = 1;
        } else if (VM.inRom(classOrAssociation)) {
            classOrAssociationOffset = VM.getOffsetInRom(classOrAssociation);
            tag = 3;
        } else {
            classOrAssociationOffset = GC.getOffsetInNvm(classOrAssociation);
            tag = 2;
        }
        classOrAssociationOffset = classOrAssociationOffset.bytesToWords();
        UWord encodedClassOrAssociation = UWord.fromPrimitive(classOrAssociationOffset.toPrimitive() << 2);
        encodedClassOrAssociation = encodedClassOrAssociation.or(UWord.fromPrimitive(tag));
        return encodedClassOrAssociation;
    }

    private Address decodeClassOrAssociationPointer(UWord encodedClassOrAssociation) {
        int tag = encodedClassOrAssociation.toPrimitive() & 3;
        Offset classOrAssociationOffset = Offset.fromPrimitive((encodedClassOrAssociation.toPrimitive() & this.classOffsetMask) >>> 2).wordsToBytes();
        switch (tag) {
            case 1: {
                return this.getObjectInHeap(classOrAssociationOffset);
            }
            case 3: {
                return VM.getObjectInRom(classOrAssociationOffset);
            }
            case 2: {
                return GC.getObjectInNvm(classOrAssociationOffset);
            }
        }
        Assert.shouldNotReachHere("[Lisp2GenerationalCollector.java:2721] ");
        return Address.zero();
    }

    private static boolean isForwarded(Address object) {
        return !ClassWordTag.isPointer(NativeUnsafe.getAddress(object, -1).toUWord());
    }

    private Address getForwardedObject(Address object) {
        UWord encodedDestination = NativeUnsafe.getAddress(object, -1).toUWord();
        return this.decodeForwardingPointer(object, encodedDestination);
    }

    private Address getPossiblyForwardedObject(Address object) {
        return !object.isZero() && Lisp2GenerationalCollector.isForwarded(object) ? this.getForwardedObject(object) : object;
    }

    private Address getClassOrAssociationFromForwardedObject(Address object) {
        UWord encodedClassOrAssociation = NativeUnsafe.getAddress(object, -1).toUWord();
        return this.decodeClassOrAssociationPointer(encodedClassOrAssociation);
    }

    private static boolean isClassPointer(Address object, Address classOrAssociation) {
        return !GC.inRam(classOrAssociation) || classOrAssociation.lo(object);
    }

    private Address getKlass(Address object) {
        Address classOrAssociation = Lisp2GenerationalCollector.isForwarded(object) ? this.getClassOrAssociationFromForwardedObject(object) : NativeUnsafe.getAddress(object, -1);
        Address klass = !Lisp2GenerationalCollector.isClassPointer(object, classOrAssociation) ? NativeUnsafe.getAddress(classOrAssociation, 0) : classOrAssociation;
        return klass;
    }

    private static void printKlassName(Object klass) {
        Address klassAddress = Address.fromObject(klass);
        if (Lisp2GenerationalCollector.isForwarded(klassAddress)) {
            VM.printAddress(klassAddress);
        } else {
            String name = Klass.getInternalName(VM.asKlass(klass));
            VM.print(name);
        }
    }

    private int getSliceIndexForObject(Address object) {
        Offset heapOffset = this.getOffsetInHeap(object).sub(4);
        int index = heapOffset.toPrimitive() / this.sliceSize;
        return index;
    }

    private void updatePointers() {
        this.timer.reset();
        if (!this.isFullCollection()) {
            this.updateOldGenerationStackChunkPointers();
            this.traverseWriteBarrierOops(this.heapStart, this.collectionStart, 1);
        }
        this.updateRoots();
        this.updateCollectionSpacePointers();
        this.traverseOopsInNonArrayObject(Address.fromObject(this), this.getKlass(Address.fromObject(this)), 1);
        this.timer.finish(3);
    }

    private void updateCollectionSpacePointers() {
        Address object;
        Lisp2Bitmap.Iterator.start(this.collectionStart, this.collectionEnd, true);
        while (!(object = Lisp2Bitmap.Iterator.getNext()).isZero()) {
            Address klass = this.getKlass(object);
            this.traverseOopsInObject(object, klass, 1);
        }
    }

    private void updateRoots() {
        for (int i = 0; i < VM.getGlobalOopCount(); ++i) {
            Address object = Address.fromObject(VM.getGlobalOop(i));
            if (object.isZero() || !Lisp2GenerationalCollector.isForwarded(object)) continue;
            Address destination = this.getForwardedObject(object);
            VM.setGlobalOop(destination.toObject(), i);
        }
    }

    private Address updateOop(Address base, int offset) {
        Address destination;
        Address object = NativeUnsafe.getAddress(base, offset);
        if (object.ne(destination = this.getPossiblyForwardedObject(object))) {
            NativeUnsafe.setAddress(base, offset, destination);
        }
        if (this.copyingObjectGraph) {
            Address pointerAddress = base.add(offset * 4);
            this.recordPointer(pointerAddress);
        }
        return object;
    }

    private void updateOldGenerationStackChunkPointers() {
        Address chunk = Address.fromObject(this.stackChunks);
        while (!chunk.isZero()) {
            GC.checkSC(chunk);
            Address nextChunk = NativeUnsafe.getAddress(chunk, 0);
            if (!this.inCollectionSpace(chunk)) {
                this.traverseOopsInStackChunk(chunk, 1, false);
            }
            chunk = nextChunk;
        }
    }

    private void updateInternalStackChunkPointers(Address chunk, Address destination) {
        Offset offset = Offset.fromPrimitive(2).wordsToBytes();
        Address oldFP = NativeUnsafe.getAddress(chunk.addOffset(offset), 0);
        while (!oldFP.isZero()) {
            Address pointerAddress = chunk.addOffset(offset);
            Offset delta = oldFP.diff(chunk);
            Address newFP = destination.addOffset(delta);
            NativeUnsafe.setAddress(pointerAddress, 0, newFP);
            offset = delta.add(4);
            oldFP = NativeUnsafe.getAddress(chunk.addOffset(offset), 0);
        }
    }

    private void markObjectGraph(Address object) {
        this.timer.reset();
        this.markObject(object);
        while (this.markingStack.hasOverflowed()) {
            this.markingStack.resetOverflow();
            Lisp2Bitmap.Iterator.start(this.collectionStart, this.collectionEnd, true);
            while (!(object = Lisp2Bitmap.Iterator.getNext()).isZero()) {
                this.traverseOopsInObject(object, Address.fromObject(GC.getKlass(object)), 0);
                while (!(object = this.markingStack.pop()).isZero()) {
                    this.traverseOopsInObject(object, Address.fromObject(GC.getKlass(object)), 0);
                }
            }
        }
        this.timer.finish(1);
    }

    Address copyObjectGraphInJava(Address object, ObjectMemorySerializer.ControlBlock cb, Address allocTop) {
        if (this.HashTableKlass == null) {
            Isolate isolate = VM.getCurrentIsolate();
            Suite bootstrapSuite = isolate.getBootstrapSuite();
            this.HashTableKlass = bootstrapSuite.lookup("com.sun.squawk.util.SquawkHashtable");
            this.ByteArrayKlass = bootstrapSuite.getKlass(19);
            this.IsolateKlass = GC.getKlass(isolate);
        }
        this.timer = this.copyTimer;
        this.timer.reset();
        this.copiedStackChunks = null;
        this.copyingObjectGraph = true;
        this.oopMap = cb.oopMap;
        if (GC.getKlass(object) == this.IsolateKlass) {
            this.theIsolate = (Isolate)object.toObject();
        }
        this.collectionStart = this.heapStart;
        this.collectionEnd = allocTop;
        this.markingStack.setup(this.heapEnd, Lisp2Bitmap.getStart());
        this.markingRecursionLevel = 4;
        this.verifyStackChunks();
        Lisp2Bitmap.clearBitsFor(this.collectionStart, this.collectionEnd.add(4));
        this.timer.finish(0);
        this.markObjectGraph(object);
        this.copiedObjects = this.collectionEnd.add(8);
        Address copiedObjectsEnd = this.computeAddresses();
        if (!copiedObjectsEnd.isZero()) {
            this.updatePointersInObjectMemory(this.copiedObjects, copiedObjectsEnd);
            object = this.getForwardedObject(object);
            this.unforwardCopiedObjects(this.collectionStart, this.collectionEnd);
            if (this.theIsolate != null) {
                Assert.always(GC.getKlass(object) == this.IsolateKlass);
                Assert.always(this.copiedStackChunks != null);
                NativeUnsafe.setAddress(object, 24, this.copiedStackChunks);
                this.recordPointer(object.add(96));
            }
            this.timer.reset();
            int graphSize = copiedObjectsEnd.diff(this.copiedObjects).toInt();
            GC.setHeaderClass(this.copiedObjects, this.ByteArrayKlass);
            GC.setHeaderLength(this.copiedObjects, graphSize);
            cb.root = object.diff(this.copiedObjects).toInt();
            cb.start = this.copiedObjects;
            this.youngGenerationStart = allocTop = copiedObjectsEnd;
            int youngGenerationSize = this.getYoungGenerationSize();
            Address youngGenerationEnd = this.youngGenerationStart.add(youngGenerationSize);
            GC.setAllocationParameters(this.heapStart, this.youngGenerationStart, youngGenerationEnd, this.heapEnd);
        } else {
            this.unforwardCopiedObjects(this.collectionStart, this.collectionEnd);
            this.timer.reset();
            this.copiedObjects = Address.zero();
        }
        this.nextCollectionIsFull = true;
        this.copyingObjectGraph = false;
        this.copiedStackChunks = null;
        this.oopMap = null;
        this.theIsolate = null;
        this.timer.finish(7);
        return this.copiedObjects;
    }

    private void unforwardCopiedObjects(Address start, Address end) {
        Address object;
        this.timer.reset();
        Lisp2Bitmap.Iterator.start(start, end, true);
        while (!(object = Lisp2Bitmap.Iterator.getNext()).isZero()) {
            if (!Lisp2GenerationalCollector.isForwarded(object)) {
                Lisp2Bitmap.Iterator.terminate();
                break;
            }
            Address classOrAssociation = this.getClassOrAssociationFromForwardedObject(object);
            NativeUnsafe.setAddress(object, -1, classOrAssociation);
        }
        this.timer.finish(3);
    }

    private void updatePointersInObjectMemory(Address start, Address end) {
        this.timer.reset();
        Address block = start;
        while (block.lo(end)) {
            Address object = GC.blockToOop(block);
            Klass klass = GC.getKlass(object);
            Address klassAddress = Address.fromObject(klass);
            this.visitOop(1, object, -1);
            if (Klass.isSquawkArray(klass)) {
                this.traverseOopsInArrayObject(object, klassAddress, 1);
            } else {
                this.traverseOopsInNonArrayObject(object, klassAddress, 1);
            }
            block = object.add(GC.getBodySize(klass, object));
        }
        this.timer.finish(3);
    }

    private void recordPointer(Address pointerAddress) {
        if (this.inHeap(pointerAddress)) {
            int word = pointerAddress.diff(this.copiedObjects).toInt() / 4;
            this.oopMap.set(word);
        }
    }

    private Address compactObjects(Address firstDeadBlock, Address firstMovingBlock) {
        Address object;
        this.timer.reset();
        Address free = firstDeadBlock;
        Lisp2Bitmap.Iterator.start(firstMovingBlock, this.collectionEnd, true);
        while (!(object = Lisp2Bitmap.Iterator.getNext()).isZero()) {
            Klass klass;
            Address objectDestination = this.getForwardedObject(object);
            Address classOrAssociation = this.getClassOrAssociationFromForwardedObject(object);
            if (Lisp2GenerationalCollector.isClassPointer(object, classOrAssociation)) {
                klass = VM.asKlass(classOrAssociation);
            } else {
                klass = VM.asKlass(NativeUnsafe.getObject(classOrAssociation, 0));
                classOrAssociation = this.getForwardedObject(classOrAssociation);
            }
            NativeUnsafe.setAddress(object, -1, classOrAssociation);
            int headerSize = object.diff(GC.oopToBlock(klass, object)).toInt();
            int size = GC.getBodySize(klass, object);
            Address block = object.sub(headerSize);
            Address destinationBlock = objectDestination.sub(headerSize);
            int blockSize = headerSize + size;
            VM.copyBytes(block, 0, destinationBlock, 0, blockSize, false);
            free = destinationBlock.add(blockSize);
        }
        this.timer.finish(4);
        return free;
    }

    private boolean inCollectionSpace(Address object) {
        return object.hi(this.collectionStart) && object.loeq(this.collectionEnd);
    }

    private boolean tracing() {
        return false;
    }

    private void traceVariables() {
        VM.println("Lisp2GenerationalCollector variables");
        this.traceVariable("permanentMemoryStart", this.permanentMemoryStart);
        this.traceVariable("memoryStart", this.memoryStart);
        this.traceVariable("memoryEnd", this.memoryEnd);
        this.traceVariable("memorySize", this.memoryEnd.diff(this.memoryStart).toInt());
        this.traceVariable("bitmap", Lisp2Bitmap.getStart());
        this.traceVariable("bitmapEnd", Lisp2Bitmap.getEnd());
        this.traceVariable("bitmapSize", Lisp2Bitmap.getSize());
        this.traceVariable("bitmapBase", Lisp2Bitmap.getBase());
        this.traceVariable("sliceTable", this.sliceTable);
        this.traceVariable("sliceTableEnd", this.sliceTable.add(this.sliceTableSize));
        this.traceVariable("sliceTableSize", this.sliceTableSize);
        this.traceVariable("sliceOffsetShift", this.sliceOffsetShift);
        this.traceVariable("sliceOffsetBits", this.sliceOffsetBits);
        this.traceVariable("sliceSize", this.sliceSize);
        this.traceVariable("sliceCount", this.sliceCount);
        this.markingStack.traceVariables(this);
        this.traceVariable("heapStart", this.heapStart);
        this.traceVariable("heapEnd", this.heapEnd);
        this.traceVariable("heapSize", this.heapSize);
        int youngGenerationSize = this.getYoungGenerationSize();
        this.traceVariable("youngGenerationStart", this.youngGenerationStart);
        this.traceVariable("youngGenerationEnd", this.youngGenerationStart.add(youngGenerationSize));
        this.traceVariable("youngGenerationSize", youngGenerationSize);
        this.traceVariable("collectionStart", this.collectionStart);
        this.traceVariable("collectionEnd", this.collectionEnd);
        this.traceVariable("collectionSize", this.collectionEnd.diff(this.collectionStart).toInt());
        this.traceVariable("bitmappedStart", Lisp2Bitmap.getAddressForBitmapWord(Lisp2Bitmap.getStart()));
        this.traceVariable("bitmappedEnd", Lisp2Bitmap.getAddressForBitmapWord(Lisp2Bitmap.getEnd()));
        int overhead = 100 - Lisp2GenerationalCollector.asPercentOf(this.heapSize, this.memoryEnd.diff(this.memoryStart).toInt());
        this.traceVariable("overhead(%)", overhead);
    }

    void traceHeap(String description, Address allocationPointer) {
        this.traceHeapStart(description, this.freeMemory(allocationPointer), this.totalMemory());
        int youngGenerationSize = this.getYoungGenerationSize();
        Address youngGenerationEnd = this.youngGenerationStart.add(youngGenerationSize);
        this.traceHeapSegment("sliceTable", this.sliceTable, this.sliceTable.add(this.sliceTableSize));
        this.traceHeapSegment("bitmap", Lisp2Bitmap.getStart(), Lisp2Bitmap.getEnd());
        this.traceHeapSegment("minimumMarkingStack", this.heapEnd, Lisp2Bitmap.getStart());
        this.traceHeapSegment("heap{unused}", youngGenerationEnd, this.heapEnd);
        this.traceHeapSegment("heap{youngGenerationFree}", allocationPointer, youngGenerationEnd);
        this.traceHeapSegment("heap{youngGenerationAllocated}", this.youngGenerationStart, allocationPointer);
        this.traceHeapSegment("heap{oldGeneration}", this.heapStart, this.youngGenerationStart);
        this.traceHeapSegment("permanentSpace", this.memoryStart, this.heapStart);
        if (GC.isTracing(64)) {
            int size;
            Klass klass;
            Address object;
            Address block = this.permanentMemoryStart;
            while (block.lo(this.memoryStart)) {
                object = GC.blockToOop(block);
                klass = GC.getKlass(object);
                size = GC.getBodySize(klass, object);
                this.traceHeapObject(block, object, klass, size / 4);
                block = object.add(size);
            }
            block = this.heapStart;
            while (block.lo(allocationPointer)) {
                object = GC.blockToOop(block);
                klass = GC.getKlass(object);
                size = GC.getBodySize(klass, object);
                this.traceHeapObject(block, object, klass, size / 4);
                block = object.add(size);
            }
        }
        this.traceHeapEnd();
    }

    static final class MarkingStack {
        static final int MINIMUM_MARKING_STACK_SIZE = 10;
        private static final boolean TESTMARKSTACKOVERFLOW = false;
        private Address base;
        private int size;
        private int index;
        private boolean overflowed;

        MarkingStack() {
        }

        void setup(Address base, Address end) {
            this.base = base;
            this.size = end.diff(base).toInt() >> 2;
            this.index = 0;
            this.overflowed = false;
        }

        void push(Address object) {
            if (this.index == this.size) {
                this.overflowed = true;
            } else {
                NativeUnsafe.setAddress(this.base, this.index, object);
                ++this.index;
            }
        }

        Address pop() {
            if (this.index == 0) {
                return Address.zero();
            }
            --this.index;
            return NativeUnsafe.getAddress(this.base, this.index);
        }

        boolean hasOverflowed() throws AllowInlinedPragma {
            return this.overflowed;
        }

        void resetOverflow() throws AllowInlinedPragma {
            this.overflowed = false;
        }

        void traceVariables(GarbageCollector parent) {
            parent.traceVariable("markingStack.size", this.size);
            parent.traceVariable("markingStack.base", this.base);
            parent.traceVariable("markingStack.index", this.index);
            parent.traceVariable("markingStack.overflowed", this.overflowed ? 1 : 0);
        }
    }

    static final class Timer {
        public static final int SETUP = 0;
        public static final int MARK = 1;
        public static final int COMPUTE_ADDRESSES = 2;
        public static final int UPDATE_POINTERS = 3;
        public static final int COMPACT_OBJECTS = 4;
        public static final int FIXUP_OOPMAPS = 5;
        public static final int POST = 6;
        public static final int FINALIZE = 7;
        public static final int UNFORWARD = 8;
        final long[] times = new long[9];
        long max = 0L;
        long min = Long.MAX_VALUE;
        final String[] labels = new String[this.times.length];
        private long start;
        private final GarbageCollector gc;

        Timer(GarbageCollector gc) {
            this.labels[0] = "setup:            ";
            this.labels[1] = "mark:             ";
            this.labels[2] = "computeAddresses: ";
            this.labels[3] = "updatePointers:   ";
            this.labels[4] = "compactObjects:   ";
            this.labels[5] = "fixupOopmaps:     ";
            this.labels[6] = "post:             ";
            this.labels[7] = "finalize:         ";
            this.labels[8] = "unforward:        ";
            this.gc = gc;
        }

        long reset() {
            this.start = this.gc.now();
            return this.start;
        }

        long finish(int phase) {
            long now = this.gc.now();
            int n = phase;
            this.times[n] = this.times[n] + (now - this.start);
            this.start = 0L;
            return now;
        }

        void updateMaxMin(long t) {
            if (this.min > t) {
                this.min = t;
            }
            if (this.max < t) {
                this.max = t;
            }
        }

        long getTotal() {
            long total = 0L;
            for (int i = 0; i != this.times.length; ++i) {
                total += this.times[i];
            }
            return total;
        }

        private void dump(PrintStream out, String label, long value, long total) {
            out.println(label + value + this.gc.timerUnitSuffix() + "\t[" + Lisp2GenerationalCollector.asPercentOf(value, total) + "%]");
        }

        private void dump(PrintStream out, String indent, boolean showZeroTimes) {
            long total = this.getTotal();
            out.println(indent + "total time:       " + total + this.gc.timerUnitSuffix());
            for (int i = 0; i != this.times.length; ++i) {
                if (!showZeroTimes && this.times[i] == 0L) continue;
                this.dump(out, indent + this.labels[i], this.times[i], total);
            }
        }

        void dump(PrintStream out, boolean isFull, int count) {
            long total = this.getTotal();
            if (count != 0) {
                String tus = this.gc.timerUnitSuffix();
                out.println((isFull ? "Full " : "Partial ") + "collections: [average = " + total / (long)count + tus + ", " + "min = " + this.min + tus + ", max = " + this.max + tus + "]");
                out.println("    collection count: " + count);
            }
        }
    }

    static final class ClassWordTag {
        static final int BIT_COUNT = 2;
        static final int MASK = 3;
        static final int POINTER = 0;
        static final int HEAP = 1;
        static final int NVM = 2;
        static final int ROM = 3;

        private ClassWordTag() {
            Assert.shouldNotReachHere("[Lisp2GenerationalCollector.java:111] ");
        }

        static boolean isPointer(UWord word) {
            return word.and(UWord.fromPrimitive(3)).eq(UWord.fromPrimitive(0));
        }

        static boolean isHeapOffset(UWord word) {
            return word.and(UWord.fromPrimitive(3)).eq(UWord.fromPrimitive(1));
        }

        static boolean isNVMOffset(UWord word) {
            return word.and(UWord.fromPrimitive(3)).eq(UWord.fromPrimitive(2));
        }

        static boolean isROMOffset(UWord word) {
            return word.and(UWord.fromPrimitive(3)).eq(UWord.fromPrimitive(3));
        }
    }
}

