/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Klass;
import com.sun.squawk.KlassMetadata;
import com.sun.squawk.Member;
import com.sun.squawk.MethodMetadata;
import com.sun.squawk.Modifier;
import com.sun.squawk.ScopedLocalVariable;
import com.sun.squawk.SymbolParser;
import com.sun.squawk.pragma.PragmaException;

public final class Method
extends Member {
    Method(KlassMetadata metadata, int id) {
        super(metadata, id);
    }

    public int hashCode() {
        return this.metadata.hashCode() ^ this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Method) {
            Method otherMethod = (Method)other;
            if (this.metadata == otherMethod.metadata && this.id == otherMethod.id) {
                return true;
            }
        }
        return false;
    }

    private int getPragmas() {
        return this.parser().getPragmas();
    }

    public boolean isHosted() {
        return PragmaException.isHosted(this.getPragmas());
    }

    public boolean isReplacementConstructor() {
        return PragmaException.isReplacementConstructor(this.getPragmas());
    }

    public boolean isInterpreterInvoked() {
        return PragmaException.isInterpreterInvoked(this.getPragmas());
    }

    public boolean isForceInlined() {
        return PragmaException.isForceInlined(this.getPragmas());
    }

    public boolean isAllowInlined() {
        return PragmaException.isAllowInlined(this.getPragmas());
    }

    public boolean isNotInlined() {
        return PragmaException.isNotInlined(this.getPragmas());
    }

    public boolean isNativeDueToPragma() {
        return PragmaException.isNative(this.getPragmas());
    }

    public boolean isNative() {
        return Modifier.isNative(this.parser().getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.parser().getModifiers());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.parser().getModifiers());
    }

    public boolean isConstructor() {
        return Modifier.isConstructor(this.parser().getModifiers());
    }

    public boolean isDefaultConstructor() {
        return this.isConstructor() && this.getParameterCount() == 0;
    }

    public boolean isClassInitializer() {
        return this.getName().equals("<clinit>");
    }

    public Klass getReturnType() {
        return this.parser().getSignatureTypeAt(0);
    }

    public Klass[] getParameterTypes() {
        SymbolParser parser = this.parser();
        Klass[] parameterTypes = new Klass[parser.getSignatureCount() - 1];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = parser.getSignatureTypeAt(i + 1);
        }
        return parameterTypes;
    }

    public int getParameterCount() {
        return this.parser().getSignatureCount() - 1;
    }

    public boolean requiresClassClinit() {
        return this.getDefiningClass().mustClinit() && this.isStatic() && !this.isConstructor() && !this.getName().equals("<clinit>") && this.getDefiningClass() != Klass.KLASS;
    }

    public int getParametersSize() {
        boolean isStatic = this.isStatic() && !this.isConstructor();
        SymbolParser parser = this.parser();
        int sigcount = parser.getSignatureCount();
        int count = isStatic ? sigcount - 1 : sigcount;
        for (int i = 1; i < sigcount; ++i) {
            Klass type = parser.getSignatureTypeAt(i);
            if (!type.isDoubleWord()) continue;
            ++count;
        }
        return count;
    }

    public Klass[] getRuntimeParameterTypes(boolean reverseParameters) {
        boolean isStatic = this.isStatic() && !this.isConstructor();
        SymbolParser parser = this.parser();
        int sigcount = parser.getSignatureCount();
        int count = this.getParametersSize();
        Klass[] parameterTypes = new Klass[count];
        int j = 0;
        if (!isStatic) {
            parameterTypes[j++] = this.getDefiningClass();
        }
        for (int i = 1; i < sigcount; ++i) {
            Klass type = parser.getSignatureTypeAt(i);
            parameterTypes[j++] = type;
            if (type == Klass.LONG) {
                parameterTypes[j++] = Klass.LONG2;
            }
            if (type != Klass.DOUBLE) continue;
            parameterTypes[j++] = Klass.DOUBLE2;
        }
        if (this.isInterpreterInvoked() && reverseParameters) {
            Klass[] revparmtypes = new Klass[parameterTypes.length];
            j = 0;
            for (int i = parameterTypes.length - 1; i >= 0; --i) {
                Klass type = parameterTypes[i];
                if (type == Klass.LONG2 || type == Klass.DOUBLE2) {
                    revparmtypes[j++] = parameterTypes[--i];
                }
                revparmtypes[j++] = type;
            }
            parameterTypes = revparmtypes;
        }
        return parameterTypes;
    }

    public int[] getLineNumberTable() {
        MethodMetadata method = this.metadata.getMethodMetadata(this.isStatic(), this.getOffset());
        if (method != null) {
            return method.getLineNumberTable();
        }
        return null;
    }

    public ScopedLocalVariable[] getLocalVariableTable() {
        MethodMetadata method = this.metadata.getMethodMetadata(this.isStatic(), this.getOffset());
        if (method != null) {
            return method.getLocalVariableTable();
        }
        return null;
    }

    public static String lineNumberTableAsString(int[] lnt) {
        StringBuffer sb = new StringBuffer();
        if (lnt != null) {
            for (int i = 0; i < lnt.length; ++i) {
                int entry = lnt[i];
                sb.append(" " + (entry >>> 16) + " " + (entry & 0xFFFF));
            }
        }
        return sb.toString();
    }

    public static int getLineNumber(int[] lnt, int bci) {
        int lno = -1;
        if (lnt != null) {
            int entry;
            int addr;
            lno = 0;
            for (int i = 0; i < lnt.length && (addr = (entry = lnt[i]) >>> 16) < bci; ++i) {
                lno = entry & 0xFFFF;
            }
        }
        return lno;
    }
}

