/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.ByteBufferEncoder;
import com.sun.squawk.ExceptionHandler;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.MethodMetadata;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ScopedLocalVariable;
import com.sun.squawk.VMBufferDecoder;
import com.sun.squawk.util.Assert;

public final class MethodBody {
    public static final boolean LOCAL_LONG_ORDER_NORMAL = false;
    public static final boolean ENABLE_SPECIFIC_TYPE_TABLES = false;
    public static final boolean ENABLE_RELOCATION_TABLES = false;
    public static final boolean FORCE_LARGE_FORMAT = false;
    private final Method definingMethod;
    private final int index;
    private final int maxStack;
    private final int parametersCount;
    private final ExceptionHandler[] exceptionTable;
    private final MethodMetadata metadata;
    private final Klass[] localTypes;
    private final byte[] code;
    private static final int FMT_LARGE = 128;
    private static final int FMT_E = 1;
    private static final int FMT_R = 2;
    private static final int FMT_T = 4;
    private static final int FMT_I = 8;

    MethodBody() {
        this.definingMethod = null;
        this.index = -1;
        this.maxStack = -1;
        this.parametersCount = -1;
        this.exceptionTable = null;
        this.metadata = null;
        this.localTypes = null;
        this.code = null;
    }

    public MethodBody(Method definingMethod, int index, int maxStack, Klass[] locals, ExceptionHandler[] exceptionTable, int[] lnt, ScopedLocalVariable[] lvt, byte[] code, byte[] typeMap, boolean reverseParameters) {
        this.definingMethod = definingMethod;
        this.index = index;
        this.maxStack = maxStack;
        this.exceptionTable = exceptionTable;
        this.metadata = MethodMetadata.create(definingMethod.getOffset(), lvt, lnt);
        this.code = code;
        Klass[] parms = definingMethod.getRuntimeParameterTypes(reverseParameters);
        this.parametersCount = parms.length;
        this.localTypes = new Klass[parms.length + locals.length];
        int j = 0;
        int i = 0;
        while (i < parms.length) {
            this.localTypes[j] = parms[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < locals.length) {
            this.localTypes[j] = locals[i];
            ++i;
            ++j;
        }
    }

    public String toString() {
        return "[bytecode for " + this.definingMethod.getDefiningClass().getName() + "." + this.definingMethod.getName();
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getCode() {
        return this.code;
    }

    public Klass[] getTypes() {
        return this.localTypes;
    }

    public Method getDefiningMethod() {
        return this.definingMethod;
    }

    public Klass getDefiningClass() {
        return this.definingMethod.getDefiningClass();
    }

    public int getParametersCount() {
        return this.parametersCount;
    }

    public ExceptionHandler[] getExceptionTable() {
        return this.exceptionTable;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public MethodMetadata getMetadata() {
        return this.metadata;
    }

    void encodeHeader(ByteBufferEncoder enc) {
        int localsCount = this.localTypes.length - this.parametersCount;
        int start = enc.getSize();
        int typeTableSize = enc.getSize() - start;
        start = enc.getSize();
        int relocTableSize = enc.getSize() - start;
        start = enc.getSize();
        if (this.exceptionTable != null) {
            for (int i = 0; i < this.exceptionTable.length; ++i) {
                ExceptionHandler handler = this.exceptionTable[i];
                enc.addUnsignedInt(handler.getStart());
                enc.addUnsignedInt(handler.getEnd());
                enc.addUnsignedInt(handler.getHandler());
                int handlerTypeIndex = this.definingMethod.getDefiningClass().getObjectIndex(handler.getKlass());
                enc.addUnsignedShort(handlerTypeIndex);
            }
        }
        int exceptionTableSize = enc.getSize() - start;
        start = enc.getSize();
        int count = this.localTypes.length;
        int next = 0;
        while (count > 0) {
            int bite = 0;
            int n = count < 8 ? count : 8;
            count -= n;
            for (int i = 0; i < n; ++i) {
                Klass k;
                if (!(k = this.localTypes[next++]).isReferenceType()) continue;
                bite |= 1 << i;
            }
            enc.addUnsignedByte(bite);
        }
        int oopMapSize = enc.getSize() - start;
        if (localsCount < 32 && this.parametersCount < 32 && this.maxStack < 32 && typeTableSize == 0 && relocTableSize == 0 && exceptionTableSize == 0 && !this.definingMethod.isInterpreterInvoked()) {
            enc.addUnencodedByte(localsCount << 5 | this.maxStack);
            enc.addUnencodedByte(this.parametersCount << 2 | localsCount >> 3);
        } else {
            int fmt = 128;
            if (typeTableSize > 0) {
                this.writeMinfoSize(enc, typeTableSize);
                fmt |= 4;
            }
            if (relocTableSize > 0) {
                this.writeMinfoSize(enc, relocTableSize);
                fmt |= 2;
            }
            if (exceptionTableSize > 0) {
                this.writeMinfoSize(enc, exceptionTableSize);
                fmt |= 1;
            }
            if (this.definingMethod.isInterpreterInvoked()) {
                fmt |= 8;
            }
            this.writeMinfoSize(enc, this.parametersCount);
            this.writeMinfoSize(enc, localsCount);
            this.writeMinfoSize(enc, this.maxStack);
            enc.addUnsignedByte(fmt);
        }
    }

    private void roundup(ByteBufferEncoder enc, int extra) {
        while ((enc.getSize() + extra) % 4 != 0) {
            enc.addUnsignedByte(0);
        }
    }

    private void writeMinfoSize(ByteBufferEncoder enc, int value) {
        if (value < 128) {
            enc.addUnsignedByte(value);
        } else {
            enc.addUnsignedByte(value & 0xFF);
            enc.addUnsignedByte(0x80 | value >> 8);
        }
    }

    int getCodeSize() {
        return this.code.length;
    }

    void writeToVMMemory(Object oop) {
        for (int i = 0; i < this.code.length; ++i) {
            NativeUnsafe.setByte(oop, i, this.code[i]);
        }
    }

    public static boolean isInterpreterInvoked(Object oop) {
        int b0 = NativeUnsafe.getByte(oop, -13) & 0xFF;
        if (b0 < 128) {
            return false;
        }
        return (b0 & 8) != 0;
    }

    static int decodeParameterCount(Object oop) {
        int b0 = NativeUnsafe.getByte(oop, -13) & 0xFF;
        if (b0 < 128) {
            return b0 >> 2;
        }
        return MethodBody.minfoValue3(oop);
    }

    static int decodeLocalCount(Object oop) {
        int b0 = NativeUnsafe.getByte(oop, -13) & 0xFF;
        if (b0 < 128) {
            int b1 = NativeUnsafe.getByte(oop, -14) & 0xFF;
            return (b0 << 8 | b1) >> 5 & 0x1F;
        }
        return MethodBody.minfoValue2(oop);
    }

    static int decodeStackCount(Object oop) {
        int b0 = NativeUnsafe.getByte(oop, -13) & 0xFF;
        if (b0 < 128) {
            int b1 = NativeUnsafe.getByte(oop, -14) & 0xFF;
            return b1 & 0x1F;
        }
        return MethodBody.minfoValue1(oop);
    }

    static int decodeExceptionTableSize(Object oop) {
        int b0 = NativeUnsafe.getByte(oop, -13) & 0xFF;
        if (b0 < 128 || (b0 & 1) == 0) {
            return 0;
        }
        return MethodBody.minfoValue4(oop);
    }

    static int decodeRelocationTableSize(Object oop) {
        return 0;
    }

    static int decodeTypeTableSize(Object oop) {
        return 0;
    }

    private static int minfoValue(Object oop, int offset) {
        int p = -14;
        int val = -1;
        while (offset-- > 0) {
            if ((val = NativeUnsafe.getByte(oop, p--) & 0xFF) <= 127) continue;
            --p;
        }
        if (val > 127) {
            val &= 0x7F;
            val <<= 8;
            val |= NativeUnsafe.getByte(oop, p - 1) & 0xFF;
        }
        return val;
    }

    private static int minfoValue1(Object oop) {
        int val;
        int p = -14;
        if ((val = NativeUnsafe.getByte(oop, p--) & 0xFF) > 127) {
            val &= 0x7F;
            val <<= 8;
            val |= NativeUnsafe.getByte(oop, p) & 0xFF;
        }
        return val;
    }

    private static int minfoValue2(Object oop) {
        int val;
        int p = -14;
        if (NativeUnsafe.getByte(oop, p--) < 0) {
            --p;
        }
        if ((val = NativeUnsafe.getByte(oop, p--) & 0xFF) > 127) {
            val &= 0x7F;
            val <<= 8;
            val |= NativeUnsafe.getByte(oop, p) & 0xFF;
        }
        return val;
    }

    private static int minfoValue3(Object oop) {
        int val;
        int p = -14;
        if (NativeUnsafe.getByte(oop, p--) < 0) {
            --p;
        }
        if (NativeUnsafe.getByte(oop, p--) < 0) {
            --p;
        }
        if ((val = NativeUnsafe.getByte(oop, p--) & 0xFF) > 127) {
            val &= 0x7F;
            val <<= 8;
            val |= NativeUnsafe.getByte(oop, p) & 0xFF;
        }
        return val;
    }

    private static int minfoValue4(Object oop) {
        int val;
        int p = -14;
        if (NativeUnsafe.getByte(oop, p--) < 0) {
            --p;
        }
        if (NativeUnsafe.getByte(oop, p--) < 0) {
            --p;
        }
        if (NativeUnsafe.getByte(oop, p--) < 0) {
            --p;
        }
        if ((val = NativeUnsafe.getByte(oop, p--) & 0xFF) > 127) {
            val &= 0x7F;
            val <<= 8;
            val |= NativeUnsafe.getByte(oop, p) & 0xFF;
        }
        return val;
    }

    private static int getOffsetToLastMinfoByte(Object oop) {
        int b0;
        int p = -13;
        if ((b0 = NativeUnsafe.getByte(oop, p--) & 0xFF) < 128) {
            --p;
        } else {
            int offset = 3;
            if ((b0 & 1) != 0) {
                ++offset;
            }
            if ((b0 & 2) != 0) {
                ++offset;
            }
            if ((b0 & 4) != 0) {
                ++offset;
            }
            while (offset-- > 0) {
                int val;
                if ((val = NativeUnsafe.getByte(oop, p--) & 0xFF) <= 127) continue;
                --p;
            }
        }
        return p + 1;
    }

    static int decodeOopmapOffset(Object oop) {
        int vars = MethodBody.decodeLocalCount(oop) + MethodBody.decodeParameterCount(oop);
        int oopmapLth = (vars + 7) / 8;
        return MethodBody.getOffsetToLastMinfoByte(oop) - oopmapLth;
    }

    static int decodeExceptionTableOffset(Object oop) {
        int vars = MethodBody.decodeLocalCount(oop) + MethodBody.decodeParameterCount(oop);
        int oopmapLth = (vars + 7) / 8;
        return MethodBody.getOffsetToLastMinfoByte(oop) - oopmapLth - MethodBody.decodeExceptionTableSize(oop);
    }

    static int decodeRelocationTableOffset(Object oop) {
        int vars = MethodBody.decodeLocalCount(oop) + MethodBody.decodeParameterCount(oop);
        int oopmapLth = (vars + 7) / 8;
        return MethodBody.getOffsetToLastMinfoByte(oop) - oopmapLth - MethodBody.decodeExceptionTableSize(oop) - MethodBody.decodeRelocationTableSize(oop);
    }

    static int decodeTypeTableOffset(Object oop) {
        int vars = MethodBody.decodeLocalCount(oop) + MethodBody.decodeParameterCount(oop);
        int oopmapLth = (vars + 7) / 8;
        return MethodBody.getOffsetToLastMinfoByte(oop) - oopmapLth - MethodBody.decodeExceptionTableSize(oop) - MethodBody.decodeRelocationTableSize(oop) - MethodBody.decodeTypeTableSize(oop);
    }

    static Klass[] decodeTypeMap(Object oop) {
        int localCount = MethodBody.decodeLocalCount(oop);
        int parameterCount = MethodBody.decodeParameterCount(oop);
        Klass[] types = new Klass[parameterCount + localCount];
        if (types.length > 0) {
            int offset = MethodBody.decodeOopmapOffset(oop);
            for (int i = 0; i < types.length; ++i) {
                int pos = i / 8;
                int bit = i % 8;
                int bite = NativeUnsafe.getByte(oop, offset + pos) & 0xFF;
                boolean isRef = (bite >> bit & 1) != 0;
                types[i] = isRef ? Klass.OBJECT : Klass.INT;
            }
        }
        if (MethodBody.decodeTypeTableSize(oop) > 0) {
            int size = MethodBody.decodeTypeTableSize(oop);
            int offset = MethodBody.decodeTypeTableOffset(oop);
            VMBufferDecoder dec = new VMBufferDecoder(oop, offset);
            int end = offset + size;
            block9: while (dec.getOffset() < end) {
                int cid = dec.readUnsignedShort();
                int slot = dec.readUnsignedInt();
                int slot2 = slot < parameterCount ? slot + 1 : slot - 1;
                switch (cid) {
                    case 34: {
                        types[slot] = Klass.ADDRESS;
                        continue block9;
                    }
                    case 38: {
                        types[slot] = Klass.OFFSET;
                        continue block9;
                    }
                    case 36: {
                        types[slot] = Klass.UWORD;
                        continue block9;
                    }
                    case 11: {
                        types[slot] = Klass.LONG;
                        types[slot2] = Klass.LONG2;
                        continue block9;
                    }
                    case 13: {
                        types[slot] = Klass.FLOAT;
                        continue block9;
                    }
                    case 14: {
                        types[slot] = Klass.DOUBLE;
                        types[slot2] = Klass.DOUBLE2;
                        continue block9;
                    }
                }
                Assert.shouldNotReachHere("[MethodBody.java:919] ");
            }
        }
        return types;
    }

    static Address oopToBlock(Address oop) {
        int offset = MethodBody.decodeTypeTableOffset(oop.toObject());
        while (offset % 4 != 0) {
            --offset;
        }
        return oop.add(offset -= 4);
    }
}

