/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.FullMethodMetadata;
import com.sun.squawk.ScopedLocalVariable;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.Comparer;
import com.sun.squawk.util.SquawkVector;

public class MethodMetadata {
    private static boolean preserveLineNumberTables;
    private static boolean preserveLocalVariableTables;
    private final int[] lnt;
    private int offset;

    static void preserveLineNumberTables() {
        preserveLineNumberTables = true;
    }

    static void preserveLocalVariableTables() {
        preserveLocalVariableTables = true;
    }

    MethodMetadata(int offset, int[] lnt) {
        this.offset = offset;
        this.lnt = lnt;
    }

    static MethodMetadata create(int offset, ScopedLocalVariable[] lvt, int[] lnt) {
        if (lvt != null) {
            return new FullMethodMetadata(offset, lvt, lnt);
        }
        if (lnt != null) {
            return new MethodMetadata(offset, lnt);
        }
        return null;
    }

    final MethodMetadata strip(boolean lnt, boolean lvt) {
        if (lvt && this.getLocalVariableTable() != null) {
            return new FullMethodMetadata(this.offset, this.getLocalVariableTable(), lnt ? this.lnt : null);
        }
        if (lnt && this.getLineNumberTable() != null) {
            return new MethodMetadata(this.offset, this.lnt);
        }
        return null;
    }

    static MethodMetadata[] strip(MethodMetadata[] metadatas) {
        if (metadatas != null && (preserveLineNumberTables || preserveLocalVariableTables)) {
            SquawkVector temp = new SquawkVector(metadatas.length);
            for (int i = 0; i != metadatas.length; ++i) {
                MethodMetadata md = metadatas[i];
                if (md == null) continue;
                temp.addElement(md.strip(preserveLineNumberTables, preserveLocalVariableTables));
            }
            if (temp.size() == 0) {
                return null;
            }
            Object[] result = new MethodMetadata[temp.size()];
            temp.copyInto(result);
            Arrays.sort(result, new MethodMetadataComparer());
            return result;
        }
        return null;
    }

    public final int[] getLineNumberTable() {
        return this.lnt;
    }

    public ScopedLocalVariable[] getLocalVariableTable() {
        return null;
    }

    public static int binarySearch(MethodMetadata[] a, int keyOffset) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            MethodMetadata midVal = a[mid];
            int cmp = midVal.offset - keyOffset;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    static final class MethodMetadataComparer
    implements Comparer {
        MethodMetadataComparer() {
        }

        public int compare(Object a, Object b) {
            MethodMetadata ma = (MethodMetadata)a;
            MethodMetadata mb = (MethodMetadata)b;
            return ma.offset - mb.offset;
        }
    }
}

