/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import java.io.PrintStream;

final class Monitor {
    VMThread owner;
    VMThread monitorQueue;
    VMThread condvarQueue;
    short depth;
    boolean hasHadWaiter;
    final Object object;

    Monitor(Object object) {
        this.object = object;
        ++VMThread.monitorsAllocatedCount;
    }

    void addMonitorWait(VMThread thread) {
        thread.setInQueue((byte)1);
        VMThread next = this.monitorQueue;
        if (next == null) {
            this.monitorQueue = thread;
        } else {
            while (next.nextThread != null) {
                next = next.nextThread;
            }
            next.nextThread = thread;
        }
    }

    void addMonitorWaitHead(VMThread thread) {
        thread.setInQueue((byte)1);
        thread.nextThread = this.monitorQueue;
        this.monitorQueue = thread;
    }

    VMThread removeMonitorWait() {
        VMThread thread = this.monitorQueue;
        if (thread != null) {
            this.monitorQueue = thread.nextThread;
            thread.setNotInQueue((byte)1);
            thread.nextThread = null;
        }
        return thread;
    }

    void addCondvarWait(VMThread thread) {
        thread.setInQueue((byte)2);
        thread.monitor = this;
        VMThread next = this.condvarQueue;
        if (next == null) {
            this.condvarQueue = thread;
        } else {
            while (next.nextThread != null) {
                next = next.nextThread;
            }
            next.nextThread = thread;
        }
    }

    VMThread removeCondvarWait() {
        VMThread thread = this.condvarQueue;
        if (thread != null) {
            this.condvarQueue = thread.nextThread;
            thread.setNotInQueue((byte)2);
            thread.monitor = null;
            thread.nextThread = null;
        }
        return thread;
    }

    void removeCondvarWait(VMThread thread) {
        if (thread.inQueue((byte)2)) {
            VMThread next = this.condvarQueue;
            if (next == thread) {
                this.condvarQueue = thread.nextThread;
            } else {
                while (next.nextThread != thread) {
                    next = next.nextThread;
                }
                if (next.nextThread == thread) {
                    next.nextThread = thread.nextThread;
                }
            }
            thread.setNotInQueue((byte)2);
            thread.monitor = null;
            thread.nextThread = null;
        }
    }

    void printWaitingThreads(PrintStream out, Object o) {
        VMThread thread = this.condvarQueue;
        if (this.condvarQueue != null || this.monitorQueue != null) {
            VM.outPrint("===== Monitor queues for ");
            VM.outPrint(Address.fromObject(this).toUWord().toPrimitive());
            VM.outPrint(" for object ");
            VM.outPrintln(o.toString());
        }
        if (thread != null) {
            VM.outPrintln("Threads waiting for notify:");
            while (thread != null) {
                thread.printStackTrace(out);
                thread = thread.nextThread;
            }
        }
        if ((thread = this.monitorQueue) != null) {
            VM.outPrintln("Threads waiting for lock:");
            while (thread != null) {
                thread.printStackTrace(out);
                thread = thread.nextThread;
            }
        }
    }
}

