/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.Klass;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.pragma.NativePragma;
import com.sun.squawk.util.ArrayHashtable;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.BitSet;
import com.sun.squawk.util.SquawkHashtable;
import java.util.Enumeration;

public final class NativeUnsafe {
    private static SquawkHashtable unresolvedClassPointers;
    private static byte[] memory;
    private static int memorySize;
    private static BitSet oopMap;

    private NativeUnsafe() {
    }

    public static void setByte(Object base, int offset, int value) throws NativePragma {
        int index = ((Address)base).add(offset).asIndex();
        NativeUnsafe.checkAddress(index);
        NativeUnsafe.memory[index] = (byte)(value >> 0);
        NativeUnsafe.setType0(index, (byte)3);
    }

    public static void setShort(Object base, int offset, int value) throws NativePragma {
        NativeUnsafe.setChar(base, offset, value);
    }

    public static void setChar(Object base, int offset, int value) throws NativePragma {
        int index = ((Address)base).add(offset * 2).asIndex();
        NativeUnsafe.checkAddress(index + 1);
        if (VM.isBigEndian()) {
            NativeUnsafe.memory[index + 0] = (byte)(value >> 8);
            NativeUnsafe.memory[index + 1] = (byte)(value >> 0);
        } else {
            NativeUnsafe.memory[index + 0] = (byte)(value >> 0);
            NativeUnsafe.memory[index + 1] = (byte)(value >> 8);
        }
        NativeUnsafe.setType0(index, (byte)4);
    }

    public static void setInt(Object base, int offset, int value) throws NativePragma {
        int index = ((Address)base).add(offset * 4).asIndex();
        NativeUnsafe.checkAddress(index + 3);
        if (VM.isBigEndian()) {
            NativeUnsafe.memory[index + 0] = (byte)(value >> 24);
            NativeUnsafe.memory[index + 1] = (byte)(value >> 16);
            NativeUnsafe.memory[index + 2] = (byte)(value >> 8);
            NativeUnsafe.memory[index + 3] = (byte)(value >> 0);
        } else {
            NativeUnsafe.memory[index + 0] = (byte)(value >> 0);
            NativeUnsafe.memory[index + 1] = (byte)(value >> 8);
            NativeUnsafe.memory[index + 2] = (byte)(value >> 16);
            NativeUnsafe.memory[index + 3] = (byte)(value >> 24);
        }
        NativeUnsafe.setType0(index, (byte)5);
    }

    public static void setUWord(Object base, int offset, UWord value) throws NativePragma {
        NativeUnsafe.setInt(base, offset, value.toPrimitive());
        int index = ((Address)base).add(offset * 4).asIndex();
        NativeUnsafe.setType0(index, (byte)12);
    }

    public static void setLong(Object base, int offset, long value) throws NativePragma {
        int index = ((Address)base).add(offset * 8).asIndex();
        NativeUnsafe.checkAddress(index + 7);
        if (VM.isBigEndian()) {
            NativeUnsafe.memory[index + 0] = (byte)(value >> 56);
            NativeUnsafe.memory[index + 1] = (byte)(value >> 48);
            NativeUnsafe.memory[index + 2] = (byte)(value >> 40);
            NativeUnsafe.memory[index + 3] = (byte)(value >> 32);
            NativeUnsafe.memory[index + 4] = (byte)(value >> 24);
            NativeUnsafe.memory[index + 5] = (byte)(value >> 16);
            NativeUnsafe.memory[index + 6] = (byte)(value >> 8);
            NativeUnsafe.memory[index + 7] = (byte)(value >> 0);
        } else {
            NativeUnsafe.memory[index + 0] = (byte)(value >> 0);
            NativeUnsafe.memory[index + 1] = (byte)(value >> 8);
            NativeUnsafe.memory[index + 2] = (byte)(value >> 16);
            NativeUnsafe.memory[index + 3] = (byte)(value >> 24);
            NativeUnsafe.memory[index + 4] = (byte)(value >> 32);
            NativeUnsafe.memory[index + 5] = (byte)(value >> 40);
            NativeUnsafe.memory[index + 6] = (byte)(value >> 48);
            NativeUnsafe.memory[index + 7] = (byte)(value >> 56);
        }
        NativeUnsafe.setType0(index, (byte)7);
    }

    public static void setLongAtWord(Object base, int offset, long value) throws NativePragma {
        Address ea = ((Address)base).add(offset * 4);
        NativeUnsafe.setLong(ea, 0, value);
        NativeUnsafe.setType0(ea.asIndex(), (byte)7);
    }

    public static void setAddress(Object base, int offset, Object value) throws NativePragma {
        Address ea = ((Address)base).add(offset * 4);
        if (value instanceof Klass) {
            unresolvedClassPointers.put(ea, value);
            NativeUnsafe.setUWord(ea, 0, UWord.zero());
        } else {
            unresolvedClassPointers.remove(ea);
            NativeUnsafe.setUWord(ea, 0, ((Address)value).toUWord());
        }
        oopMap.set(ea.asIndex() / 4);
        NativeUnsafe.setType0(ea.asIndex(), (byte)11);
    }

    public static void setObject(Object base, int offset, Object value) throws NativePragma {
        NativeUnsafe.setAddress(base, offset, value);
    }

    private static void setType0(int index, byte type) throws HostedPragma {
    }

    public static void setType(Address ea, byte type, int size) throws NativePragma {
    }

    public static void setArrayTypes(Address ea, byte componentType, int componentSize, int length) throws NativePragma {
    }

    public static byte getType(Address ea) throws NativePragma {
        throw Assert.shouldNotReachHere();
    }

    public static void copyTypes(Address src, Address dst, int length) throws NativePragma {
    }

    public static int getByte(Object base, int offset) throws NativePragma {
        int index = ((Address)base).add(offset).asIndex();
        NativeUnsafe.checkAddress(index);
        return memory[index];
    }

    public static int getUByte(Object base, int offset) {
        return NativeUnsafe.getByte(base, offset) & 0xFF;
    }

    public static int getShort(Object base, int offset) throws NativePragma {
        return (short)NativeUnsafe.getChar(base, offset);
    }

    public static int getChar(Object base, int offset) throws NativePragma {
        int index = ((Address)base).add(offset * 2).asIndex();
        NativeUnsafe.checkAddress(index + 1);
        int b0 = memory[index] & 0xFF;
        int b1 = memory[index + 1] & 0xFF;
        if (VM.isBigEndian()) {
            return b0 << 8 | b1;
        }
        return b1 << 8 | b0;
    }

    public static int getInt(Object base, int offset) throws NativePragma {
        int index = ((Address)base).add(offset * 4).asIndex();
        NativeUnsafe.checkAddress(index + 3);
        int b0 = memory[index + 0] & 0xFF;
        int b1 = memory[index + 1] & 0xFF;
        int b2 = memory[index + 2] & 0xFF;
        int b3 = memory[index + 3] & 0xFF;
        if (VM.isBigEndian()) {
            return b0 << 24 | b1 << 16 | b2 << 8 | b3;
        }
        return b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    public static UWord getUWord(Object base, int offset) throws NativePragma {
        return UWord.fromPrimitive(NativeUnsafe.getInt(base, offset));
    }

    public static long getLong(Object base, int offset) throws NativePragma {
        int index = ((Address)base).add(offset * 8).asIndex();
        NativeUnsafe.checkAddress(index + 7);
        long b0 = memory[index + 0] & 0xFF;
        long b1 = memory[index + 1] & 0xFF;
        long b2 = memory[index + 2] & 0xFF;
        long b3 = memory[index + 3] & 0xFF;
        long b4 = memory[index + 4] & 0xFF;
        long b5 = memory[index + 5] & 0xFF;
        long b6 = memory[index + 6] & 0xFF;
        long b7 = memory[index + 7] & 0xFF;
        if (VM.isBigEndian()) {
            return b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7;
        }
        return b7 << 56 | b6 << 48 | b5 << 40 | b4 << 32 | b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    public static long getLongAtWord(Object base, int offset) throws NativePragma {
        return NativeUnsafe.getLong(((Address)base).add(offset * 4), 0);
    }

    public static Object getObject(Object base, int offset) throws NativePragma {
        return Address.get(NativeUnsafe.getUWord(base, offset).toPrimitive());
    }

    public static Address getAddress(Object base, int offset) throws NativePragma {
        return Address.fromObject(NativeUnsafe.getObject(base, offset));
    }

    public static UWord getAsUWord(Object base, int offset) throws NativePragma {
        return NativeUnsafe.getUWord(base, offset);
    }

    public static int getAsByte(Object base, int offset) throws NativePragma {
        return NativeUnsafe.getByte(base, offset);
    }

    public static int getAsShort(Object base, int offset) throws NativePragma {
        return NativeUnsafe.getShort(base, offset);
    }

    public static int getAsInt(Object base, int offset) throws NativePragma {
        return NativeUnsafe.getInt(base, offset);
    }

    public static char charAt(String str, int index) throws NativePragma {
        return str.charAt(index);
    }

    public static Address malloc(UWord size) throws NativePragma {
        throw Assert.shouldNotReachHere("unimplemented when hosted");
    }

    public static void free(Address ptr) throws NativePragma {
        Assert.shouldNotReachHere("[NativeUnsafe.java:494] unimplemented when hosted");
    }

    public static int getUnalignedShort(Address base, int boffset) throws NativePragma {
        throw Assert.shouldNotReachHere("unimplemented when hosted");
    }

    public static int getUnalignedInt(Address base, int boffset) throws NativePragma {
        throw Assert.shouldNotReachHere("unimplemented when hosted");
    }

    public static long getUnalignedLong(Address base, int boffset) throws NativePragma {
        throw Assert.shouldNotReachHere("unimplemented when hosted");
    }

    public static void setUnalignedShort(Address base, int boffset, int value) throws NativePragma {
        Assert.shouldNotReachHere("[NativeUnsafe.java:557] unimplemented when hosted");
    }

    public static void setUnalignedInt(Address base, int boffset, int value) throws NativePragma {
        Assert.shouldNotReachHere("[NativeUnsafe.java:572] unimplemented when hosted");
    }

    public static void setUnalignedLong(Address base, int boffset, long value) throws NativePragma {
        Assert.shouldNotReachHere("[NativeUnsafe.java:587] unimplemented when hosted");
    }

    public static void swap(Address address, int dataSize) throws NativePragma {
        switch (dataSize) {
            case 1: {
                break;
            }
            case 2: {
                NativeUnsafe.swap2(address);
                break;
            }
            case 4: {
                NativeUnsafe.swap4(address);
                break;
            }
            case 8: {
                NativeUnsafe.swap8(address);
                break;
            }
            default: {
                Assert.shouldNotReachHere("[NativeUnsafe.java:606] ");
            }
        }
    }

    public static void swap2(Address address) throws NativePragma {
        int val = NativeUnsafe.getChar(address, 0);
        int b0 = val & 0xFF;
        int b1 = val >> 8 & 0xFF;
        int newVal = b0 << 8 | b1;
        NativeUnsafe.setChar(address, 0, newVal);
    }

    public static void swap4(Address address) throws NativePragma {
        int val = NativeUnsafe.getInt(address, 0);
        int b0 = val & 0xFF;
        int b1 = val >> 8 & 0xFF;
        int b2 = val >> 16 & 0xFF;
        int b3 = val >> 24 & 0xFF;
        int newVal = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        NativeUnsafe.setInt(address, 0, newVal);
    }

    public static void swap8(Address address) throws NativePragma {
        long val = NativeUnsafe.getLong(address, 0);
        long b0 = val & 0xFFL;
        long b1 = val >> 8 & 0xFFL;
        long b2 = val >> 16 & 0xFFL;
        long b3 = val >> 24 & 0xFFL;
        long b4 = val >> 32 & 0xFFL;
        long b5 = val >> 40 & 0xFFL;
        long b6 = val >> 48 & 0xFFL;
        long b7 = val >> 56 & 0xFFL;
        long newVal = b0 << 56 | b1 << 48 | b2 << 40 | b3 << 32 | b4 << 24 | b5 << 16 | b6 << 8 | b7;
        NativeUnsafe.setLong(address, 0, newVal);
    }

    static void resolveClasses(ArrayHashtable classMap) throws HostedPragma {
        Enumeration keys = unresolvedClassPointers.keys();
        while (keys.hasMoreElements()) {
            Address address = (Address)keys.nextElement();
            Klass unresolvedClass = (Klass)unresolvedClassPointers.get(address);
            Address klassAddress = (Address)classMap.get(unresolvedClass);
            if (klassAddress == null) {
                throw new RuntimeException("Klass " + unresolvedClass.getName() + " was not serialied");
            }
            NativeUnsafe.setAddress(address, 0, klassAddress);
        }
        unresolvedClassPointers.clear();
    }

    public static void clearObject(Object base, int offset) throws HostedPragma {
        Address ea = ((Address)base).add(offset * 4);
        NativeUnsafe.setUWord(ea, 0, UWord.zero());
        unresolvedClassPointers.remove(ea);
        oopMap.clear(ea.asIndex() / 4);
        NativeUnsafe.setType0(ea.asIndex(), (byte)0);
    }

    public static synchronized void hostedInit() throws HostedPragma {
        if (memory == null) {
            memorySize = 0;
            memory = new byte[0];
            oopMap = new BitSet();
            unresolvedClassPointers = new SquawkHashtable();
        }
    }

    private static void checkAddress(int address) throws IndexOutOfBoundsException, HostedPragma {
        if (address < 0 || address >= memorySize) {
            throw new IndexOutOfBoundsException("address is out of range: " + address);
        }
    }

    private static void ensureCapacity(int size) throws HostedPragma {
        if (memory.length < (size = GC.roundUpToWord(size))) {
            byte[] newMemory = new byte[size * 2];
            System.arraycopy(memory, 0, newMemory, 0, memory.length);
            memory = newMemory;
        }
    }

    public static void initialize(byte[] buffer, BitSet oopMap, boolean append) throws HostedPragma {
        if (!append) {
            NativeUnsafe.setMemorySize(buffer.length);
            System.arraycopy(buffer, 0, memory, 0, buffer.length);
            NativeUnsafe.oopMap.or(oopMap);
        } else {
            int canonicalStart = memorySize;
            NativeUnsafe.setMemorySize(memorySize + buffer.length);
            System.arraycopy(buffer, 0, memory, canonicalStart, buffer.length);
            int shift = canonicalStart / 4;
            NativeUnsafe.oopMap.or(oopMap, shift);
        }
    }

    public static void setMemorySize(int newSize) throws HostedPragma {
        Assert.always(newSize >= 0);
        NativeUnsafe.hostedInit();
        if (newSize > memorySize) {
            NativeUnsafe.ensureCapacity(newSize);
        } else {
            for (int i = newSize; i < memory.length; ++i) {
                NativeUnsafe.memory[i] = 0;
                oopMap.clear(i / 4);
            }
        }
        memorySize = newSize;
    }

    static int getMemorySize() throws HostedPragma {
        return memorySize;
    }

    static boolean isReference(Address address) throws HostedPragma {
        return address.asIndex() % 4 == 0 && oopMap.get(address.asIndex() / 4);
    }

    public static void copyMemory(byte[] buffer, int memoryOffset, int bufferOffset, int length) throws HostedPragma {
        System.arraycopy(memory, memoryOffset, buffer, bufferOffset, length);
    }

    static BitSet getOopMap() throws HostedPragma {
        return oopMap;
    }
}

