/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.Offset;
import com.sun.squawk.Suite;
import com.sun.squawk.VM;
import com.sun.squawk.util.BitSet;

public final class ObjectMemory {
    public static final String BOOTSTRAP_URI = "memory:bootstrap";
    public static final String BOOTSTRAP_URI_PROPERTY = "bootstrap.suite.url";
    private final int hash;
    private final String uri;
    private final Address start;
    private final int size;
    private final Address canonicalStart;
    private Object root;
    private final ObjectMemory parent;

    public ObjectMemory(Address start, int size, String uri, Object root, int hash, ObjectMemory parent) {
        this.start = start;
        this.size = size;
        this.uri = uri;
        this.root = root;
        this.hash = hash;
        this.parent = parent;
        this.canonicalStart = parent == null ? Address.zero() : parent.getCanonicalEnd();
    }

    public static ObjectMemory createBootstrapObjectMemory(Suite bootstrapSuite) {
        return new ObjectMemory(VM.getBootstrapStart(), VM.getBootstrapEnd().diff(VM.getBootstrapStart()).toInt(), null, bootstrapSuite, VM.getBootstrapHash(), null);
    }

    public Address getCanonicalStart() {
        return this.canonicalStart;
    }

    public Address getCanonicalEnd() {
        return this.getCanonicalStart().add(this.size);
    }

    public int getSize() {
        return this.size;
    }

    public Object getRoot() {
        return this.root;
    }

    void setRoot(Object root) {
        this.root = root;
    }

    public ObjectMemory getParent() {
        return this.parent;
    }

    public int getParentCount() {
        if (this.parent == null) {
            return 0;
        }
        return 1 + this.parent.getParentCount();
    }

    public int getHash() {
        return this.hash;
    }

    public String getURI() {
        if (this.parent == null) {
            return BOOTSTRAP_URI;
        }
        return this.uri;
    }

    public Address getStart() {
        if (!VM.isHosted() && this.parent == null) {
            return VM.getRomStart();
        }
        return this.start;
    }

    public Address getEnd() {
        return this.getStart().add(this.size);
    }

    public boolean containsAddress(Address address) {
        return address.hieq(this.start) && address.lo(this.getEnd());
    }

    public boolean containsCanonicalAddress(Address canonicalAddress) {
        return canonicalAddress.hieq(this.canonicalStart) && canonicalAddress.lo(this.getCanonicalEnd());
    }

    public ObjectMemory findAddress(Address address) {
        if (address.hieq(this.start)) {
            return this;
        }
        return this.parent.findAddress(address);
    }

    public ObjectMemory findCanonicalAddress(Address canonicalAddress) {
        if (canonicalAddress.hieq(this.canonicalStart)) {
            return this;
        }
        return this.parent.findCanonicalAddress(canonicalAddress);
    }

    public Address toCanonical(Address address) {
        Offset delta = address.diff(this.start);
        return this.canonicalStart.addOffset(delta);
    }

    public Address fromCanonical(Address canonicalAddress) {
        Offset delta = canonicalAddress.diff(this.canonicalStart);
        return this.start.addOffset(delta);
    }

    public static void relocateParents(String uri, Object startBuffer, Address start, BitSet oopMap, ObjectMemory parent, boolean toCanonical, boolean requiresEndianSwap, boolean trace) {
        while (parent != null) {
            ObjectMemory.relocate(uri, startBuffer, start, oopMap, parent.getStart(), parent.getCanonicalStart(), parent.getSize(), toCanonical, requiresEndianSwap, trace, false);
            parent = parent.getParent();
        }
    }

    public static void relocate(String uri, Object sourceStartBuffer, Address sourceStart, BitSet oopMap, Address targetStart, Address targetCanonicalStart, int targetSize, boolean toCanonical, boolean requiresEndianSwap, boolean trace, boolean verifyClearOopMap) throws GCDuringRelocationError {
        Address pointer;
        Address pointerAddress;
        Offset delta;
        Address start;
        if (toCanonical) {
            start = targetStart;
            delta = targetCanonicalStart.diff(targetStart);
        } else {
            start = targetCanonicalStart;
            delta = targetStart.diff(targetCanonicalStart);
        }
        Address end = start.add(targetSize);
        int offset = oopMap.nextSetBit(0);
        while (offset != -1) {
            if (sourceStartBuffer != null && !VM.isHosted() && sourceStartBuffer != sourceStart.toObject()) {
                throw new GCDuringRelocationError();
            }
            pointerAddress = sourceStart.add(offset * 4);
            pointer = Address.fromObject(NativeUnsafe.getObject(pointerAddress, 0));
            if (pointer.isZero()) {
                oopMap.clear(offset);
            } else {
                if (requiresEndianSwap) {
                    NativeUnsafe.swap(pointerAddress, 4);
                    pointer = Address.fromObject(NativeUnsafe.getObject(pointerAddress, 0));
                }
                if (pointer.hi(start) && pointer.loeq(end)) {
                    Address relocatedPointer = pointer.addOffset(delta);
                    NativeUnsafe.setAddress(pointerAddress, 0, relocatedPointer);
                    oopMap.clear(offset);
                }
                if (requiresEndianSwap) {
                    NativeUnsafe.swap(pointerAddress, 4);
                }
            }
            offset = oopMap.nextSetBit(offset + 1);
        }
        if (verifyClearOopMap && oopMap.cardinality() != 0) {
            VM.println("These pointers were not relocated during object memory (de)serialization:");
            offset = oopMap.nextSetBit(0);
            while (offset != -1) {
                pointerAddress = sourceStart.add(offset * 4);
                if (requiresEndianSwap) {
                    NativeUnsafe.swap(pointerAddress, 4);
                }
                pointer = Address.fromObject(NativeUnsafe.getObject(pointerAddress, 0));
                VM.print("  @ ");
                VM.printAddress(pointerAddress);
                VM.print(" [offset ");
                VM.print(offset * 4);
                VM.print("] = ");
                VM.printAddress(pointer);
                VM.println();
                if (requiresEndianSwap) {
                    NativeUnsafe.swap(pointerAddress, 4);
                }
                offset = oopMap.nextSetBit(offset + 1);
            }
            VM.fatalVMError();
        }
    }

    static class GCDuringRelocationError
    extends Error {
        GCDuringRelocationError() {
        }
    }
}

