/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.ObjectMemoryEndianessSwapper;
import com.sun.squawk.ObjectMemoryLoader;
import com.sun.squawk.ObjectMemoryOutputStream;
import com.sun.squawk.VM;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.BitSet;
import java.io.DataOutputStream;
import java.io.IOException;

public class ObjectMemorySerializer {
    private ObjectMemorySerializer() {
    }

    public static void save(DataOutputStream dos, String uri, ControlBlock cb, ObjectMemory parent, boolean bigEndian) throws IOException {
        boolean requiresEndianSwap;
        ObjectMemoryOutputStream sfos = new ObjectMemoryOutputStream(dos);
        sfos.writeInt(-559038737, "magic");
        sfos.writeShort(1, "minor_version");
        sfos.writeShort(1, "major_version");
        int attributes = 0;
        attributes |= 2;
        if (bigEndian) {
            attributes |= 4;
        }
        sfos.writeInt(attributes, "attributes");
        if (parent == null) {
            sfos.writeInt(0, "parent_hash");
            sfos.writeUTF("", "parent_uri");
        } else {
            sfos.writeInt(parent.getHash(), "parent_hash");
            sfos.writeUTF(parent.getURI(), "parent_uri");
        }
        int size = cb.memory.length;
        sfos.writeInt(cb.root, "root");
        sfos.writeInt(size, "size");
        byte[] bits = new byte[GC.calculateOopMapSizeInBytes(size)];
        cb.oopMap.copyInto(bits);
        sfos.write(bits, "oopmap");
        Address canonicalStart = ObjectMemorySerializer.relocateMemory(cb.memory, cb.start, cb.oopMap, parent, false);
        int pad = ObjectMemoryLoader.calculateMemoryPadding(parent == null ? "" : parent.getURI(), size);
        while (pad-- != 0) {
            sfos.writeByte(0);
        }
        boolean bl = requiresEndianSwap = VM.isBigEndian() != bigEndian;
        if (requiresEndianSwap) {
            ObjectMemory om = new ObjectMemory(VM.isHosted() ? cb.start : Address.fromObject(cb.memory), size, "", null, 0, parent);
            ObjectMemoryEndianessSwapper.swap(om, false, true);
            if (VM.isHosted()) {
                NativeUnsafe.copyMemory(cb.memory, cb.start.toUWord().toInt(), 0, cb.memory.length);
            }
        }
        sfos.write(cb.memory, "memory");
        sfos.flush();
        if (dos == null) {
            sfos.close();
        }
    }

    private static Address relocateMemory(byte[] memory, Address start, BitSet oopMap, ObjectMemory parent, boolean tracing) {
        Address canonicalStart;
        if (parent != null) {
            canonicalStart = parent.getCanonicalEnd();
            ObjectMemory.relocateParents("RAM", null, VM.isHosted() ? start : Address.fromObject(memory), oopMap, parent, true, false, tracing);
        } else {
            canonicalStart = Address.zero();
        }
        ObjectMemory.relocate("RAM", null, VM.isHosted() ? start : Address.fromObject(memory), oopMap, start, canonicalStart, memory.length, true, false, tracing, true);
        Assert.always(oopMap.cardinality() == 0, "some pointers were not relocated");
        return canonicalStart;
    }

    public static final class ControlBlock {
        public byte[] memory;
        public Address start;
        public BitSet oopMap;
        public int root;
    }
}

