/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.Field;
import com.sun.squawk.GC;
import com.sun.squawk.IllegalStoreException;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.KlassMetadata;
import com.sun.squawk.ManifestProperty;
import com.sun.squawk.Method;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.ObjectMemoryLoader;
import com.sun.squawk.ObjectMemorySerializer;
import com.sun.squawk.ResourceFile;
import com.sun.squawk.SymbolParser;
import com.sun.squawk.TranslatorInterface;
import com.sun.squawk.VM;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.LineReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public final class Suite {
    private Klass[] classes;
    private final String name;
    private KlassMetadata[] metadatas;
    private final Suite parent;
    private boolean closed;
    private ResourceFile[] resourceFiles;
    private ManifestProperty[] manifestProperties;
    private boolean isPropertiesManifestResourceInstalled;
    private String[] noClassDefFoundErrorClassNames;
    private String configuration;
    public static final int APPLICATION = 0;
    public static final int LIBRARY = 1;
    public static final int EXTENDABLE_LIBRARY = 2;
    public static final int DEBUG = 3;
    public static final int METADATA = 4;
    public static final String FILE_EXTENSION = ".suite";
    public static final String FILE_EXTENSION_API = ".api";
    public static final String FILE_EXTENSION_METADATA = ".metadata";
    public static final String PROPERTIES_MANIFEST_RESOURCE_NAME = "META-INF/MANIFEST.MF";

    Suite(String name, Suite parent) {
        this.name = name;
        this.parent = parent;
        int count = this.isBootstrap() ? 40 : 0;
        this.classes = new Klass[count];
        this.metadatas = new KlassMetadata[count];
        this.resourceFiles = new ResourceFile[0];
        this.manifestProperties = new ManifestProperty[0];
    }

    public String getName() {
        return this.name;
    }

    public Suite getParent() {
        return this.parent;
    }

    public String getURI() {
        ObjectMemory om = this.getReadOnlyObjectMemory();
        if (om != null) {
            return om.getURI();
        }
        return null;
    }

    public int getClassCount() {
        return this.classes.length;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isBootstrap() {
        return this.parent == null;
    }

    public int getNextAvailableClassNumber() {
        return this.getClassCount();
    }

    public Klass getKlass(int suiteID) {
        return this.classes[suiteID];
    }

    public byte[] getResourceData(String name) {
        byte[] bytes;
        if (!this.isBootstrap() && (bytes = this.parent.getResourceData(name)) != null) {
            return bytes;
        }
        int index = Arrays.binarySearch(this.resourceFiles, name, ResourceFile.comparer);
        if (index < 0) {
            return null;
        }
        return this.resourceFiles[index].data;
    }

    public Enumeration getManifestPropertyNames() {
        Vector names = new Vector(this.manifestProperties.length);
        for (int i = 0; i < this.manifestProperties.length; ++i) {
            names.addElement(this.manifestProperties[i].name);
        }
        return names.elements();
    }

    public String getManifestProperty(String name) {
        int index = Arrays.binarySearch(this.manifestProperties, name, ManifestProperty.comparer);
        if (index < 0) {
            if (this.isClosed() || this.isPropertiesManifestResourceInstalled) {
                return null;
            }
            InputStream input = this.getResourceAsStream(PROPERTIES_MANIFEST_RESOURCE_NAME, null);
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.isPropertiesManifestResourceInstalled = true;
            index = Arrays.binarySearch(this.manifestProperties, name, ManifestProperty.comparer);
            if (index < 0) {
                return null;
            }
        }
        return this.manifestProperties[index].value;
    }

    public final InputStream getResourceAsStream(String name, Klass klass) {
        String className;
        int dotIndex;
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        } else if (klass != null && (dotIndex = (className = klass.getName()).lastIndexOf(46)) >= 0) {
            name = className.substring(0, dotIndex + 1).replace('.', '/') + name;
        }
        byte[] bytes = this.getResourceData(name);
        if (bytes == null) {
            if (this.isClosed()) {
                return null;
            }
            Isolate isolate = VM.getCurrentIsolate();
            TranslatorInterface translator = isolate.getTranslator();
            if (translator == null) {
                return null;
            }
            translator.open(isolate.getLeafSuite(), isolate.getClassPath());
            bytes = translator.getResourceData(name);
            if (bytes == null) {
                return null;
            }
        }
        return new ByteArrayInputStream(bytes);
    }

    public String toString() {
        return "suite " + this.name + " [closed: " + this.closed + ", parent: " + (this.parent == null ? "null" : this.parent.getName()) + "]";
    }

    private ObjectMemory getReadOnlyObjectMemoryHosted() throws HostedPragma {
        String uri = this.isBootstrap() ? "memory:bootstrap" : "file://" + this.name + FILE_EXTENSION;
        return GC.lookupReadOnlyObjectMemoryBySourceURI(uri);
    }

    ObjectMemory getReadOnlyObjectMemory() {
        if (VM.isHosted()) {
            return this.getReadOnlyObjectMemoryHosted();
        }
        return GC.lookupReadOnlyObjectMemoryByRoot(this);
    }

    public void installClass(Klass klass) {
        this.checkWrite();
        int suiteID = klass.getSuiteID();
        if (suiteID >= this.classes.length) {
            Klass[] old = this.classes;
            this.classes = new Klass[suiteID + 1];
            System.arraycopy(old, 0, this.classes, 0, old.length);
        }
        this.classes[suiteID] = klass;
    }

    void installMetadata(KlassMetadata metadata) {
        this.checkWrite();
        Klass klass = metadata.getDefinedClass();
        int suiteID = klass.getSuiteID();
        if (suiteID >= this.metadatas.length) {
            KlassMetadata[] old = this.metadatas;
            this.metadatas = new KlassMetadata[suiteID + 1];
            System.arraycopy(old, 0, this.metadatas, 0, old.length);
        }
        this.metadatas[suiteID] = metadata;
    }

    void pushUpMetadatas() {
        this.parent.metadatas = this.metadatas;
    }

    public void addNoClassDefFoundErrorClassNames(String[] classNames) {
        if (this.noClassDefFoundErrorClassNames == null && (classNames == null || classNames.length == 0)) {
            return;
        }
        if (this.noClassDefFoundErrorClassNames == null) {
            this.noClassDefFoundErrorClassNames = new String[0];
        }
        String[] newNames = new String[this.noClassDefFoundErrorClassNames.length + classNames.length];
        System.arraycopy(this.noClassDefFoundErrorClassNames, 0, newNames, 0, this.noClassDefFoundErrorClassNames.length);
        System.arraycopy(classNames, 0, newNames, this.noClassDefFoundErrorClassNames.length, classNames.length);
        this.noClassDefFoundErrorClassNames = newNames;
    }

    String[] getNoClassDefFoundErrorClassNames() {
        return this.noClassDefFoundErrorClassNames;
    }

    boolean shouldThrowNoClassDefFoundErrorFor(String className) {
        if (this.noClassDefFoundErrorClassNames == null) {
            return false;
        }
        for (int i = 0; i < this.noClassDefFoundErrorClassNames.length; ++i) {
            if (!this.noClassDefFoundErrorClassNames[i].equals(className)) continue;
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.shouldThrowNoClassDefFoundErrorFor(className);
    }

    public void installResource(ResourceFile resourceFile) {
        this.checkWrite();
        this.resourceFiles = new ResourceFile[this.resourceFiles.length + 1];
        System.arraycopy(this.resourceFiles, 0, this.resourceFiles, 0, this.resourceFiles.length - 1);
        this.resourceFiles[this.resourceFiles.length - 1] = resourceFile;
        Arrays.sort(this.resourceFiles, ResourceFile.comparer);
        if (resourceFile.name.equalsIgnoreCase(PROPERTIES_MANIFEST_RESOURCE_NAME)) {
            this.isPropertiesManifestResourceInstalled = true;
            this.loadProperties(resourceFile.data);
        }
    }

    static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    static String stripLeadingWS(String src, int start) {
        int len = src.length();
        while (start < len && Suite.isWhiteSpace(src.charAt(start))) {
            ++start;
        }
        return src.substring(start);
    }

    protected void loadProperties(byte[] bytes) {
        block8: {
            LineReader reader = new LineReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
            try {
                String line;
                String key = null;
                String value = null;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int keyEnd = line.indexOf(58);
                    boolean continuationLine = Suite.isWhiteSpace(line.charAt(0));
                    if (continuationLine) {
                        if (key == null || value == null) {
                            throw new IOException("Illformed continuation line :" + line);
                        }
                        value = value + Suite.stripLeadingWS(line, 0);
                        continue;
                    }
                    if (keyEnd > 0) {
                        if (key != null) {
                            this.setProperty(key, value);
                        }
                        key = line.substring(0, keyEnd);
                        value = Suite.stripLeadingWS(line, keyEnd + 1);
                        continue;
                    }
                    throw new IOException("Illformed property line :" + line);
                }
                if (key != null) {
                    this.setProperty(key, value);
                }
            }
            catch (IOException e) {
                if (!VM.isVerbose()) break block8;
                System.out.println("Error while loading properties: " + e.getMessage());
            }
        }
    }

    public void setProperty(String key, String value) {
        ManifestProperty property = new ManifestProperty(key, value);
        this.installProperty(property);
    }

    public void installProperty(ManifestProperty property) {
        this.checkWrite();
        int index = Arrays.binarySearch(this.manifestProperties, property.name, ManifestProperty.comparer);
        if (index < 0) {
            if (VM.isVerbose()) {
                System.out.println("[Adding property key: |" + property.name + "| value: |" + property.value + "|]");
            }
            this.manifestProperties = new ManifestProperty[this.manifestProperties.length + 1];
            System.arraycopy(this.manifestProperties, 0, this.manifestProperties, 0, this.manifestProperties.length - 1);
            this.manifestProperties[this.manifestProperties.length - 1] = property;
            Arrays.sort(this.manifestProperties, ManifestProperty.comparer);
        } else {
            if (VM.isVerbose()) {
                System.out.println("[Overwriting property key: |" + property.name + "| value: |" + property.value + "|]");
            }
            this.manifestProperties[index] = property;
        }
    }

    KlassMetadata getMetadata(Klass klass) {
        KlassMetadata metadata;
        int suiteID;
        KlassMetadata metadata2;
        if (!this.isBootstrap() && (metadata2 = this.parent.getMetadata(klass)) != null) {
            return metadata2;
        }
        if (this.metadatas != null && (suiteID = klass.getSuiteID()) < this.metadatas.length && (metadata = this.metadatas[suiteID]) != null && metadata.getDefinedClass() == klass) {
            return metadata;
        }
        return null;
    }

    public Klass lookup(String name) {
        Klass klass;
        if (!this.isBootstrap() && (klass = this.parent.lookup(name)) != null) {
            return klass;
        }
        for (int i = 0; i < this.classes.length; ++i) {
            Klass klass2 = this.classes[i];
            if (klass2 == null || klass2.getInternalName().compareTo(name) != 0) continue;
            return klass2;
        }
        return null;
    }

    public boolean contains(Klass klass) {
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i] != klass) continue;
            return true;
        }
        return false;
    }

    private void checkWrite() {
        if (this.closed) {
            throw new IllegalStateException(this + " is closed");
        }
        if (!VM.isHosted() && !GC.inRam(this)) {
            throw new IllegalStoreException("trying to update read-only object: " + this);
        }
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Suite) {
            return this.name.equals(((Suite)other).name);
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public static Suite getSuite(String uri, boolean errorOnIOException) throws Error {
        Object root;
        ObjectMemory om = GC.lookupReadOnlyObjectMemoryBySourceURI(uri);
        if (om == null) {
            try {
                om = ObjectMemoryLoader.load((String)uri, (boolean)true).objectMemory;
            }
            catch (IOException e) {
                if (errorOnIOException) {
                    throw new Error("IO error while loading suite from '" + uri + "': " + e);
                }
                return null;
            }
        }
        if (!((root = om.getRoot()) instanceof Suite)) {
            throw new Error("object memory in '" + om.getURI() + "' does not contain a suite");
        }
        return (Suite)root;
    }

    public static Suite getSuite(String uri) throws Error {
        return Suite.getSuite(uri, true);
    }

    public String getConfiguration() {
        if (this.configuration == null) {
            return "complete symbolic information available";
        }
        return this.configuration;
    }

    public void save(DataOutputStream dos, String uri) throws IOException, OutOfMemoryError {
        this.save(dos, uri, VM.isBigEndian());
    }

    public ObjectMemory save(DataOutputStream dos, String uri, boolean bigEndian) throws IOException, OutOfMemoryError {
        ObjectMemorySerializer.ControlBlock cb = VM.copyObjectGraph(this);
        ObjectMemory parentMemory = null;
        if (!this.isBootstrap()) {
            parentMemory = this.parent.getReadOnlyObjectMemory();
        }
        ObjectMemorySerializer.save(dos, uri, cb, parentMemory, bigEndian);
        ObjectMemory objectMemory = VM.isHosted() ? this.saveHosted(uri, cb, parentMemory) : null;
        return objectMemory;
    }

    public void saveKlassMetadatas(DataOutputStream dos, String uri) throws IOException, OutOfMemoryError {
        this.saveKlassMetadatas(dos, uri, VM.isBigEndian());
    }

    public void saveKlassMetadatas(DataOutputStream dos, String uri, boolean bigEndian) throws IOException, OutOfMemoryError {
        int originalMemorySize = NativeUnsafe.getMemorySize();
        ObjectMemorySerializer.ControlBlock cb = VM.copyObjectGraph(this.metadatas);
        ObjectMemorySerializer.save(dos, uri, cb, this.getReadOnlyObjectMemory(), bigEndian);
        if (VM.isHosted()) {
            this.saveHosted(uri, cb, null);
        }
        NativeUnsafe.setMemorySize(originalMemorySize);
    }

    private ObjectMemory saveHosted(String uri, ObjectMemorySerializer.ControlBlock cb, ObjectMemory parentMemory) throws HostedPragma {
        Address start = parentMemory == null ? Address.zero() : parentMemory.getEnd();
        int hash = ObjectMemoryLoader.hash(cb.memory);
        ObjectMemory om = new ObjectMemory(start, cb.memory.length, uri, this, hash, parentMemory);
        GC.registerReadOnlyObjectMemory(om);
        return om;
    }

    public static String typeToString(int suiteType) {
        String[] names = new String[]{"application", "library", "extendable library", "debug", "metadata"};
        return names[suiteType];
    }

    public void close() {
        this.closed = true;
    }

    public Suite strip(int type, String name, Suite parent) {
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException();
        }
        Suite copy = new Suite(name, parent);
        if (type == 4) {
            copy.classes = new Klass[0];
            copy.metadatas = new KlassMetadata[this.metadatas.length];
            System.arraycopy(this.metadatas, 0, copy.metadatas, 0, this.metadatas.length);
        } else {
            copy.classes = new Klass[this.classes.length];
            System.arraycopy(this.classes, 0, copy.classes, 0, this.classes.length);
            if (this.noClassDefFoundErrorClassNames != null) {
                copy.noClassDefFoundErrorClassNames = new String[this.noClassDefFoundErrorClassNames.length];
                System.arraycopy(this.noClassDefFoundErrorClassNames, 0, copy.noClassDefFoundErrorClassNames, 0, this.noClassDefFoundErrorClassNames.length);
            }
            copy.resourceFiles = new ResourceFile[this.resourceFiles.length];
            System.arraycopy(this.resourceFiles, 0, copy.resourceFiles, 0, this.resourceFiles.length);
            copy.manifestProperties = new ManifestProperty[this.manifestProperties.length];
            System.arraycopy(this.manifestProperties, 0, copy.manifestProperties, 0, this.manifestProperties.length);
            copy.metadatas = KlassMetadata.strip(this, this.metadatas, type);
        }
        copy.updateConfiguration(type);
        return copy;
    }

    private void updateConfiguration(int type) {
        this.configuration = type == 3 ? "symbols not stripped" : "symbols stripped in " + Suite.typeToString(type) + " mode";
    }

    public void printAPI(PrintStream out) {
        out.println(".suite " + this.name);
        for (int i = 0; i != this.classes.length; ++i) {
            KlassMetadata metadata;
            Klass klass = this.classes[i];
            if (klass == null || klass.isSynthetic() || klass.isSourceSynthetic() || klass == Klass.STRING_OF_BYTES || Suite.isAnonymousOrPrivate(klass.getName()) || (metadata = this.getMetadata(klass)) == null) continue;
            out.println(".class " + klass.getName());
            this.printFieldsAPI(out, metadata, 1);
            this.printFieldsAPI(out, metadata, 0);
            this.printMethodsAPI(out, metadata, 3);
            this.printMethodsAPI(out, metadata, 2);
        }
    }

    private static boolean isAnonymousOrPrivate(String className) {
        int index = className.indexOf(36);
        if (index == -1) {
            return false;
        }
        if (className.length() > index + 1) {
            char c = className.charAt(index + 1);
            return c >= '0' && c <= '9';
        }
        return false;
    }

    private void printFieldsAPI(PrintStream out, KlassMetadata klass, int category) {
        SymbolParser symbols = klass.getSymbolParser();
        int count = symbols.getMemberCount(category);
        for (int i = 0; i != count; ++i) {
            int id = symbols.getMemberID(category, i);
            Field field = new Field(klass, id);
            if (field.isSourceSynthetic()) continue;
            out.println("    .field " + field.getName() + ' ' + field.getType().getSignature());
        }
    }

    private void printMethodsAPI(PrintStream out, KlassMetadata klass, int category) {
        SymbolParser symbols = klass.getSymbolParser();
        int count = symbols.getMemberCount(category);
        for (int i = 0; i != count; ++i) {
            int id = symbols.getMemberID(category, i);
            Method method = new Method(klass, id);
            if (method.isNative() && !VM.isLinkableNativeMethod(method.getFullyQualifiedName()) || method.isInterpreterInvoked() || method.isSourceSynthetic() || method.isClassInitializer()) continue;
            out.print("    .method " + method.getName() + " (");
            Klass[] types = method.getParameterTypes();
            for (int j = 0; j != types.length; ++j) {
                Klass type = types[j];
                out.print(type.getSignature());
            }
            out.println(")" + (method.isConstructor() ? "V" : method.getReturnType().getSignature()));
        }
    }
}

