/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.ByteBufferDecoder;
import com.sun.squawk.ByteBufferEncoder;
import com.sun.squawk.ClassFileConstantField;
import com.sun.squawk.ClassFileField;
import com.sun.squawk.ClassFileMethod;
import com.sun.squawk.Klass;
import com.sun.squawk.KlassMetadata;
import com.sun.squawk.Modifier;
import com.sun.squawk.VM;
import com.sun.squawk.pragma.PragmaException;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkVector;

final class SymbolParser
extends ByteBufferDecoder {
    static final int INSTANCE_FIELDS = 0;
    static final int STATIC_FIELDS = 1;
    static final int VIRTUAL_METHODS = 2;
    static final int STATIC_METHODS = 3;
    private static SymbolParser p1;
    private static SymbolParser p2;
    private static ByteBufferEncoder symbolsBuffer;
    private static ByteBufferEncoder membersBuffer;
    private static final Object PRUNE_LOCK;
    private Klass[] classTable;
    private short[] sectionStart = new short[4];
    private short[] sectionCount = new short[4];
    private short selection;
    private boolean sectionsParsed;
    private int modifiers;
    private int pragmas;
    private int offset;
    private short nameStart;
    private int nameLength;
    private short signatureStart;
    private short signatureCount;

    private SymbolParser(byte[] symbols, Klass[] classTable) {
        super(symbols, 0);
        this.classTable = classTable;
    }

    static SymbolParser create(byte[] symbols, Klass[] classTable) {
        if (p1 != null && SymbolParser.p1.buf == symbols) {
            return p1;
        }
        if (p2 == null) {
            p2 = new SymbolParser(symbols, classTable);
        }
        if (SymbolParser.p2.buf != symbols) {
            p2.setup(symbols, classTable);
        }
        SymbolParser temp = p2;
        p2 = p1;
        p1 = temp;
        return p1;
    }

    static SymbolParser create(byte[] symbols, Klass[] classTable, int id) {
        SymbolParser parser = SymbolParser.create(symbols, classTable);
        parser.select(id);
        return parser;
    }

    static void flush() {
        p2 = null;
        p1 = null;
        symbolsBuffer = null;
    }

    static synchronized byte[] createSymbols(ClassFileMethod[] virtualMethods, ClassFileMethod[] staticMethods, ClassFileField[] instanceFields, ClassFileField[] staticFields, SquawkVector types) {
        if (symbolsBuffer == null) {
            symbolsBuffer = new ByteBufferEncoder();
            membersBuffer = new ByteBufferEncoder();
        }
        symbolsBuffer.reset();
        int flags = 0;
        if (instanceFields.length != 0) {
            flags |= 1;
        }
        if (staticFields.length != 0) {
            flags |= 2;
        }
        if (virtualMethods.length != 0) {
            flags |= 4;
        }
        if (staticMethods.length != 0) {
            flags |= 8;
        }
        symbolsBuffer.addUnsignedByte(flags);
        SymbolParser.serializeFields(0, instanceFields, types);
        SymbolParser.serializeFields(1, staticFields, types);
        SymbolParser.serializeMethods(2, virtualMethods, types);
        SymbolParser.serializeMethods(3, staticMethods, types);
        return symbolsBuffer.toByteArray();
    }

    private static void serializeFields(int category, ClassFileField[] fields, SquawkVector types) {
        if (fields.length != 0) {
            symbolsBuffer.addUnsignedByte(category);
            for (int i = 0; i != fields.length; ++i) {
                ClassFileField field = fields[i];
                int modifiers = field.getModifiers();
                Klass type = field.getType();
                membersBuffer.reset();
                membersBuffer.addUnsignedShort(modifiers);
                membersBuffer.addUnsignedShort(field.getOffset());
                membersBuffer.addUtf8(field.getName());
                membersBuffer.addUnsignedShort(KlassMetadata.addSignatureType(types, type));
                if (Modifier.hasConstant(modifiers)) {
                    if (type.getSystemID() == 2) {
                        membersBuffer.addUtf8(((ClassFileConstantField)field).stringConstantValue);
                    } else {
                        long value = ((ClassFileConstantField)field).primitiveConstantValue;
                        int dataSize = type.getDataSize();
                        for (int bite = 0; bite != dataSize; ++bite) {
                            membersBuffer.addUnencodedByte((byte)value);
                            value >>= 8;
                        }
                    }
                }
                symbolsBuffer.add(membersBuffer);
            }
        }
    }

    private static void serializeMethods(int category, ClassFileMethod[] methods, SquawkVector types) {
        if (methods.length != 0) {
            symbolsBuffer.addUnsignedByte(category);
            for (int i = 0; i != methods.length; ++i) {
                ClassFileMethod method = methods[i];
                int pragmas = method.getPragmas();
                int mod = method.getModifiers();
                membersBuffer.reset();
                membersBuffer.addUnsignedShort(mod);
                membersBuffer.addUnsignedShort(method.getOffset());
                membersBuffer.addUtf8(method.getName());
                if (pragmas != 0) {
                    membersBuffer.addUnsignedShort(pragmas);
                }
                membersBuffer.addUnsignedShort(KlassMetadata.addSignatureType(types, method.getReturnType()));
                Klass[] parameterTypes = method.getParameterTypes();
                for (int j = 0; j != parameterTypes.length; ++j) {
                    membersBuffer.addUnsignedShort(KlassMetadata.addSignatureType(types, parameterTypes[j]));
                }
                symbolsBuffer.add(membersBuffer);
            }
        }
    }

    private static boolean retainMember(int type, int modifiers, Klass fieldType) {
        if (type == 1) {
            return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
        }
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPackagePrivate(modifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] strip(Klass klass, int type, SquawkVector types) {
        Object object = PRUNE_LOCK;
        synchronized (object) {
            if (symbolsBuffer == null) {
                symbolsBuffer = new ByteBufferEncoder();
                membersBuffer = new ByteBufferEncoder();
            }
            symbolsBuffer.reset();
            int flagsPos = SymbolParser.symbolsBuffer.count;
            symbolsBuffer.addUnsignedByte(0);
            int flags = 0;
            flags |= this.stripFields(klass, type, 0, types);
            flags |= this.stripFields(klass, type, 1, types);
            flags |= this.stripMethods(klass, type, 2, types);
            SymbolParser.symbolsBuffer.buffer[flagsPos] = (byte)(flags |= this.stripMethods(klass, type, 3, types));
            return symbolsBuffer.toByteArray();
        }
    }

    private int stripFields(Klass klass, int type, int category, SquawkVector types) {
        int count = this.getMemberCount(category);
        boolean keptAtLeastOne = false;
        if (count != 0) {
            for (int i = 0; i != count; ++i) {
                this.select(category, i);
                Klass fieldType = this.getSignatureType(this.getSignatureAt(0));
                if (!SymbolParser.retainMember(type, this.modifiers, fieldType) || VM.stripSymbols(klass.getField(i, category == 1))) continue;
                if (!keptAtLeastOne) {
                    symbolsBuffer.addUnsignedByte(category);
                    keptAtLeastOne = true;
                }
                membersBuffer.reset();
                membersBuffer.addUnsignedShort(this.modifiers);
                membersBuffer.addUnsignedShort(this.getOffset());
                membersBuffer.addUtf8(this.getName());
                if (Modifier.hasPragmas(this.modifiers)) {
                    membersBuffer.addUnsignedShort(0);
                }
                membersBuffer.addUnsignedShort(KlassMetadata.addSignatureType(types, fieldType));
                if (Modifier.hasConstant(this.modifiers)) {
                    if (!fieldType.isPrimitive()) {
                        membersBuffer.addUtf8(this.getStringConstantValue());
                    } else {
                        long value = this.getPrimitiveConstantValue();
                        int dataSize = fieldType.getDataSize();
                        for (int bite = 0; bite != dataSize; ++bite) {
                            membersBuffer.addUnencodedByte((byte)value);
                            value >>= 8;
                        }
                    }
                }
                symbolsBuffer.add(membersBuffer);
            }
        }
        return keptAtLeastOne ? 1 << category : 0;
    }

    private int stripMethods(Klass klass, int type, int category, SquawkVector types) {
        int count = this.getMemberCount(category);
        boolean keptAtLeastOne = false;
        if (count != 0) {
            for (int i = 0; i != count; ++i) {
                this.select(category, i);
                String name = this.getName();
                if (!PragmaException.isHosted(this.pragmas) && !PragmaException.isInterpreterInvoked(this.pragmas) && SymbolParser.retainMember(type, this.modifiers, null) && !VM.stripSymbols(klass.getMethod(i, category == 3))) {
                    if (!keptAtLeastOne) {
                        symbolsBuffer.addUnsignedByte(category);
                        keptAtLeastOne = true;
                    }
                    membersBuffer.reset();
                    membersBuffer.addUnsignedShort(this.modifiers);
                    membersBuffer.addUnsignedShort(this.getOffset());
                    membersBuffer.addUtf8(name);
                    if (Modifier.hasPragmas(this.modifiers)) {
                        membersBuffer.addUnsignedShort(this.pragmas);
                    }
                    int sigCount = this.getSignatureCount();
                    for (int j = 0; j != sigCount; ++j) {
                        membersBuffer.addUnsignedShort(KlassMetadata.addSignatureType(types, this.getSignatureType(this.getSignatureAt(j))));
                    }
                    symbolsBuffer.add(membersBuffer);
                    continue;
                }
                if (!Modifier.isAbstract(this.modifiers) && !klass.isInterface() || Modifier.isSuitePrivate(klass.getModifiers())) continue;
                throw new IllegalStateException("Can't strip method " + name + " because it is abstract in a class exported from a suite: " + klass);
            }
        }
        return keptAtLeastOne ? 1 << category : 0;
    }

    private int readTypeID() {
        return this.readUnsignedShort();
    }

    private void setup(byte[] symbols, Klass[] classTable) {
        this.buf = symbols;
        this.pos = 0;
        this.classTable = classTable;
        this.sectionsParsed = false;
        this.selection = (short)-1;
    }

    private int parseSection() {
        int lengthOrSection;
        byte section = this.buf[this.pos];
        ++this.pos;
        this.sectionStart[section] = (short)this.pos;
        this.sectionCount[section] = 0;
        while (this.pos < this.buf.length && ((lengthOrSection = this.buf[this.pos]) < 0 || lengthOrSection > 3)) {
            lengthOrSection = this.readUnsignedShort();
            this.pos += lengthOrSection;
            byte by = section;
            this.sectionCount[by] = (short)(this.sectionCount[by] + 1);
        }
        return section;
    }

    private void parseSections() {
        if (!this.sectionsParsed) {
            this.sectionStart[1] = 0;
            this.sectionCount[1] = 0;
            this.sectionStart[0] = 0;
            this.sectionCount[0] = 0;
            this.sectionStart[3] = 0;
            this.sectionCount[3] = 0;
            this.sectionStart[2] = 0;
            this.sectionCount[2] = 0;
            this.pos = 1;
            while (this.pos < this.buf.length) {
                this.parseSection();
            }
            this.sectionsParsed = true;
        }
    }

    private boolean isSectionEmpty(int category) {
        return (this.buf[0] & 1 << category) == 0;
    }

    int getMemberCount(int category) {
        if (this.buf == null || this.isSectionEmpty(category)) {
            return 0;
        }
        this.parseSections();
        return this.sectionCount[category];
    }

    int getMemberID(int category, int index) {
        this.parseSections();
        this.pos = this.sectionStart[category];
        while (index-- > 0) {
            int length = this.readUnsignedShort();
            this.pos += length;
        }
        return this.pos;
    }

    private void select(int category, int index) {
        int id = this.getMemberID(category, index);
        this.select(id);
    }

    private int select(int id) {
        int next = -1;
        if (this.selection != id) {
            this.selection = (short)id;
            this.pos = (short)id;
            int length = this.readUnsignedShort();
            next = this.pos + length;
            this.modifiers = this.readUnsignedShort();
            this.offset = this.readUnsignedShort();
            this.nameLength = this.readUnsignedShort();
            this.nameStart = (short)this.pos;
            for (int i = 0; i < this.nameLength; ++i) {
                this.readChar();
            }
            if (Modifier.hasPragmas(this.modifiers)) {
                this.pragmas = this.readUnsignedShort();
                if (PragmaException.isHosted(this.pragmas)) {
                    this.offset = -1;
                }
            } else {
                this.pragmas = 0;
            }
            this.signatureStart = (short)this.pos;
            if (Modifier.hasConstant(this.modifiers)) {
                this.readTypeID();
                this.signatureCount = (short)(1 + (next - this.pos));
            } else {
                this.signatureCount = 0;
                while (this.pos < next) {
                    this.readTypeID();
                    this.signatureCount = (short)(this.signatureCount + 1);
                }
            }
            this.pos = this.nameStart;
        } else {
            this.pos = (short)id;
            int length = this.readUnsignedShort();
            next = this.pos + length;
        }
        return next;
    }

    private boolean matchSignature(String name, Klass[] parameterTypes, Klass returnOrFieldType, int end, boolean hasPragmas) {
        int i;
        if (this.nameLength != name.length()) {
            return false;
        }
        this.nameStart = (short)this.pos;
        for (i = 0; i < this.nameLength; ++i) {
            char c = this.readChar();
            if (c == name.charAt(i)) continue;
            return false;
        }
        this.pragmas = hasPragmas ? this.readUnsignedShort() : 0;
        this.signatureStart = (short)this.pos;
        this.signatureCount = 1;
        if (this.getSignatureType(this.readTypeID()) == returnOrFieldType || name.equals("<init>") && returnOrFieldType == Klass.VOID) {
            if (Modifier.hasConstant(this.modifiers)) {
                this.signatureCount = (short)(this.signatureCount + (short)(end - this.pos));
                return true;
            }
            for (i = 0; i < parameterTypes.length && this.pos < end; ++i) {
                if (this.getSignatureType(this.readTypeID()) != parameterTypes[i]) {
                    return false;
                }
                this.signatureCount = (short)(this.signatureCount + 1);
            }
            return this.pos == end && this.signatureCount == parameterTypes.length + 1;
        }
        return false;
    }

    int lookupMember(int category, String name, Klass[] parameterTypes, Klass returnOrFieldType) {
        if (this.isSectionEmpty(category)) {
            return -1;
        }
        this.parseSections();
        int count = this.sectionCount[category];
        this.pos = this.sectionStart[category];
        for (int index = 0; index != count; ++index) {
            this.selection = (short)this.pos;
            int length = this.readUnsignedShort();
            int end = this.pos + length;
            this.modifiers = this.readUnsignedShort();
            this.offset = this.readUnsignedShort();
            this.nameLength = this.readUnsignedShort();
            if (this.matchSignature(name, parameterTypes, returnOrFieldType, end, Modifier.hasPragmas(this.modifiers))) {
                return this.selection;
            }
            this.pos = (short)end;
        }
        this.selection = (short)-1;
        return -1;
    }

    int lookupMethod(int category, int offset) {
        if (this.isSectionEmpty(category)) {
            return -1;
        }
        this.parseSections();
        int count = this.sectionCount[category];
        int id = this.pos = this.sectionStart[category];
        for (int index = 0; index != count; ++index) {
            int nextID = this.select(id);
            if (this.offset == offset && (category == 3 || category == 2)) {
                return id;
            }
            id = nextID;
        }
        this.selection = (short)-1;
        return -1;
    }

    int getModifiers() {
        return this.modifiers;
    }

    int getPragmas() {
        return this.pragmas;
    }

    int getOffset() {
        if (PragmaException.isHosted(this.pragmas)) {
            throw new Error("hosted methods have no entry in a method table");
        }
        return this.offset;
    }

    String getName() {
        char[] chars = new char[this.nameLength];
        this.pos = this.nameStart;
        for (int i = 0; i != chars.length; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    int getSignatureCount() {
        return this.signatureCount;
    }

    Klass getSignatureTypeAt(int index) {
        return this.getSignatureType(this.getSignatureAt(index));
    }

    private int getSignatureAt(int index) {
        this.pos = this.signatureStart;
        int res = -1;
        while (index-- >= 0) {
            res = this.readTypeID();
        }
        return res;
    }

    private Klass getSignatureType(int typeID) {
        return KlassMetadata.getSignatureType(this.classTable, typeID);
    }

    public long getPrimitiveConstantValue() {
        this.pos = this.signatureStart;
        int id = this.getSignatureType(this.readTypeID()).getSystemID();
        int dataSize = this.signatureCount - 1;
        long value = 0L;
        for (int bite = 0; bite != dataSize; ++bite) {
            int shift = bite * 8;
            long b = this.nextByte() & 0xFF;
            value |= b << shift;
        }
        switch (id) {
            case 6: 
            case 7: {
                return (byte)value;
            }
            case 8: {
                return (char)value;
            }
            case 9: {
                return (short)value;
            }
            case 10: 
            case 13: {
                return (int)value;
            }
            case 11: 
            case 14: {
                return value;
            }
        }
        Assert.shouldNotReachHere("[SymbolParser.java:1026] id = " + id);
        return 0L;
    }

    public String getStringConstantValue() {
        this.pos = this.signatureStart;
        int id = this.readTypeID();
        return this.readUtf8();
    }

    static {
        PRUNE_LOCK = new Object();
    }
}

