/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Isolate;
import com.sun.squawk.VMThread;

final class ThreadQueue {
    VMThread first;
    int count;

    ThreadQueue() {
    }

    void add(VMThread thread) {
        thread.setInQueue((byte)3);
        ++this.count;
        if (this.first == null) {
            this.first = thread;
        } else {
            byte thisPriority = thread.priority;
            if (this.first.priority < thisPriority) {
                thread.nextThread = this.first;
                this.first = thread;
            } else {
                VMThread last = this.first;
                while (last.nextThread != null && last.nextThread.priority >= thisPriority) {
                    last = last.nextThread;
                }
                thread.nextThread = last.nextThread;
                last.nextThread = thread;
            }
        }
    }

    int size() {
        return this.count;
    }

    VMThread next() {
        VMThread thread = this.first;
        VMThread skipped = null;
        while (thread != null && thread.getDebuggerSuspendCount() != 0) {
            skipped = thread;
            thread = thread.nextThread;
        }
        if (thread != null) {
            thread.setNotInQueue((byte)3);
            if (skipped == null) {
                this.first = thread.nextThread;
            } else {
                skipped.nextThread = thread.nextThread;
            }
            thread.nextThread = null;
            --this.count;
        }
        return thread;
    }

    void prune(Isolate isolate) {
        VMThread oldQueue = this.first;
        this.count = 0;
        this.first = null;
        while (oldQueue != null) {
            VMThread thread = oldQueue;
            oldQueue = oldQueue.nextThread;
            thread.nextThread = null;
            thread.setNotInQueue((byte)3);
            if (thread.getIsolate() != isolate) {
                this.add(thread);
                continue;
            }
            thread.setInQueue((byte)7);
            isolate.addToHibernatedRunThread(thread);
        }
    }
}

