/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Isolate;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;

final class TimerQueue {
    VMThread first;

    TimerQueue() {
    }

    void add(VMThread thread, long delta) {
        long time = VM.getTimeMillis() + delta;
        if (time < 0L) {
            time = Long.MAX_VALUE;
        }
        thread.time = time;
        if (this.first == null) {
            this.first = thread;
        } else if (this.first.time > time) {
            thread.nextTimerThread = this.first;
            this.first = thread;
        } else {
            VMThread last = this.first;
            while (last.nextTimerThread != null && last.nextTimerThread.time < time) {
                last = last.nextTimerThread;
            }
            thread.nextTimerThread = last.nextTimerThread;
            last.nextTimerThread = thread;
        }
    }

    VMThread next() {
        VMThread thread = this.first;
        if (thread == null || thread.time > VM.getTimeMillis()) {
            return null;
        }
        this.first = this.first.nextTimerThread;
        thread.nextTimerThread = null;
        thread.time = 0L;
        return thread;
    }

    void remove(VMThread thread) {
        if (this.first == null) {
            return;
        }
        if (thread.time == 0L) {
            return;
        }
        thread.time = 0L;
        if (thread == this.first) {
            this.first = thread.nextTimerThread;
            thread.nextTimerThread = null;
            return;
        }
        VMThread p = this.first;
        while (p.nextTimerThread != null) {
            if (p.nextTimerThread == thread) {
                p.nextTimerThread = thread.nextTimerThread;
                thread.nextTimerThread = null;
                return;
            }
            p = p.nextTimerThread;
        }
        VM.fatalVMError();
    }

    long nextDelta() {
        if (this.first != null) {
            long now = VM.getTimeMillis();
            if (now >= this.first.time) {
                return 0L;
            }
            long res = this.first.time - now;
            return res;
        }
        return Long.MAX_VALUE;
    }

    void prune(Isolate isolate) {
        block0: while (true) {
            VMThread t = this.first;
            while (t != null) {
                if (t.getIsolate() == isolate) {
                    long time = t.time - VM.getTimeMillis();
                    this.remove(t);
                    t.time = time;
                    isolate.addToHibernatedTimerThread(t);
                    continue block0;
                }
                t = t.nextTimerThread;
            }
            break;
        }
    }
}

