/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Offset;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.pragma.NativePragma;
import com.sun.squawk.util.IntHashtable;

public final class UWord {
    private final int value;
    private static IntHashtable pool;

    public static UWord fromPrimitive(int value) throws NativePragma {
        return UWord.get(value);
    }

    public int toPrimitive() throws NativePragma {
        return this.value;
    }

    public int toInt() throws NativePragma {
        return this.value;
    }

    public Offset toOffset() throws NativePragma {
        return Offset.fromPrimitive(this.value);
    }

    public static UWord zero() throws NativePragma {
        return UWord.get(0);
    }

    public static UWord max() throws NativePragma {
        return UWord.get(-1);
    }

    public UWord or(UWord word) throws NativePragma {
        return UWord.get(this.value | word.value);
    }

    public UWord and(UWord word) throws NativePragma {
        return UWord.get(this.value & word.value);
    }

    public boolean isZero() throws NativePragma {
        return this == UWord.zero();
    }

    public boolean isMax() throws NativePragma {
        return this == UWord.max();
    }

    public boolean eq(UWord word2) throws NativePragma {
        return this == word2;
    }

    public boolean ne(UWord word2) throws NativePragma {
        return this != word2;
    }

    public boolean lo(UWord word2) throws NativePragma {
        if (this.value >= 0 && word2.value >= 0) {
            return this.value < word2.value;
        }
        if (this.value < 0 && word2.value < 0) {
            return this.value < word2.value;
        }
        return this.value >= 0;
    }

    public boolean loeq(UWord word2) throws NativePragma {
        return this == word2 || this.lo(word2);
    }

    public boolean hi(UWord word2) throws NativePragma {
        return word2.lo(this);
    }

    public boolean hieq(UWord word2) throws NativePragma {
        return word2.loeq(this);
    }

    public int hashCode() throws HostedPragma {
        return this.value;
    }

    public String toString() throws HostedPragma {
        return "" + this.value;
    }

    private static UWord get(int value) throws HostedPragma {
        UWord instance;
        if (pool == null) {
            pool = new IntHashtable();
        }
        if ((instance = (UWord)pool.get(value)) == null) {
            instance = new UWord(value);
            try {
                pool.put(value, instance);
            }
            catch (OutOfMemoryError e) {
                throw new OutOfMemoryError("Failed to grow pool when adding " + value);
            }
        }
        return instance;
    }

    private UWord(int value) throws HostedPragma {
        this.value = value;
    }
}

