/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

public abstract class DataType {
    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static final class Location
    extends DataType {
        public static final int SIZE = 17;
        public final byte tag;
        public final ReferenceTypeID definingClass;
        public final MethodID method;
        public final long offset;

        public Location(int tag, ReferenceTypeID definingClass, MethodID method, long offset) {
            this.tag = (byte)tag;
            this.definingClass = definingClass;
            this.method = method;
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (o instanceof Location) {
                Location other = (Location)o;
                return other.tag == this.tag && other.definingClass == this.definingClass && other.method == this.method && this.offset == other.offset;
            }
            return false;
        }

        public int hashCode() {
            return this.tag + this.definingClass.id + this.method.id + (int)this.offset;
        }

        public String toString() {
            return "(" + this.tag + ")" + this.definingClass.id + "#" + this.method + "@" + this.offset;
        }
    }

    public static final class FrameID
    extends DataType {
        public static final int SIZE = 8;
        public final ObjectID threadID;
        public final int frame;

        public FrameID(ObjectID thread, int frame) {
            this.threadID = thread;
            this.frame = frame;
        }

        public boolean equals(Object o) {
            if (o instanceof FrameID) {
                FrameID other = (FrameID)o;
                return other.threadID == this.threadID && other.threadID == this.threadID;
            }
            return false;
        }

        public int hashCode() {
            return this.threadID.id + this.frame;
        }

        public String toString() {
            return "" + this.threadID.id + "#" + this.frame;
        }
    }

    public static final class FieldID
    extends DataType {
        public static final int SIZE = 8;
        public final int encoding;
        public final ReferenceTypeID definingClass;

        public FieldID(int tag, int offset, boolean isStatic, ReferenceTypeID definingClass) {
            this.encoding = FieldID.encode(tag, offset, isStatic);
            this.definingClass = definingClass;
        }

        public FieldID(int encoding, ReferenceTypeID definingClass) {
            this.encoding = encoding;
            this.definingClass = definingClass;
        }

        private static int encode(int tag, int offset, boolean isStatic) {
            int encoding = offset + 1;
            if (isStatic) {
                encoding = -encoding;
            }
            encoding = encoding << 8 | 0xFF & tag;
            return encoding;
        }

        public byte getTag() {
            return (byte)this.encoding;
        }

        public int getOffset() {
            return Math.abs(this.encoding >> 8) - 1;
        }

        public boolean isStatic() {
            return this.encoding < 0;
        }

        public boolean equals(Object o) {
            if (o instanceof FieldID) {
                FieldID other = (FieldID)o;
                return other.encoding == this.encoding && other.definingClass.equals(this.definingClass);
            }
            return false;
        }

        public int hashCode() {
            return this.definingClass.id + this.encoding;
        }

        public String toString() {
            return "" + (char)this.getTag() + this.getOffset() + "_" + (this.isStatic() ? "static" : "instance");
        }
    }

    public static final class MethodID
    extends FourByteID {
        public static final MethodID UNKNOWN = new MethodID(0, true);

        public MethodID(int offset, boolean isStatic) {
            super(MethodID.encode(offset, isStatic));
        }

        public MethodID(int encodedID) {
            super(encodedID);
        }

        private static int encode(int offset, boolean isStatic) {
            return isStatic ? -(offset + 1) : offset + 1;
        }

        public int getOffset() {
            return Math.abs(this.id) - 1;
        }

        public boolean isStatic() {
            return this.id < 0;
        }

        public String toString() {
            return "" + this.getOffset() + "_" + (this.isStatic() ? "static" : "virtual");
        }
    }

    public static final class ReferenceTypeID
    extends FourByteID {
        public static final ReferenceTypeID NULL = new ReferenceTypeID(0);

        public ReferenceTypeID(int id) {
            super(id);
        }
    }

    public static final class TaggedObjectID
    extends DataType {
        public final byte tag;
        public final int id;

        public TaggedObjectID(int tag, int id) {
            this.id = id;
            this.tag = (byte)tag;
        }

        public boolean equals(Object o) {
            if (o instanceof TaggedObjectID) {
                TaggedObjectID other = (TaggedObjectID)o;
                return other.id == this.id && other.tag == this.tag;
            }
            return false;
        }

        public int hashCode() {
            return this.tag + this.id;
        }

        public String toString() {
            return "(" + (char)this.tag + ")" + this.id;
        }
    }

    public static final class ObjectID
    extends FourByteID {
        public static final ObjectID NULL = new ObjectID(0);
        public static final ObjectID THREAD_GROUP = new ObjectID(-1);

        public ObjectID(int id) {
            super(id);
        }
    }

    static abstract class FourByteID
    extends DataType {
        public static final int SIZE = 4;
        public final int id;

        public FourByteID(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            return o.getClass() == this.getClass() && ((FourByteID)o).id == this.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return Integer.toString(this.id);
        }
    }
}

