/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.Debugger;
import com.sun.squawk.debugger.Log;
import java.io.IOException;

public final class EventNotifier {
    private Debugger.Event event;

    public synchronized void produceEvent(Debugger.Event evt, Consumer consumer) {
        if (Log.verbose()) {
            Log.log("Event producer (A): event produced: " + evt);
        }
        while (this.event != null) {
            if (consumer.isDone()) {
                this.notifyAll();
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        this.event = evt;
        if (Log.debug()) {
            Log.log("Event producer (B): notifying consumers: " + evt);
        }
        this.notifyAll();
        if (Log.debug()) {
            Log.log("Event producer (C): waiting for event consumer to finish: " + evt);
        }
        while (this.event == evt) {
            if (consumer.isDone()) {
                this.notifyAll();
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (Log.debug()) {
            Log.log("Event producer (D): resuming after: " + evt);
        }
    }

    public synchronized void consumeEvent(Consumer consumer) {
        block8: {
            if (Log.debug()) {
                Log.log("Event consumer (A): waiting for event");
            }
            while (this.event == null) {
                if (consumer.isDone()) {
                    this.event = null;
                    this.notifyAll();
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (Log.debug()) {
                Log.log("Event consumer (B): got event: " + this.event);
            }
            try {
                consumer.consumeEvent(this.event);
            }
            catch (IOException e) {
                if (!Log.info()) break block8;
                Log.log("IO error while notifying debugger of " + this.event + ": " + e);
            }
        }
        this.event = null;
        this.notifyAll();
    }

    public static interface Consumer {
        public boolean isDone();

        public void consumeEvent(Debugger.Event var1) throws IOException;
    }
}

