/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.Debugger;
import com.sun.squawk.debugger.EventRequestModifier;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.SDWPException;
import java.io.IOException;

public abstract class EventRequest {
    public final int kind;
    public final int suspendPolicy;
    public final int id;
    public final EventRequestModifier[] modifiers;

    public boolean matchKind(int eventKind) {
        return eventKind == this.kind;
    }

    public boolean matchModifiers(EventRequestModifier.Matcher matcher, Debugger.Event event) {
        for (int i = 0; i < this.modifiers.length; ++i) {
            if (this.modifiers[i].matches(matcher, event)) continue;
            return false;
        }
        return true;
    }

    public void registered() {
    }

    public void cleared() {
    }

    protected EventRequest(int kind, int suspendPolicy) {
        this.id = 0;
        this.kind = kind;
        this.suspendPolicy = suspendPolicy;
        this.modifiers = new EventRequestModifier[0];
    }

    protected EventRequest(int id, PacketInputStream in, int kind) throws SDWPException, IOException {
        this.id = id;
        this.kind = kind;
        this.suspendPolicy = in.readByte("suspendPolicy");
        int numMods = in.readInt("modifiers");
        this.modifiers = new EventRequestModifier[numMods];
        for (int i = 0; i < numMods; ++i) {
            this.modifiers[i] = this.readModifier(in, kind);
        }
    }

    protected EventRequestModifier readModifier(PacketInputStream in, int kind) throws SDWPException, IOException {
        EventRequestModifier modifier;
        byte modKind = in.readByte("modKind");
        switch (modKind) {
            case 1: {
                modifier = new EventRequestModifier.Count(in);
                break;
            }
            case 4: {
                modifier = new EventRequestModifier.ClassOnly(in, kind);
                break;
            }
            case 5: {
                modifier = new EventRequestModifier.ClassMatch(in, kind, false);
                break;
            }
            case 6: {
                modifier = new EventRequestModifier.ClassMatch(in, kind, true);
                break;
            }
            case 7: {
                modifier = new EventRequestModifier.LocationOnly(in, kind);
                break;
            }
            case 8: {
                modifier = new EventRequestModifier.ExceptionOnly(in, kind);
                break;
            }
            case 10: {
                modifier = new EventRequestModifier.Step(in, kind);
                break;
            }
            case 3: {
                modifier = new EventRequestModifier.ThreadOnly(in, kind);
                break;
            }
            default: {
                throw new SDWPException(99, "Unimplemented modkind " + modKind);
            }
        }
        return modifier;
    }

    public static String getNameForJDWPEventKind(int eventKind) {
        switch (eventKind) {
            case 1: {
                return "SINGLE_STEP";
            }
            case 2: {
                return "BREAKPOINT";
            }
            case 3: {
                return "FRAME_POP";
            }
            case 4: {
                return "EXCEPTION";
            }
            case 5: {
                return "USER_DEFINED";
            }
            case 6: {
                return "THREAD_START";
            }
            case 7: {
                return "THREAD_END";
            }
            case 8: {
                return "CLASS_PREPARE";
            }
            case 9: {
                return "CLASS_UNLOAD";
            }
            case 10: {
                return "CLASS_LOAD";
            }
            case 20: {
                return "FIELD_ACCESS";
            }
            case 21: {
                return "FIELD_MODIFICATION";
            }
            case 30: {
                return "EXCEPTION_CATCH";
            }
            case 40: {
                return "METHOD_ENTRY";
            }
            case 41: {
                return "METHOD_EXIT";
            }
            case 90: {
                return "VM_INIT";
            }
            case 99: {
                return "VM_DEATH";
            }
            case 100: {
                return "ISOLATE_DEATH";
            }
        }
        return Integer.toString(eventKind);
    }

    public static String getNameForJDWPSuspendPolicy(int policy) {
        switch (policy) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "THREAD";
            }
            case 2: {
                return "ALL";
            }
        }
        return Integer.toString(policy);
    }

    public String toString() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(36) + 1);
        String res = "<" + name + " id:" + this.id + " kind:" + EventRequest.getNameForJDWPEventKind(this.kind) + " suspendPolicy:" + EventRequest.getNameForJDWPSuspendPolicy(this.suspendPolicy) + " modifiers[" + this.modifiers.length + "]:{";
        for (int i = 0; i < this.modifiers.length; ++i) {
            if (this.modifiers[i] == null) continue;
            res = res + " " + this.modifiers[i].toString();
        }
        return res + " }>";
    }
}

