/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.Debugger;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.SDWPException;
import java.io.IOException;

public abstract class EventRequestModifier {
    public abstract boolean matches(Matcher var1, Debugger.Event var2);

    public static final class Step
    extends EventRequestModifier {
        public final DataType.ObjectID threadID;
        public final int size;
        public final int depth;

        public Step(PacketInputStream in, int kind) throws SDWPException, IOException {
            if (kind != 1) {
                throw new SDWPException(102, "Bad event kind for MOD_STEP: " + kind);
            }
            this.threadID = in.readObjectID("thread");
            int size = in.readInt("size");
            this.depth = in.readInt("depth");
            if (size != 1) {
                if (Log.info()) {
                    Log.log("warning: only source line stepping is supported");
                }
                size = 1;
            }
            this.size = size;
        }

        public boolean matches(Matcher matcher, Debugger.Event event) {
            return event.getThreadID().equals(this.threadID);
        }

        public String toString() {
            return "<MOD_STEP: threadID=" + this.threadID + ", size=" + this.size + ", depth=" + this.depth + ">";
        }
    }

    public static class ThreadOnly
    extends EventRequestModifier {
        public final DataType.ObjectID threadID;

        public ThreadOnly(PacketInputStream in, int kind) throws SDWPException, IOException {
            if (kind == 9) {
                throw new SDWPException(102, "Bad event kind for MOD_THREAD_ONLY: " + kind);
            }
            this.threadID = in.readObjectID("thread");
        }

        public boolean matches(Matcher matcher, Debugger.Event event) {
            return event.getThreadID().equals(this.threadID);
        }

        public String toString() {
            return "<MOD_THREAD_ONLY: threadID=" + this.threadID + ">";
        }
    }

    public static final class ExceptionOnly
    extends EventRequestModifier {
        public final DataType.ReferenceTypeID exceptionOrNull;
        public final boolean caught;
        public final boolean uncaught;

        public ExceptionOnly(PacketInputStream in, int kind) throws SDWPException, IOException {
            if (kind != 4) {
                throw new SDWPException(102, "Bad event kind for MOD_EXCEPTION_ONLY: " + kind);
            }
            this.exceptionOrNull = in.readReferenceTypeID("exceptionOrNull");
            this.caught = in.readBoolean("caught");
            this.uncaught = in.readBoolean("uncaught");
        }

        public boolean matches(Matcher matcher, Debugger.Event event) {
            return matcher.matches(this, event);
        }

        public String toString() {
            return "<MOD_EXCEPTION_ONLY: exceptionOrNull=" + this.exceptionOrNull + " caught=" + this.caught + " uncaught=" + this.uncaught + ">";
        }
    }

    public static final class LocationOnly
    extends EventRequestModifier {
        public final DataType.Location location;

        public LocationOnly(PacketInputStream in, int kind) throws SDWPException, IOException {
            switch (kind) {
                case 2: 
                case 4: 
                case 20: 
                case 21: {
                    break;
                }
                default: {
                    throw new SDWPException(102, "Bad event kind for MOD_LOCATION_ONLY: " + kind);
                }
            }
            this.location = in.readLocation("loc");
        }

        public boolean matches(Matcher matcher, Debugger.Event event) {
            return matcher.matches(this, event);
        }

        public String toString() {
            return "<MOD_LOCATION_ONLY: " + this.location + ">";
        }
    }

    public static final class ClassMatch
    extends EventRequestModifier {
        public static final int EQUALS = 1;
        public static final int STARTS_WITH = 2;
        public static final int ENDS_WITH = 3;
        public static final int CONTAINS = 4;
        public final String classPattern;
        public final String pattern;
        public final int matchKind;
        public final int eventKind;
        public final boolean exclude;

        public ClassMatch(PacketInputStream in, int kind, boolean exclude) throws SDWPException, IOException {
            this.exclude = exclude;
            switch (kind) {
                case 6: 
                case 7: {
                    throw new SDWPException(102, "Bad event kind for MOD_CLASS_MATCH: " + kind);
                }
            }
            String str = this.classPattern = in.readString("classPattern");
            int len = str.length();
            this.eventKind = kind;
            int tmpMatchKind = 1;
            if (len == 0) {
                if (Log.info()) {
                    Log.log("This is odd: debugger wants us to match a class event if the name " + (exclude ? "is" : "is not") + " the empty string. OK.");
                }
            } else if (str.charAt(0) == '*') {
                if (str.charAt(len - 1) == '*') {
                    tmpMatchKind = 4;
                    str = str.substring(1, len - 1);
                } else {
                    tmpMatchKind = 3;
                    str = str.substring(1);
                }
            } else if (str.charAt(len - 1) == '*') {
                tmpMatchKind = 2;
                str = str.substring(0, len - 1);
            }
            this.matchKind = tmpMatchKind;
            this.pattern = str;
        }

        public boolean matches(Matcher matcher, Debugger.Event event) {
            return matcher.matches(this, event);
        }

        public String toString() {
            return (!this.exclude ? "<MOD_CLASS_MATCH: " : "<MOD_CLASS_EXCLUDE: ") + this.classPattern + "\">";
        }
    }

    public static final class ClassOnly
    extends EventRequestModifier {
        public final int eventKind;
        public final DataType.ReferenceTypeID clazz;

        public ClassOnly(PacketInputStream in, int kind) throws SDWPException, IOException {
            switch (kind) {
                case 6: 
                case 7: 
                case 9: {
                    throw new SDWPException(102, "Bad event kind for MOD_CLASS_ONLY: " + kind);
                }
            }
            this.clazz = in.readReferenceTypeID("clazz");
            this.eventKind = kind;
        }

        public boolean matches(Matcher matcher, Debugger.Event event) {
            return matcher.matches(this, event);
        }

        public String toString() {
            return "<MOD_CLASS_ONLY: clazz=" + this.clazz + ">";
        }
    }

    public static final class Count
    extends EventRequestModifier {
        private int count;

        public Count(PacketInputStream in) throws SDWPException, IOException {
            this.count = in.readInt("count");
        }

        public boolean matches(Matcher matcher, Debugger.Event event) {
            return --this.count == 0;
        }

        public String toString() {
            return "<MOD_COUNT: count=" + this.count + ">";
        }
    }

    public static interface Matcher {
        public boolean matches(ClassMatch var1, Debugger.Event var2);

        public boolean matches(ClassOnly var1, Debugger.Event var2);

        public boolean matches(ExceptionOnly var1, Debugger.Event var2);

        public boolean matches(LocationOnly var1, Debugger.Event var2);
    }
}

