/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.util.DataInputUTF8Decoder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public final class PacketInputStream {
    private final DataInputStream dis;

    public PacketInputStream(DataInputStream dis) {
        this.dis = dis;
    }

    public DataInputStream getInputStream() {
        return this.dis;
    }

    public byte readByte(String s) throws IOException {
        byte value = this.dis.readByte();
        if (s != null && Log.verbose()) {
            Log.log("in[byte]      " + s + "=" + value);
        }
        return value;
    }

    public boolean readBoolean(String s) throws IOException {
        boolean value = this.dis.readBoolean();
        if (s != null && Log.verbose()) {
            Log.log("in[boolean]   " + s + "=" + value);
        }
        return value;
    }

    public char readChar(String s) throws IOException {
        char value = this.dis.readChar();
        if (s != null && Log.verbose()) {
            Log.log("in[char]      " + s + "=" + value);
        }
        return value;
    }

    public short readShort(String s) throws IOException {
        short value = this.dis.readShort();
        if (s != null && Log.verbose()) {
            Log.log("in[short]     " + s + "=" + value);
        }
        return value;
    }

    public int readInt(String s) throws IOException {
        int value = this.dis.readInt();
        if (s != null && Log.verbose()) {
            Log.log("in[int]       " + s + "=" + value);
        }
        return value;
    }

    public long readLong(String s) throws IOException {
        long value = this.dis.readLong();
        if (s != null && Log.verbose()) {
            Log.log("in[long]      " + s + "=" + value);
        }
        return value;
    }

    public float readFloat(String s) throws IOException {
        int value = this.dis.readInt();
        if (s != null && Log.verbose()) {
            Log.log("in[float]     " + s + "=" + value);
        }
        return Float.intBitsToFloat(value);
    }

    public double readDouble(String s) throws IOException {
        long value = this.dis.readLong();
        if (s != null && Log.verbose()) {
            Log.log("in[double]    " + s + "=" + value);
        }
        return Double.longBitsToDouble(value);
    }

    public String readString(String s) throws IOException {
        String value = DataInputUTF8Decoder.readUTF((DataInput)this.dis, false, false);
        if (s != null && Log.verbose()) {
            Log.log("in[string]    " + s + "=" + value);
        }
        return value;
    }

    public DataType.ObjectID readObjectID(String s) throws IOException {
        DataType.ObjectID value = new DataType.ObjectID(this.dis.readInt());
        if (s != null && Log.verbose()) {
            Log.log("in[object]    " + s + "=" + value);
        }
        return value;
    }

    public DataType.TaggedObjectID readTaggedObjectID(String s) throws IOException {
        DataType.TaggedObjectID value = new DataType.TaggedObjectID(this.dis.readByte(), this.dis.readInt());
        if (s != null && Log.verbose()) {
            Log.log("in[t-object]  " + s + "=" + value);
        }
        return value;
    }

    public DataType.ReferenceTypeID readReferenceTypeID(String s) throws IOException {
        DataType.ReferenceTypeID value = new DataType.ReferenceTypeID(this.dis.readInt());
        if (s != null && Log.verbose()) {
            Log.log("in[type]      " + s + "=" + value);
        }
        return value;
    }

    public DataType.MethodID readMethodID(String s) throws IOException {
        int encID = this.dis.readInt();
        DataType.MethodID value = new DataType.MethodID(encID);
        if (s != null && Log.verbose()) {
            Log.log("in[method]    " + s + "=" + value);
        }
        return value;
    }

    public DataType.FrameID readFrameID(String s) throws IOException {
        DataType.FrameID value = new DataType.FrameID(this.readObjectID(null), this.dis.readInt());
        if (s != null && Log.verbose()) {
            Log.log("in[frame]     " + s + "=" + value);
        }
        return value;
    }

    public DataType.FieldID readFieldID(String s) throws IOException {
        DataType.ReferenceTypeID definingClass = this.readReferenceTypeID("definingClass");
        int encID = this.dis.readInt();
        DataType.FieldID value = new DataType.FieldID(encID, definingClass);
        if (s != null && Log.verbose()) {
            Log.log("in[field]     " + s + "=" + value);
        }
        return value;
    }

    public DataType.Location readLocation(String s) throws IOException {
        DataType.Location value = new DataType.Location(this.dis.readByte(), this.readReferenceTypeID(null), this.readMethodID(null), this.dis.readLong());
        if (s != null && Log.verbose()) {
            Log.log("in[location]  " + s + "=" + value);
        }
        return value;
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public void close() throws IOException {
        this.dis.close();
    }
}

