/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger;

import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ReplyPacket
extends Packet {
    private int errorCode;

    public ReplyPacket(CommandPacket command, int errorCode) {
        super(command.getID());
        this.errorCode = errorCode;
    }

    public ReplyPacket(int id, int dataLength, DataInputStream data, int errorCode) throws IOException {
        super(id, dataLength, data);
        this.errorCode = errorCode;
    }

    public void updateErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    protected void writeFields(DataOutputStream dos) throws IOException {
        dos.writeShort(this.errorCode);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getFlags() {
        return 128;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ReplyPacket[id=").append(this.getID()).append(",size=").append(this.getSize());
        if (this.errorCode != 0) {
            buf.append(",error=").append(this.errorCode);
        }
        buf.append("]");
        if (Log.debug()) {
            this.appendData(buf);
        }
        return buf.toString();
    }
}

