/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.flash;

import com.sun.squawk.Address;
import com.sun.squawk.VM;
import com.sun.squawk.flash.IMemoryHeapBlock;
import com.sun.squawk.flash.INorFlashMemoryHeap;
import com.sun.squawk.flash.INorFlashMemoryHeapScanner;
import com.sun.squawk.flash.INorFlashSectorState;
import com.sun.squawk.flash.INorFlashSectorStateList;
import com.sun.squawk.flash.MemoryHeapBlock;
import com.sun.squawk.flash.NorFlashSectorState;
import com.sun.squawk.flash.NorFlashSectorStateList;
import com.sun.squawk.peripheral.INorFlashSector;
import com.sun.squawk.peripheral.INorFlashSectorAllocator;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.Comparer;
import com.sun.squawk.util.UnexpectedException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public class NorFlashMemoryHeap
implements INorFlashMemoryHeap {
    public static final byte ERASED_VALUE = -1;
    public static final byte ERASED_VALUE_XOR = 0;
    public static final int BLOCK_HEADER_SIZE = 6;
    public static final byte[] BLOCK_FOOTER = new byte[]{0, 0};
    protected INorFlashSectorState[] sectorStates;
    protected INorFlashSectorState currentSectorState;
    protected int erasedSequenceCurrentValue;
    protected INorFlashSectorStateList inUseSectorStateList;
    protected INorFlashSectorStateList toBeErasedSectorStateList;
    protected boolean hasScannedBlocks;
    static /* synthetic */ Class class$com$sun$squawk$peripheral$INorFlashSectorAllocator;

    public static Vector getNorFlashSectors(int purpose) {
        INorFlashSector[] allFlashMemorySectors;
        INorFlashSectorAllocator allocator = (INorFlashSectorAllocator)VM.getPeripheralRegistry().getSingleton(class$com$sun$squawk$peripheral$INorFlashSectorAllocator == null ? (class$com$sun$squawk$peripheral$INorFlashSectorAllocator = NorFlashMemoryHeap.class$("com.sun.squawk.peripheral.INorFlashSectorAllocator")) : class$com$sun$squawk$peripheral$INorFlashSectorAllocator);
        if (allocator == null) {
            throw new IllegalStateException("No INorFlashSectorAllocator available");
        }
        try {
            allFlashMemorySectors = allocator.getInitialSectors(purpose);
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        Vector userSectors = new Vector(allFlashMemorySectors.length);
        int max = allFlashMemorySectors.length;
        for (int i = 0; i < max; ++i) {
            userSectors.addElement(allFlashMemorySectors[i]);
        }
        return userSectors;
    }

    protected NorFlashMemoryHeap() {
    }

    public NorFlashMemoryHeap(INorFlashSectorState[] sectorStates) {
        this.init(sectorStates);
    }

    public NorFlashMemoryHeap(int purpose) {
        Vector userSectors = NorFlashMemoryHeap.getNorFlashSectors(purpose);
        if (userSectors.size() == 0) {
            throw new RuntimeException("No user purposed flash memory found.");
        }
        INorFlashSectorState[] sectorStates = new INorFlashSectorState[userSectors.size()];
        int max = userSectors.size();
        for (int i = 0; i < max; ++i) {
            INorFlashSector sector = (INorFlashSector)userSectors.elementAt(i);
            sectorStates[i] = new NorFlashSectorState(sector);
        }
        this.init(sectorStates);
    }

    public void forceEraseAll() {
        for (int i = 0; i < this.sectorStates.length; ++i) {
            try {
                this.sectorStates[i].forceErase();
                continue;
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    public void freeBlockAt(Address address) throws RecordStoreException {
        INorFlashSectorState sectorState = this.getSectorContaining(address);
        int offset = address.diff(sectorState.getStartAddress()).toInt() + 6 - 2;
        sectorState.writeBytes(offset, BLOCK_FOOTER, 0, 2);
        sectorState.decrementMallocedCount();
        sectorState.incrementFreedBlockCount();
        if (this.hasScannedBlocks && sectorState != this.currentSectorState && sectorState.getOwningList() != this.toBeErasedSectorStateList && sectorState.getAllocatedBlockCount() == 0) {
            this.toBeErasedSectorStateList.addLast(sectorState);
        }
    }

    public IMemoryHeapBlock getBlockAt(Address address) throws RecordStoreException {
        INorFlashSectorState sectorState = this.getSectorContaining(address);
        if (sectorState == null) {
            throw new RecordStoreException("Address specified is outside my valid range");
        }
        int offset = address.diff(sectorState.getStartAddress()).toInt();
        if (offset >= sectorState.getWriteHeadPosition()) {
            return null;
        }
        MemoryHeapBlock block = new MemoryHeapBlock();
        if (this.getBlockAt(block, sectorState, offset) && block.isAllocated) {
            return block;
        }
        return null;
    }

    protected boolean getBlockAt(IMemoryHeapBlock block, INorFlashSectorState sectorState, int offset) throws RecordStoreException {
        try {
            if (offset + 6 >= sectorState.getSize()) {
                return false;
            }
            block.setAddress(sectorState.getStartAddress().add(offset));
            block.setLength(6);
            byte[] bytes = block.getBytes();
            sectorState.readBytes(offset, bytes, 0, 6);
            if (bytes[0] == -1) {
                return false;
            }
            DataInputStream input = block.getDataInputStream();
            int blockSize = input.readInt();
            int blockSizeWithPadding = blockSize + (blockSize & 1) + 2;
            if (blockSize < 0 || blockSizeWithPadding > sectorState.getSize() - offset) {
                throw new RecordStoreException("Data seems corrupted, read block size bigger than sectorState");
            }
            block.setNextOffset(offset + 6 + blockSizeWithPadding);
            input.readByte();
            if (input.readByte() == -1) {
                block.setIsAllocated(true);
                try {
                    block.setLength(blockSizeWithPadding);
                }
                catch (OutOfMemoryError e) {
                    block.resetBytes();
                    throw new RecordStoreException("OutOfMemoryError on reading a block from the heap, something is likely wrong");
                }
                block.setLength(blockSize);
                bytes = block.getBytes();
                sectorState.readBytes(offset + 6, bytes, 0, blockSizeWithPadding);
                if (bytes[blockSizeWithPadding - 1] != 0) {
                    block.setIsAllocated(false);
                    return true;
                }
            } else {
                block.setIsAllocated(false);
            }
            return true;
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    public long getErasedSequenceCurrentValue() {
        return this.erasedSequenceCurrentValue;
    }

    public INorFlashSectorState getSectorContaining(Address address) {
        int left = 0;
        int right = this.sectorStates.length - 1;
        if (address.lo(this.sectorStates[left].getStartAddress())) {
            return null;
        }
        if (address.hieq(this.sectorStates[right].getEndAddress())) {
            return null;
        }
        while (true) {
            int index;
            INorFlashSectorState sectorState;
            if (address.lo((sectorState = this.sectorStates[index = left + (right - left) / 2]).getStartAddress())) {
                right = index - 1;
                continue;
            }
            if (address.lo(sectorState.getEndAddress())) {
                return sectorState;
            }
            left = index + 1;
        }
    }

    public int getSizeAvailable() throws RecordStoreException {
        final int[] used = new int[1];
        this.scanBlocks(new INorFlashMemoryHeapScanner(){

            public void reScanBlock(Address oldAddress, Address newAddress, IMemoryHeapBlock block) throws RecordStoreException {
                throw new RuntimeException("System error");
            }

            public void scanBlock(IMemoryHeapBlock block) throws RecordStoreException {
                used[0] = used[0] + block.getLength();
            }
        });
        int total = 0;
        int max = this.sectorStates.length;
        for (int i = 0; i < max; ++i) {
            INorFlashSectorState sectorState = this.sectorStates[i];
            total += sectorState.getSize();
        }
        return total - used[0];
    }

    public int incrementErasedSequence() {
        return ++this.erasedSequenceCurrentValue;
    }

    protected void init(INorFlashSectorState[] sectorStates) {
        Arrays.sort(sectorStates, new Comparer(){

            public int compare(Object a, Object b) {
                Address bStart;
                Address aStart = ((INorFlashSectorState)a).getStartAddress();
                if (aStart.eq(bStart = ((INorFlashSectorState)b).getStartAddress())) {
                    return 0;
                }
                if (aStart.lo(bStart)) {
                    return -1;
                }
                return 1;
            }
        });
        this.sectorStates = sectorStates;
        this.erasedSequenceCurrentValue = 0;
        this.inUseSectorStateList = new NorFlashSectorStateList();
        this.toBeErasedSectorStateList = new NorFlashSectorStateList();
    }

    protected void makeRoomToWrite(int entrySize, INorFlashMemoryHeapScanner scanner) throws RecordStoreException {
        INorFlashSectorState inUseSector;
        if (this.currentSectorState != null && this.currentSectorState.hasAvailable(entrySize)) {
            return;
        }
        if (this.currentSectorState != null) {
            INorFlashSectorStateList list = this.currentSectorState.getAllocatedBlockCount() == 0 ? this.toBeErasedSectorStateList : this.inUseSectorStateList;
            list.addLast(this.currentSectorState);
            this.currentSectorState = null;
        }
        if (this.sectorStates.length < 2) {
            this.currentSectorState = this.toBeErasedSectorStateList.consumeFirst();
            if (this.currentSectorState == null) {
                throw new RecordStoreFullException("Case of 1 sector does not currently support GC");
            }
            this.currentSectorState.erase(this.incrementErasedSequence());
            this.makeRoomToWrite(entrySize, scanner);
            return;
        }
        if (this.toBeErasedSectorStateList.size() > 1) {
            INorFlashSectorState sectorState;
            this.currentSectorState = sectorState = this.toBeErasedSectorStateList.consumeFirst();
            sectorState.erase(this.incrementErasedSequence());
            if (sectorState.hasAvailable(entrySize)) {
                return;
            }
            throw new RecordStoreFullException("Sectors is " + sectorState.getSize() + " is not large enough to hold an entry of size " + entrySize);
        }
        for (inUseSector = this.inUseSectorStateList.getFirst(); inUseSector != null && inUseSector.getFreedBlockCount() == 0; inUseSector = inUseSector.getNextSector()) {
        }
        if (inUseSector == null) {
            throw new RecordStoreFullException("There are no sectorStates with freed blocks");
        }
        if (inUseSector != null) {
            this.inUseSectorStateList.remove(inUseSector);
            this.currentSectorState = this.toBeErasedSectorStateList.consumeFirst();
            this.currentSectorState.erase(this.incrementErasedSequence());
            inUseSector.resetHead();
            int offset = inUseSector.getWriteHeadPosition();
            Address startAddress = inUseSector.getStartAddress();
            MemoryHeapBlock block = new MemoryHeapBlock();
            while (this.getBlockAt(block, inUseSector, offset)) {
                if (block.isAllocated) {
                    this.writeBlock(block, scanner, startAddress.add(offset));
                }
                offset = block.getNextBlockOffset();
            }
            inUseSector.removeErasedHeader();
            this.toBeErasedSectorStateList.addLast(inUseSector);
            this.makeRoomToWrite(entrySize, scanner);
            return;
        }
        throw new RecordStoreFullException("How to handle this case ?");
    }

    public Address allocateAndWriteBlock(byte[] bytes, int offset, int length, INorFlashMemoryHeapScanner scanner) throws RecordStoreException {
        MemoryHeapBlock block = new MemoryHeapBlock();
        block.setBytes(bytes, offset, length);
        return this.writeBlock(block, scanner, Address.zero());
    }

    public void scanBlocks(INorFlashMemoryHeapScanner scanner) throws RecordStoreException {
        Object[] sectorStatesSortedBySequence = new INorFlashSectorState[this.sectorStates.length];
        System.arraycopy(this.sectorStates, 0, sectorStatesSortedBySequence, 0, this.sectorStates.length);
        Arrays.sort(sectorStatesSortedBySequence, new Comparer(){

            public int compare(Object a, Object b) {
                return (int)(((INorFlashSectorState)a).getSequence() - ((INorFlashSectorState)b).getSequence());
            }
        });
        int maxI = sectorStatesSortedBySequence.length;
        int lastI = sectorStatesSortedBySequence.length - 1;
        for (int i = 0; i < maxI; ++i) {
            Object sectorState = sectorStatesSortedBySequence[i];
            if (!sectorState.hasErasedHeader()) {
                this.toBeErasedSectorStateList.addLast((INorFlashSectorState)sectorState);
                continue;
            }
            sectorState.resetHead();
            int offset = sectorState.getWriteHeadPosition();
            MemoryHeapBlock block = new MemoryHeapBlock();
            while (this.getBlockAt(block, (INorFlashSectorState)sectorState, offset)) {
                if (block.isAllocated()) {
                    sectorState.incrementAllocatedBlockCount();
                    if (scanner != null) {
                        scanner.scanBlock(block);
                    }
                } else {
                    sectorState.incrementFreedBlockCount();
                }
                offset = block.getNextBlockOffset();
            }
            sectorState.setWriteHeadPosition(offset);
            if (i == lastI) {
                this.currentSectorState = sectorState;
                continue;
            }
            if (sectorState.getAllocatedBlockCount() == 0) {
                this.toBeErasedSectorStateList.addLast((INorFlashSectorState)sectorState);
                continue;
            }
            this.inUseSectorStateList.addLast((INorFlashSectorState)sectorState);
        }
        this.hasScannedBlocks = true;
    }

    protected Address writeBlock(IMemoryHeapBlock block, INorFlashMemoryHeapScanner scanner, Address oldAddress) throws RecordStoreException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(6);
        DataOutputStream output = new DataOutputStream(bytesOut);
        int blockLength = block.getLength();
        try {
            output.writeInt(blockLength);
            output.writeByte(-1);
            output.writeByte(-1);
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        if (oldAddress.isZero()) {
            if (!this.hasScannedBlocks) {
                this.scanBlocks(null);
            }
            this.makeRoomToWrite(bytesOut.size() + blockLength + (blockLength & 1) + 2, scanner);
        }
        block.setAddress(this.currentSectorState.getWriteHeadAddress());
        this.currentSectorState.writeBytes(bytesOut.toByteArray(), 0, bytesOut.size());
        if ((blockLength & 1) == 1) {
            block.getBytes()[block.getOffset() + blockLength] = 0;
        }
        this.currentSectorState.writeBytes(block.getBytes(), block.getOffset(), blockLength + (blockLength & 1));
        this.currentSectorState.writeBytes(BLOCK_FOOTER, 0, 2);
        this.currentSectorState.incrementAllocatedBlockCount();
        if (!oldAddress.isZero()) {
            this.freeBlockAt(oldAddress);
            scanner.reScanBlock(oldAddress, block.getAddress(), block);
        }
        return block.getAddress();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

