/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.channel;

import com.sun.squawk.VM;
import com.sun.squawk.io.j2me.channel.Protocol;
import com.sun.squawk.util.DataInputUTF8Decoder;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ChannelInputStream
extends InputStream
implements DataInput {
    Protocol parent;
    int channelID;

    public ChannelInputStream(Protocol parent) throws IOException {
        this.parent = parent;
        this.channelID = parent.channelID.id;
        VM.execIO(16, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public void close() throws IOException {
        if (this.channelID != -1) {
            VM.execIO(17, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
            this.channelID = -1;
            this.parent.decrementCount();
        }
    }

    public int read() throws IOException {
        return VM.execIO(19, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public int readUnsignedShort() throws IOException {
        return VM.execIO(20, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public int readInt() throws IOException {
        return VM.execIO(21, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public long readLong() throws IOException {
        return VM.execIOLong(22, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        return VM.execIO(23, this.channelID, off, len, 0, 0, 0, 0, null, b);
    }

    public long skip(long n) throws IOException {
        return VM.execIO(24, this.channelID, (int)(n >>> 32), (int)n, 0, 0, 0, 0, null, null);
    }

    public int available() throws IOException {
        return VM.execIO(25, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public void mark(int readlimit) {
        try {
            VM.execIO(26, this.channelID, readlimit, 0, 0, 0, 0, 0, null, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        VM.execIO(27, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public boolean markSupported() {
        try {
            int res = VM.execIO(26, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
            return res != 0;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)this.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readUTF() throws IOException {
        return DataInputUTF8Decoder.readUTF((DataInput)this, false, true);
    }
}

