/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.channel;

import com.sun.squawk.VM;
import com.sun.squawk.io.j2me.channel.Protocol;
import com.sun.squawk.util.DataOutputUTF8Encoder;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class ChannelOutputStream
extends OutputStream
implements DataOutput {
    Protocol parent;
    int channelID;

    public ChannelOutputStream(Protocol parent) throws IOException {
        this.parent = parent;
        this.channelID = parent.channelID.id;
        VM.execIO(29, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public void flush() throws IOException {
        VM.execIO(30, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
    }

    public void close() throws IOException {
        VM.execIO(31, this.channelID, 0, 0, 0, 0, 0, 0, null, null);
        this.channelID = -1;
        this.parent.decrementCount();
    }

    public void write(int v) throws IOException {
        VM.execIO(32, this.channelID, v, 0, 0, 0, 0, 0, null, null);
    }

    public void writeShort(int v) throws IOException {
        VM.execIO(33, this.channelID, v, 0, 0, 0, 0, 0, null, null);
    }

    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        VM.execIO(34, this.channelID, v, 0, 0, 0, 0, 0, null, null);
    }

    public void writeLong(long v) throws IOException {
        VM.execIO(35, this.channelID, (int)(v >>> 32), (int)v, 0, 0, 0, 0, null, null);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        VM.execIO(36, this.channelID, off, len, 0, 0, 0, 0, b, null);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean v) throws IOException {
        if (v) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public final void writeUTF(String str) throws IOException {
        DataOutputUTF8Encoder.writeUTF(str, this, true);
    }
}

