/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.channel;

import com.sun.squawk.VM;
import com.sun.squawk.io.ConnectionBase;
import com.sun.squawk.io.j2me.channel.ChannelInputStream;
import com.sun.squawk.io.j2me.channel.ChannelOutputStream;
import com.sun.squawk.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class Protocol
extends ConnectionBase
implements StreamConnection,
StreamConnectionNotifier {
    ChannelID channelID;
    String protocolAndName;
    int useCount = 0;

    public Protocol() {
    }

    private Protocol(int channelID) {
        this.channelID = new ChannelID(channelID, this);
        ++this.useCount;
    }

    public Connection open(String protocol, String name, int mode, boolean timeouts) throws IOException {
        if (protocol == null || name == null) {
            throw new NullPointerException();
        }
        this.protocolAndName = protocol + ":" + name;
        this.channelID = new ChannelID(VM.getChannel(1), this);
        ++this.useCount;
        VM.execIO(13, this.channelID.id, mode, timeouts ? 1 : 0, 0, 0, 0, 0, this.protocolAndName, null);
        return this;
    }

    public InputStream openInputStream() throws IOException {
        ++this.useCount;
        ChannelInputStream is = new ChannelInputStream(this);
        return is;
    }

    public OutputStream openOutputStream() throws IOException {
        ++this.useCount;
        return new ChannelOutputStream(this);
    }

    public StreamConnection acceptAndOpen() throws IOException {
        int newChan = VM.execIO(15, this.channelID.id, 0, 0, 0, 0, 0, 0, null, null);
        return new Protocol(newChan);
    }

    public synchronized void close() throws IOException {
        VM.execIO(14, this.channelID.id, 0, 0, 0, 0, 0, 0, null, null);
        this.decrementCount();
    }

    void decrementCount() {
        if (this.useCount > 0) {
            --this.useCount;
            if (this.useCount == 0) {
                this.channelID.free();
            }
        }
    }

    static final class ChannelID
    extends WeakReference {
        int id;
        ChannelID next;
        String protocolAndName;
        static ChannelID channelIDs;
        static Thread channelIDFinalizer;
        static Object channelIDFinalizerLock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void registerChannelID(ChannelID id) {
            Object object = channelIDFinalizerLock;
            synchronized (object) {
                Assert.always(id.next == null);
                id.next = channelIDs;
                channelIDs = id;
            }
        }

        ChannelID(int id, Protocol channel) {
            super(channel);
            Assert.always(id != 0);
            this.id = id;
            this.protocolAndName = channel.protocolAndName;
            ChannelID.registerChannelID(this);
        }

        void free() {
            if (this.id != 0) {
                try {
                    VM.freeChannel(this.id);
                }
                catch (IOException ioe) {
                    System.err.println(ioe);
                }
                this.id = 0;
            }
        }

        static {
            channelIDFinalizerLock = new Object();
        }

        static class Finalizer
        extends Thread {
            Finalizer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Object object = channelIDFinalizerLock;
                    synchronized (object) {
                        ChannelID head = null;
                        ChannelID c = channelIDs;
                        channelIDs = null;
                        while (c != null) {
                            ChannelID next = c.next;
                            if (c.get() == null) {
                                c.free();
                            } else if (c.id != 0) {
                                c.next = head;
                                head = c;
                            }
                            c = next;
                        }
                        channelIDs = head;
                        if (channelIDs == null) {
                            channelIDFinalizer = null;
                            break;
                        }
                    }
                }
            }
        }
    }
}

