/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.http;

import com.sun.midp.util.DateParser;
import com.sun.squawk.Isolate;
import com.sun.squawk.VM;
import com.sun.squawk.io.ConnectionBase;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBase
implements HttpConnection {
    private static final String HTTP_PROXY_MANIFEST_PROPERTY = "com.sun.squawk.io.j2me.http.Protocol-HttpProxy";
    private int index;
    private String url;
    private String protocol = "http";
    private String host;
    private String file;
    private String ref;
    private String query;
    private int port = 80;
    private int responseCode = -1;
    private String responseMsg;
    private Hashtable reqProperties = new Hashtable();
    private Hashtable headerFields = new Hashtable();
    private String[] headerFieldNames;
    private String[] headerFieldValues;
    private String method = "GET";
    private int opens = 0;
    private boolean opened = false;
    private int mode;
    private boolean timeouts;
    private boolean connected = false;
    private PrivateInputStream in;
    private PrivateOutputStream out;
    private StreamConnection streamConnnection;
    private DataOutputStream streamOutput;
    private DataInputStream streamInput;
    private StringBuffer stringbuffer = new StringBuffer(32);
    private String http_version = "HTTP/1.1";

    public Connection open(String protocol, String url, int mode, boolean timeouts) throws IOException {
        if (protocol == null || protocol.length() == 0) {
            throw new IllegalArgumentException("Protocol cannot be null or empty");
        }
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("illegal mode: " + mode);
        }
        if (this.opened) {
            throw new IOException("already connected");
        }
        this.url = url;
        this.mode = mode;
        this.timeouts = timeouts;
        this.parseURL();
        this.opened = true;
        ++this.opens;
        return this;
    }

    public void close() throws IOException {
        if (this.opened) {
            this.opened = false;
            if (--this.opens == 0) {
                this.disconnect();
            }
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.in != null) {
            throw new IOException("already open");
        }
        if (!this.opened) {
            throw new IOException("connection is closed");
        }
        if (this.mode != 1 && this.mode != 3) {
            throw new IOException("write-only connection");
        }
        this.connect();
        ++this.opens;
        this.in = new PrivateInputStream();
        return this.in;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.mode != 2 && this.mode != 3) {
            throw new IOException("read-only connection");
        }
        if (!this.opened) {
            throw new IOException("connection is closed");
        }
        if (this.out != null) {
            throw new IOException("already open");
        }
        ++this.opens;
        this.out = new PrivateOutputStream();
        return this.out;
    }

    public String getURL() {
        return this.protocol + ":" + this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host.length() == 0 ? null : this.host;
    }

    public String getFile() {
        return this.file.length() == 0 ? null : this.file;
    }

    public String getRef() {
        return this.ref.length() == 0 ? null : this.ref;
    }

    public String getQuery() {
        return this.query.length() == 0 ? null : this.query;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public void setRequestMethod(String method) throws IOException {
        if (!(method.equals("HEAD") || method.equals("GET") || method.equals("POST"))) {
            throw new IOException("unsupported method: " + method);
        }
        this.method = method;
    }

    public String getRequestProperty(String key) {
        return (String)this.reqProperties.get(key);
    }

    public void setRequestProperty(String key, String value) throws IOException {
        if (this.connected) {
            throw new IOException("Cannot set request property when already connected");
        }
        this.reqProperties.put(key, value);
    }

    public int getResponseCode() throws IOException {
        this.connect();
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        this.connect();
        return this.responseMsg;
    }

    public long getLength() {
        try {
            this.connect();
        }
        catch (IOException x) {
            return -1L;
        }
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getType() {
        try {
            this.connect();
        }
        catch (IOException x) {
            return null;
        }
        return this.getHeaderField("content-type");
    }

    public String getEncoding() {
        try {
            this.connect();
        }
        catch (IOException x) {
            return null;
        }
        return this.getHeaderField("content-encoding");
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException x) {
            return null;
        }
        return (String)this.headerFields.get(this.toLowerCase(name));
    }

    public String getHeaderField(int index) {
        try {
            this.connect();
        }
        catch (IOException x) {
            return null;
        }
        if (this.headerFieldValues == null) {
            this.makeHeaderFieldValues();
        }
        if (index >= this.headerFieldValues.length) {
            return null;
        }
        return this.headerFieldValues[index];
    }

    public String getHeaderFieldKey(int index) {
        try {
            this.connect();
        }
        catch (IOException x) {
            return null;
        }
        if (this.headerFieldNames == null) {
            this.makeHeaderFields();
        }
        if (index >= this.headerFieldNames.length) {
            return null;
        }
        return this.headerFieldNames[index];
    }

    private void makeHeaderFields() {
        int i = 0;
        this.headerFieldNames = new String[this.headerFields.size()];
        Enumeration e = this.headerFields.keys();
        while (e.hasMoreElements()) {
            this.headerFieldNames[i++] = (String)e.nextElement();
        }
    }

    private void makeHeaderFieldValues() {
        int i = 0;
        this.headerFieldValues = new String[this.headerFields.size()];
        Enumeration e = this.headerFields.keys();
        while (e.hasMoreElements()) {
            this.headerFieldValues[i++] = (String)this.headerFields.get(e.nextElement());
        }
    }

    public int getHeaderFieldInt(String name, int def) {
        try {
            this.connect();
        }
        catch (IOException x) {
            return def;
        }
        try {
            return Integer.parseInt(this.getHeaderField(name));
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public long getHeaderFieldDate(String name, long def) {
        try {
            this.connect();
        }
        catch (IOException x) {
            return def;
        }
        try {
            return DateParser.parse(this.getHeaderField(name));
        }
        catch (Throwable t) {
            return def;
        }
    }

    protected void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            String proxyReqAdd = "";
            String httpProxy = VM.getManifestProperty(HTTP_PROXY_MANIFEST_PROPERTY);
            if (httpProxy == null) {
                httpProxy = Isolate.currentIsolate().getProperty(HTTP_PROXY_MANIFEST_PROPERTY);
            }
            if (httpProxy != null) {
                httpProxy = httpProxy.trim();
            }
            if (httpProxy != null) {
                this.streamConnnection = (StreamConnection)Connector.open("socket://" + httpProxy, 3, this.timeouts);
                proxyReqAdd = this.protocol + "://" + this.host + ":" + this.port + "/";
            } else {
                this.streamConnnection = (StreamConnection)Connector.open("socket://" + this.host + ":" + this.port, 3, this.timeouts);
            }
            this.streamOutput = this.streamConnnection.openDataOutputStream();
            this.streamInput = this.streamConnnection.openDataInputStream();
            if (this.getRequestProperty("Content-Length") == null) {
                this.setRequestProperty("Content-Length", "" + (this.out == null ? 0 : this.out.size()));
            }
            this.setRequestProperty("Host", this.host + ":" + this.port);
            String reqLine = this.method + " " + proxyReqAdd + this.getFile() + (this.getRef() == null ? "" : "#" + this.getRef()) + (this.getQuery() == null ? "" : "?" + this.getQuery()) + " " + this.http_version + "\r\n";
            this.streamOutput.write(reqLine.getBytes());
            Enumeration reqKeys = this.reqProperties.keys();
            while (reqKeys.hasMoreElements()) {
                String key = (String)reqKeys.nextElement();
                String reqPropLine = key + ": " + this.reqProperties.get(key) + "\r\n";
                this.streamOutput.write(reqPropLine.getBytes());
            }
            this.streamOutput.write("\r\n".getBytes());
            if (this.out != null) {
                this.streamOutput.write(this.out.toByteArray());
                this.streamOutput.write("\r\n".getBytes());
            }
            this.streamOutput.flush();
            this.readResponseMessage(this.streamInput);
            this.readHeaders(this.streamInput);
            if (this.responseCode == 100) {
                this.readResponseMessage(this.streamInput);
                this.readHeaders(this.streamInput);
            }
            this.connected = true;
        }
        catch (IOException e) {
            if (this.streamConnnection != null) {
                this.streamConnnection.close();
            }
            if (this.streamOutput != null) {
                this.streamOutput.close();
            }
            if (this.streamInput != null) {
                this.streamInput.close();
            }
            throw e;
        }
    }

    private void readResponseMessage(InputStream in) throws IOException {
        block3: {
            int codeEnd;
            String httpVer;
            int httpEnd;
            String line = this.readLine(in);
            this.responseCode = -1;
            this.responseMsg = null;
            if (line != null && (httpEnd = line.indexOf(32)) >= 0 && (httpVer = line.substring(0, httpEnd)).startsWith("HTTP") && line.length() > httpEnd && (codeEnd = line.substring(httpEnd + 1).indexOf(32)) >= 0 && line.length() > (codeEnd += httpEnd + 1)) {
                try {
                    this.responseCode = Integer.parseInt(line.substring(httpEnd + 1, codeEnd));
                }
                catch (NumberFormatException nfe) {
                    break block3;
                }
                this.responseMsg = line.substring(codeEnd + 1);
                return;
            }
        }
        throw new IOException("malformed response message");
    }

    private void readHeaders(InputStream in) throws IOException {
        String line;
        while ((line = this.readLine(in)) != null && !line.equals("")) {
            int colonIndex = line.indexOf(58);
            if (colonIndex < 0) {
                throw new IOException("malformed header field");
            }
            String key = line.substring(0, colonIndex);
            if (key.length() == 0) {
                throw new IOException("malformed header field");
            }
            String value = line.length() <= colonIndex + 2 ? "" : line.substring(colonIndex + 2);
            this.headerFields.put(this.toLowerCase(key), value);
        }
        return;
    }

    private String readLine(InputStream in) throws IOException {
        this.stringbuffer.setLength(0);
        while (true) {
            int c;
            if ((c = in.read()) < 0) {
                return null;
            }
            if (c == 13) continue;
            if (c == 10) break;
            this.stringbuffer.append((char)c);
        }
        return this.stringbuffer.toString();
    }

    protected void disconnect() throws IOException {
        if (this.connected) {
            if (this.streamConnnection != null) {
                if (this.streamInput != null) {
                    this.streamInput.close();
                    this.streamInput = null;
                }
                if (this.streamOutput != null) {
                    this.streamOutput.close();
                    this.streamOutput = null;
                }
                this.streamConnnection.close();
                this.streamConnnection = null;
            }
            this.responseCode = -1;
            this.responseMsg = null;
            this.connected = false;
        }
    }

    private String parseHostname() throws IOException {
        int n;
        String buf = this.url.substring(this.index);
        if (buf.startsWith("//")) {
            buf = buf.substring(2);
            this.index += 2;
        }
        if ((n = buf.indexOf(58)) < 0) {
            n = buf.indexOf(47);
        }
        if (n < 0) {
            n = buf.length();
        }
        String token = buf.substring(0, n);
        this.index += n;
        return token;
    }

    private int parsePort() throws IOException {
        int p = 80;
        String buf = this.url.substring(this.index);
        if (!buf.startsWith(":")) {
            return p;
        }
        buf = buf.substring(1);
        ++this.index;
        int n = buf.indexOf(47);
        if (n < 0) {
            n = buf.length();
        }
        try {
            p = Integer.parseInt(buf.substring(0, n));
            if (p <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException("invalid port");
        }
        this.index += n;
        return p;
    }

    private String parseFile() throws IOException {
        String token = "";
        String buf = this.url.substring(this.index);
        if (buf.length() == 0) {
            return token;
        }
        if (!buf.startsWith("/")) {
            throw new IOException("invalid path");
        }
        int n = buf.indexOf(35);
        int m = buf.indexOf(63);
        if (n < 0 && m < 0) {
            n = buf.length();
        } else if (n < 0 || m > 0 && m < n) {
            n = m;
        }
        token = buf.substring(0, n);
        this.index += n;
        return token;
    }

    private String parseRef() throws IOException {
        String buf = this.url.substring(this.index);
        if (buf.length() == 0 || buf.charAt(0) == '?') {
            return "";
        }
        if (!buf.startsWith("#")) {
            throw new IOException("invalid ref");
        }
        int n = buf.indexOf(63);
        if (n < 0) {
            n = buf.length();
        }
        this.index += n;
        return buf.substring(1, n);
    }

    private String parseQuery() throws IOException {
        String buf = this.url.substring(this.index);
        if (buf.length() == 0) {
            return "";
        }
        if (buf.startsWith("?")) {
            String token = buf.substring(1);
            int n = buf.indexOf(35);
            if (n > 0) {
                token = buf.substring(1, n);
                this.index += n;
            }
            return token;
        }
        return "";
    }

    protected synchronized void parseURL() throws IOException {
        this.index = 0;
        this.host = this.parseHostname();
        this.port = this.parsePort();
        this.file = this.parseFile();
        this.query = this.parseQuery();
        this.ref = this.parseRef();
    }

    private String toLowerCase(String string) {
        this.stringbuffer.setLength(0);
        for (int i = 0; i < string.length(); ++i) {
            this.stringbuffer.append(Character.toLowerCase(string.charAt(i)));
        }
        return this.stringbuffer.toString();
    }

    class PrivateOutputStream
    extends OutputStream {
        private ByteArrayOutputStream output = new ByteArrayOutputStream();
        private boolean opened = true;

        public void write(int b) throws IOException {
            this.output.write(b);
        }

        public void flush() throws IOException {
            if (this.output.size() > 0) {
                Protocol.this.connect();
            }
        }

        public byte[] toByteArray() {
            return this.output.toByteArray();
        }

        public int size() {
            return this.output.size();
        }

        public void close() throws IOException {
            if (this.opened) {
                this.flush();
                this.opened = false;
                if (--Protocol.this.opens == 0) {
                    Protocol.this.disconnect();
                }
            }
        }
    }

    class PrivateInputStream
    extends InputStream {
        int bytesleft = 0;
        int bytesread = 0;
        boolean chunked = false;
        boolean eof = false;
        private boolean opened = true;

        PrivateInputStream() throws IOException {
            String te = (String)Protocol.this.headerFields.get("transfer-encoding");
            if (te != null && te.equals("chunked")) {
                this.chunked = true;
                this.readChunkSize();
            }
        }

        public int available() throws IOException {
            if (this.eof) {
                return 0;
            }
            if (Protocol.this.connected) {
                if (this.bytesleft > 0) {
                    return this.bytesleft;
                }
                if (this.bytesleft <= 0 && this.chunked) {
                    this.readCRLF();
                    this.readChunkSize();
                    return this.bytesleft;
                }
                return Protocol.this.streamInput.available();
            }
            throw new IOException("connection is not open");
        }

        public int read() throws IOException {
            int ch;
            if (this.eof) {
                return -1;
            }
            if (this.bytesleft <= 0 && this.chunked) {
                this.readCRLF();
                if (this.readChunkSize() == 0) {
                    return -1;
                }
            }
            this.eof = (ch = Protocol.this.streamInput.read()) == -1;
            --this.bytesleft;
            ++this.bytesread;
            return ch;
        }

        public int read(byte[] b) throws IOException {
            long len = Protocol.this.getLength();
            len = len != -1L ? (len -= (long)this.bytesread) : (long)b.length;
            if (len == 0L) {
                this.eof = true;
                return -1;
            }
            return this.read(b, 0, (int)(len < (long)b.length ? len : (long)b.length));
        }

        private int readChunkSize() throws IOException {
            int size = -1;
            try {
                char ch;
                int i;
                String chunk = Protocol.this.readLine(Protocol.this.streamInput);
                if (chunk == null) {
                    throw new IOException("No Chunk Size");
                }
                for (i = 0; i < chunk.length() && Character.digit(ch = chunk.charAt(i), 16) != -1; ++i) {
                }
                size = Integer.parseInt(chunk.substring(0, i), 16);
            }
            catch (NumberFormatException e) {
                throw new IOException("Bogus chunk size");
            }
            this.bytesleft = size;
            this.eof = size == 0;
            return size;
        }

        private void readCRLF() throws IOException {
            int ch = Protocol.this.streamInput.read();
            if (ch != 13) {
                throw new IOException("missing CRLF");
            }
            ch = Protocol.this.streamInput.read();
            if (ch != 10) {
                throw new IOException("missing CRLF");
            }
        }

        public void close() throws IOException {
            if (this.opened) {
                this.opened = false;
                if (--Protocol.this.opens == 0) {
                    Protocol.this.disconnect();
                }
            }
        }
    }
}

