/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.mailboxes;

import com.sun.squawk.Isolate;
import com.sun.squawk.VM;
import com.sun.squawk.io.mailboxes.AddressClosedException;
import com.sun.squawk.io.mailboxes.Envelope;
import com.sun.squawk.io.mailboxes.Mailbox;
import com.sun.squawk.io.mailboxes.NoSuchMailboxException;
import com.sun.squawk.util.Assert;

public final class MailboxAddress {
    private static final int UNOWNED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private volatile int state = 0;
    private Isolate owner = null;
    private MailboxAddress otherAddress;
    private Mailbox mailbox;

    MailboxAddress(Mailbox mailbox) {
        this.mailbox = mailbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            MailboxAddress mailboxAddress = this;
            synchronized (mailboxAddress) {
                if (this.state != 1) {
                    return;
                }
                this.send(new AddressClosedEnvelope());
                this.closeLocalState();
            }
            if (this.otherAddress.isOpen()) {
                this.otherAddress.close();
            }
        }
        catch (AddressClosedException addressClosedException) {
            // empty catch block
        }
    }

    private void closeLocalState() {
        if (this.state != 1) {
            return;
        }
        this.owner.forgetMailboxAddress(this);
        this.mailbox = null;
        this.state = 2;
        this.owner = null;
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    public boolean isOwner(Isolate anIsolate) {
        return this.owner == anIsolate;
    }

    public static MailboxAddress lookupMailbox(String name, Mailbox replyMailbox) throws NoSuchMailboxException {
        Mailbox box = VM.lookupMailbox(name);
        if (box == null) {
            throw new NoSuchMailboxException(name);
        }
        MailboxAddress startingAddress = new MailboxAddress(box);
        MailboxAddress replyAddress = new MailboxAddress(replyMailbox);
        MailboxAddress finalAddress = box.callHandleOpen(startingAddress, replyAddress);
        if (finalAddress == null) {
            throw new NoSuchMailboxException(name);
        }
        finalAddress.recordAddress(Isolate.currentIsolate(), replyAddress);
        replyAddress.recordAddress(box.getOwner(), finalAddress);
        return finalAddress;
    }

    public void send(Envelope env) throws AddressClosedException {
        if (this.state == 2) {
            throw new AddressClosedException(this);
        }
        if (!this.mailbox.isOpen()) {
            this.closeLocalState();
            throw new AddressClosedException(this);
        }
        if (this.state == 0) {
            throw new IllegalStateException(this + " has not been opened for sending.");
        }
        if (Isolate.currentIsolate() != this.owner && !(env instanceof AddressClosedEnvelope)) {
            throw new IllegalStateException("Attempted send on " + this + " by " + Isolate.currentIsolate());
        }
        env.setAddresses(this);
        this.mailbox.handleMessage(env);
    }

    void send0(Envelope env) throws AddressClosedException {
        if (this.state == 2) {
            throw new AddressClosedException(this);
        }
        if (!this.mailbox.isOpen()) {
            this.closeLocalState();
            throw new AddressClosedException(this);
        }
        env.setAddresses(this);
        this.mailbox.handleMessage(env);
    }

    private void recordAddress(Isolate isolate, MailboxAddress otherAddress) {
        if (this.state != 0) {
            throw new IllegalStateException("This address has already been recorded");
        }
        if (otherAddress == null) {
            throw new IllegalArgumentException();
        }
        this.owner = isolate;
        this.owner.recordMailboxAddress(this);
        this.otherAddress = otherAddress;
        this.state = 1;
    }

    public MailboxAddress getReplyAddress() {
        if (this.otherAddress == null) {
            throw new IllegalStateException("This address has no reply address");
        }
        return this.otherAddress;
    }

    public String toString() {
        switch (this.state) {
            case 0: {
                return "MailboxAddress (UNOWNED) of " + this.mailbox.toString();
            }
            case 1: {
                return "MailboxAddress of " + this.mailbox.toString();
            }
            case 2: {
                return "MailboxAddress (CLOSED)";
            }
        }
        throw Assert.shouldNotReachHere();
    }

    static class AddressClosedEnvelope
    extends Envelope {
        AddressClosedEnvelope() {
        }

        public Object getContents() {
            return this.getToAddress();
        }
    }
}

