/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.mailboxes;

import com.sun.squawk.io.mailboxes.AddressClosedException;
import com.sun.squawk.io.mailboxes.Channel;
import com.sun.squawk.io.mailboxes.Envelope;
import com.sun.squawk.io.mailboxes.Mailbox;
import com.sun.squawk.io.mailboxes.MailboxAddress;
import com.sun.squawk.io.mailboxes.MailboxClosedException;
import com.sun.squawk.io.mailboxes.MailboxHandler;
import com.sun.squawk.io.mailboxes.MailboxInUseException;
import com.sun.squawk.util.Assert;

public final class ServerChannel {
    private Mailbox serverBox;

    private ServerChannel() {
    }

    public static ServerChannel create(String name) throws MailboxInUseException {
        Mailbox serverBox = Mailbox.create(name, new ServerChannelMailboxHandler());
        ServerChannel server = new ServerChannel();
        server.serverBox = serverBox;
        return server;
    }

    public void reOpen() throws MailboxInUseException {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        this.serverBox = Mailbox.create(this.getName(), new ServerChannelMailboxHandler());
    }

    public String getName() {
        return this.serverBox.getName();
    }

    public Channel accept() throws MailboxClosedException {
        if (!this.isOpen()) {
            throw new MailboxClosedException(this.serverBox);
        }
        try {
            NewChannelEnvelope env = (NewChannelEnvelope)this.serverBox.receive();
            return env.getData();
        }
        catch (AddressClosedException ex) {
            throw new MailboxClosedException(this.serverBox);
        }
    }

    public void close() {
        if (this.serverBox.isOpen()) {
            this.serverBox.close();
        }
    }

    public boolean isOpen() {
        return this.serverBox.isOpen();
    }

    static class NewChannelEnvelope
    extends Envelope {
        Channel newChannel;

        NewChannelEnvelope(Channel newChannel) {
            this.newChannel = newChannel;
        }

        public Object getContents() {
            return this.newChannel;
        }

        Channel getData() {
            return this.newChannel;
        }

        Envelope copy() {
            return this;
        }
    }

    static class ServerChannelMailboxHandler
    implements MailboxHandler {
        ServerChannelMailboxHandler() {
        }

        public MailboxAddress handleOpen(Mailbox originalMailbox, MailboxAddress originalAddress, MailboxAddress replyAddress) {
            Mailbox channelInBox = originalMailbox.createSubMailbox();
            MailboxAddress channeInboxAddress = new MailboxAddress(channelInBox);
            Channel newChannel = new Channel(replyAddress, channelInBox);
            try {
                originalAddress.send0(new NewChannelEnvelope(newChannel));
            }
            catch (AddressClosedException ex) {
                return null;
            }
            return channeInboxAddress;
        }

        public AddressClosedException handleClose(MailboxAddress address) {
            throw Assert.shouldNotReachHere();
        }
    }
}

