/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.peripheral;

import com.sun.squawk.peripheral.IPeripheral;
import com.sun.squawk.util.SquawkHashtable;
import com.sun.squawk.util.SquawkVector;

public class PeripheralRegistry {
    protected SquawkVector registeredPeripherals = new SquawkVector();
    protected SquawkHashtable peripheralArraysByType = new SquawkHashtable();

    public void add(IPeripheral peripheral) {
        this.registeredPeripherals.addElement(peripheral);
        this.peripheralArraysByType = null;
    }

    public IPeripheral getSingleton(Class type) {
        IPeripheral[] ofType = this.getAll(type);
        if (ofType.length == 1) {
            return ofType[0];
        }
        return null;
    }

    public IPeripheral[] getAll(Class type) {
        Object[] peripherals;
        if (this.peripheralArraysByType == null) {
            this.peripheralArraysByType = new SquawkHashtable();
        }
        if ((peripherals = (IPeripheral[])this.peripheralArraysByType.get(type)) == null) {
            SquawkVector ofType = new SquawkVector();
            int max = this.registeredPeripherals.size();
            for (int i = 0; i < max; ++i) {
                IPeripheral peripheral = (IPeripheral)this.registeredPeripherals.elementAt(i);
                if (!type.isAssignableFrom(peripheral.getClass())) continue;
                ofType.addElement(peripheral);
            }
            peripherals = new IPeripheral[ofType.size()];
            ofType.copyInto(peripherals);
            this.peripheralArraysByType.put(peripherals.getClass(), peripherals);
        }
        return peripherals;
    }

    public void removeAll(Class type) {
        this.peripheralArraysByType = null;
        int i = 0;
        while (i < this.registeredPeripherals.size()) {
            Object peripheral = this.registeredPeripherals.elementAt(i);
            if (type.isAssignableFrom(peripheral.getClass())) {
                this.registeredPeripherals.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }
}

