/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.peripheral;

import com.sun.squawk.Address;
import com.sun.squawk.VM;
import com.sun.squawk.peripheral.INorFlashSector;
import com.sun.squawk.peripheral.INorFlashSectorAllocator;
import com.sun.squawk.peripheral.InsufficientFlashMemoryException;
import com.sun.squawk.peripheral.SimulatedNorFlashSector;
import com.sun.squawk.util.UnexpectedException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;

public class SimulatedNorFlashSectorAllocator
implements INorFlashSectorAllocator {
    protected Vector sectors = new Vector();
    static /* synthetic */ Class class$com$sun$squawk$peripheral$SimulatedNorFlashSectorAllocator;

    public static SimulatedNorFlashSectorAllocator getSingleton() {
        SimulatedNorFlashSectorAllocator result = (SimulatedNorFlashSectorAllocator)VM.getPeripheralRegistry().getSingleton(class$com$sun$squawk$peripheral$SimulatedNorFlashSectorAllocator == null ? (class$com$sun$squawk$peripheral$SimulatedNorFlashSectorAllocator = SimulatedNorFlashSectorAllocator.class$("com.sun.squawk.peripheral.SimulatedNorFlashSectorAllocator")) : class$com$sun$squawk$peripheral$SimulatedNorFlashSectorAllocator);
        if (result == null) {
            result = new SimulatedNorFlashSectorAllocator();
            VM.getPeripheralRegistry().add(result);
        }
        return result;
    }

    public static void resetSingleton() {
        VM.getPeripheralRegistry().removeAll(class$com$sun$squawk$peripheral$SimulatedNorFlashSectorAllocator == null ? (class$com$sun$squawk$peripheral$SimulatedNorFlashSectorAllocator = SimulatedNorFlashSectorAllocator.class$("com.sun.squawk.peripheral.SimulatedNorFlashSectorAllocator")) : class$com$sun$squawk$peripheral$SimulatedNorFlashSectorAllocator);
    }

    public synchronized INorFlashSector getExtraSector(int purpose) throws InsufficientFlashMemoryException {
        throw new InsufficientFlashMemoryException();
    }

    public INorFlashSector[] getInitialSectors(int purpose) {
        Vector purposedSectors = new Vector();
        int max = this.sectors.size();
        for (int i = 0; i < max; ++i) {
            INorFlashSector sector = (INorFlashSector)this.sectors.elementAt(i);
            if (sector.getPurpose() != purpose) continue;
            purposedSectors.addElement(sector);
        }
        Object[] result = new INorFlashSector[purposedSectors.size()];
        purposedSectors.copyInto(result);
        return result;
    }

    public void installSectors(int numberOfSectors, int sectorSize, int purpose) {
        if (this.sectors.size() > 0) {
            boolean a = true;
        }
        boolean foundSome = false;
        String sectorsFileExtension = ".nor-flash";
        try {
            DataInputStream fileListInput = Connector.openDataInputStream("file://./");
            while (fileListInput.available() > 0) {
                String fileName = fileListInput.readUTF();
                if (!fileName.endsWith(".nor-flash")) continue;
                foundSome = true;
                SimulatedNorFlashSector memorySector = new SimulatedNorFlashSector(fileName);
                this.releaseSector(memorySector, purpose);
            }
            fileListInput.close();
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        if (!foundSome) {
            this.setupSectors(numberOfSectors, sectorSize, purpose, true);
        }
    }

    public void releaseSector(INorFlashSector sector, int purpose) {
        this.sectors.addElement(sector);
        if (this.sectors.size() > 100) {
            boolean bl = true;
        }
    }

    public void setupSectors(int numberOfSectors, int sectorSize, int purpose, boolean useFiles) {
        this.uninstallSectors();
        String sectorsFileExtension = ".nor-flash";
        try {
            DataInputStream fileListInput = Connector.openDataInputStream("file://./");
            while (fileListInput.available() > 0) {
                String fileName = fileListInput.readUTF();
                if (!fileName.endsWith(".nor-flash")) continue;
                DataOutputStream fileDeleteOutput = Connector.openDataOutputStream("deletefiles://");
                fileDeleteOutput.writeUTF(fileName);
                fileDeleteOutput.close();
            }
            fileListInput.close();
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        int address = 0;
        for (int i = 0; i < numberOfSectors; ++i) {
            SimulatedNorFlashSector memorySector = new SimulatedNorFlashSector(Address.fromPrimitive(address), sectorSize, purpose, useFiles);
            this.releaseSector(memorySector, purpose);
            address += sectorSize;
        }
    }

    public void uninstallSectors() {
        this.sectors.removeAllElements();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

