/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.pragma;

public class PragmaException
extends RuntimeException {
    public static final int HOSTED = 1;
    public static final int REPLACEMENT_CONSTRUCTOR = 2;
    public static final int INTERPRETER_INVOKED = 4;
    public static final int NATIVE = 8;
    public static final int ALLOW_INLINED = 16;
    public static final int NOT_INLINED = 32;
    public static final int FORCE_INLINED_A = 64;
    public static final int FORCE_INLINED = 80;

    public static boolean isHosted(int pragmaFlags) {
        return (pragmaFlags & 1) != 0;
    }

    public static boolean isReplacementConstructor(int pragmaFlags) {
        return (pragmaFlags & 2) != 0;
    }

    public static boolean isInterpreterInvoked(int pragmaFlags) {
        return (pragmaFlags & 4) != 0;
    }

    public static boolean isNative(int pragmaFlags) {
        return (pragmaFlags & 8) != 0;
    }

    public static boolean isForceInlined(int pragmaFlags) {
        return (pragmaFlags & 0x50) == 80;
    }

    public static boolean isAllowInlined(int pragmaFlags) {
        return (pragmaFlags & 0x10) != 0;
    }

    public static boolean isNotInlined(int pragmaFlags) {
        return (pragmaFlags & 0x20) != 0;
    }

    public static int toModifier(String className) {
        if (className.equals("com.sun.squawk.pragma.HostedPragma")) {
            return 1;
        }
        if (className.equals("com.sun.squawk.pragma.ReplacementConstructorPragma")) {
            return 2;
        }
        if (className.equals("com.sun.squawk.pragma.InterpreterInvokedPragma")) {
            return 4;
        }
        if (className.equals("com.sun.squawk.pragma.NativePragma")) {
            return 8;
        }
        if (className.equals("com.sun.squawk.pragma.ForceInlinedPragma")) {
            return 80;
        }
        if (className.equals("com.sun.squawk.pragma.NotInlinedPragma")) {
            return 32;
        }
        if (className.equals("com.sun.squawk.pragma.AllowInlinedPragma")) {
            return 16;
        }
        return 0;
    }
}

