/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.realtime;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.Offset;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.realtime.OffsetOutOfBoundsException;
import com.sun.squawk.realtime.SizeOutOfBoundsException;

public class RawMemoryAccess {
    Address vbase;
    private Offset reachable_size;

    public RawMemoryAccess(Object type, long size) throws SizeOutOfBoundsException {
        int sz = (int)size;
        if (sz < 0) {
            throw new SizeOutOfBoundsException();
        }
        this.vbase = NativeUnsafe.malloc(UWord.fromPrimitive(sz));
        if (this.vbase.isZero()) {
            throw new OutOfMemoryError("malloc failed in RawMemoryAccess");
        }
    }

    public RawMemoryAccess(Object type, long base, long size) throws SizeOutOfBoundsException, OffsetOutOfBoundsException {
        int bs = (int)base;
        int sz = (int)size;
        if (sz < 0) {
            throw new SizeOutOfBoundsException();
        }
        if (bs < 0) {
            throw new OffsetOutOfBoundsException();
        }
        this.reachable_size = Offset.fromPrimitive(sz);
        if (type instanceof RawMemoryAccess) {
            RawMemoryAccess parent = (RawMemoryAccess)type;
            if (bs + sz < 0) {
                throw new OffsetOutOfBoundsException();
            }
            if (bs + sz > parent.reachable_size.toPrimitive()) {
                throw new SizeOutOfBoundsException();
            }
            this.vbase = parent.vbase.add(bs);
        } else {
            this.vbase = Address.fromPrimitive(bs);
            if (GC.inRam(this.vbase, this.vbase.addOffset(this.reachable_size))) {
                throw new SecurityException("invalid memory range");
            }
        }
    }

    final void checkRead(int offset, int size) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (offset < 0 || offset > this.reachable_size.toPrimitive() - size) {
            throw new OffsetOutOfBoundsException();
        }
    }

    final void checkMultiRead(int offset, int number, int elemsize) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (number < 0) {
            throw new IllegalArgumentException();
        }
        int bsize = number * elemsize;
        if (bsize < 0) {
            throw new OffsetOutOfBoundsException();
        }
        if (offset < 0 || offset > this.reachable_size.toPrimitive() - bsize) {
            throw new OffsetOutOfBoundsException();
        }
    }

    public byte getByte(long offset) {
        int off = (int)offset;
        this.checkRead(off, 1);
        return (byte)NativeUnsafe.getByte(this.vbase, off);
    }

    public void getBytes(long offset, byte[] bytes, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 1);
        VM.getData(this.vbase, off, bytes, low, number, 1);
    }

    public int getInt(long offset) {
        int off = (int)offset;
        this.checkRead(off, 4);
        return NativeUnsafe.getUnalignedInt(this.vbase, off);
    }

    public void getInts(long offset, int[] ints, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 4);
        VM.getData(this.vbase, off, ints, low, number, 4);
    }

    public long getLong(long offset) {
        int off = (int)offset;
        this.checkRead(off, 8);
        return NativeUnsafe.getUnalignedLong(this.vbase, off);
    }

    public void getLongs(long offset, long[] longs, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 8);
        VM.getData(this.vbase, off, longs, low, number, 4);
    }

    public long getMappedAddress() {
        Address result = this.vbase;
        return result.toUWord().toPrimitive();
    }

    public short getShort(long offset) {
        int off = (int)offset;
        this.checkRead(off, 2);
        return (short)NativeUnsafe.getUnalignedShort(this.vbase, off);
    }

    public void getShorts(long offset, short[] shorts, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 2);
        VM.getData(this.vbase, off, shorts, low, number, 2);
    }

    public long map() throws OutOfMemoryError {
        return -1L;
    }

    public long map(long base) {
        return -1L;
    }

    public long map(long base, long size) {
        return -1L;
    }

    final void checkWrite(int offset, int size) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (offset < 0 || offset > this.reachable_size.toPrimitive() - size) {
            throw new OffsetOutOfBoundsException();
        }
    }

    final void checkMultiWrite(int offset, int number, int elemsize) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (number < 0) {
            throw new IllegalArgumentException();
        }
        int bsize = number * elemsize;
        if (bsize < 0) {
            throw new OffsetOutOfBoundsException();
        }
        if (offset < 0 || offset > this.reachable_size.toPrimitive() - bsize) {
            throw new OffsetOutOfBoundsException();
        }
    }

    public void setByte(long offset, byte value) {
        int off = (int)offset;
        this.checkWrite(off, 1);
        NativeUnsafe.setByte(this.vbase, off, value);
    }

    public void setBytes(long offset, byte[] bytes, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 1);
        VM.setData(this.vbase, off, bytes, low, number, 1);
    }

    public void setInt(long offset, int value) {
        int off = (int)offset;
        this.checkWrite(off, 4);
        NativeUnsafe.setUnalignedInt(this.vbase, off, value);
    }

    public void setInts(long offset, int[] ints, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 4);
        VM.setData(this.vbase, off, ints, low, number, 4);
    }

    public void setLong(long offset, long value) {
        int off = (int)offset;
        this.checkWrite(off, 8);
        NativeUnsafe.setUnalignedLong(this.vbase, off, value);
    }

    public void setLongs(long offset, long[] longs, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 8);
        VM.setData(this.vbase, off, longs, low, number, 8);
    }

    public void setShort(long offset, short value) {
        int off = (int)offset;
        this.checkWrite(off, 2);
        NativeUnsafe.setUnalignedShort(this.vbase, off, value);
    }

    public void setShorts(long offset, short[] shorts, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 2);
        VM.setData(this.vbase, off, shorts, low, number, 2);
    }
}

