/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.rms;

import com.sun.squawk.flash.IMemoryHeapBlock;
import com.sun.squawk.rms.IRecordEntry;
import com.sun.squawk.rms.IRmsEntryVisitor;
import com.sun.squawk.rms.RmsEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStoreException;

public class RecordEntry
extends RmsEntry
implements IRecordEntry {
    public static final int TYPE = 2;
    protected int storeId;
    protected int id;
    protected int bytesLength;
    protected int bytesOffset;
    protected byte[] bytes;

    public byte[] getBytes() {
        if (this.bytesLength == 0) {
            return null;
        }
        byte[] copy = new byte[this.bytesLength];
        System.arraycopy(this.bytes, this.bytesOffset, copy, 0, this.bytesLength);
        return copy;
    }

    public int getBytes(byte[] buffer, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        if (length > this.bytesLength) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.bytes, this.bytesOffset, buffer, offset, length);
        return length;
    }

    public int getBytesLength() {
        return this.bytesLength;
    }

    public int getId() {
        return this.id;
    }

    public int getStoreId() {
        return this.storeId;
    }

    public int getType() {
        return 2;
    }

    public void readFrom(IMemoryHeapBlock memoryBlock) throws IOException {
        super.readFrom(memoryBlock);
        DataInputStream input = memoryBlock.getDataInputStream();
        this.storeId = input.readInt();
        this.id = input.readInt();
        this.bytesLength = input.readShort();
        this.bytesOffset = memoryBlock.getOffset() + memoryBlock.getByteArrayInputStream().getPos();
        this.bytes = memoryBlock.getBytes();
        input.skip(this.bytesLength);
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.bytesOffset = offset;
        this.bytesLength = length;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStoreId(int id) {
        this.storeId = id;
    }

    public void visit(IRmsEntryVisitor visitor) throws RecordStoreException {
        visitor.visitRecord(this);
    }

    public void writeTo(DataOutputStream dataOut) throws IOException {
        super.writeTo(dataOut);
        dataOut.writeInt(this.storeId);
        dataOut.writeInt(this.id);
        dataOut.writeShort((short)this.bytesLength);
        if (this.bytesLength > 0) {
            dataOut.write(this.bytes, this.bytesOffset, this.bytesLength);
        }
    }
}

